#! /usr/local/bin/ruby -Ks
# csv2testcase
# csv -> testcase converter
# 
# 2007/09/28 0.00 garyo release 
# 2007/09/29 0.01 garyo allpairs2testcaseg悤ɕύX
# 2007/10/29 0.02 garyo GUIǉ
# 2007/10/29 0.03 ĨbZ[WύXBj[ǉ
# 2007/11/26 0.04 garyo keywordΉ

require 'csv'
require 'kconv'
require 'vr/vruby'
require '_frm_csv2testcace.rb'

class TestCase
  attr_accessor :name,:summary,:steps,:expectedresults,:keyword
  def initialize(name,summary,steps,expectedresults,keyword)
    @name=Kconv.toutf8(name)
    @summary=Kconv.toutf8(summary)
    @steps=Kconv.toutf8(steps)
    @expectedresults=Kconv.toutf8(expectedresults)
    @keyword = keyword.map!{|x|Kconv.toutf8(x)}
  end
  def getXML
    @xml =  "<testcase name=\"#{name}\">"
    @xml += "<summary><![CDATA[\n#{summary}\n]]></summary>"
    @xml += "<steps><![CDATA[\n#{steps}\n]]></steps>"
    @xml += "<expectedresults><![CDATA[\n#{expectedresults}\n]]></expectedresults>\n"
		@xml += convKeyword(@keyword) if @keyword.size > 0
    @xml += "</testcase>\n"
    @xml
  end
  def convKeyword(k)
    ret ="<keywords>\n"
    n = k.size/2
    n.times{|i|
      if k[i * 2] != nil then
        k[i * 2 + 1] ="" if k[i * 2 + 1] == nil
        ret += "<keyword name=\"#{k[i * 2]}\">\n"
        ret += "<notes><![CDATA[\n#{k[i * 2 + 1]}\n]]></notes>\n"
        ret += "</keyword>\n"
      end
    }
    ret += "</keywords>\n"
  end
end

class TestSuite
  attr_accessor :name,:details,:testcase,:testsuite
  @name
  @details
  @testcase
  @testsuite
  @xml
  def initialize(name,details)
    @name=Kconv.toutf8(name)
    @details=Kconv.toutf8(details)
    @testcase=[]
    @testsuite=[]
  end
  def addTestCase(t)
    @testcase << t
  end
  def addTestSuite(t)
    @testsuite << t
  end
  def getXML
    @xml="<testsuite name=\"#{name}\"><details><![CDATA[\n#{details}\n]]></details>\n"
    @testcase.each{|s| @xml = @xml + s.getXML}
    @testsuite.each{|s| @xml = @xml + s.getXML}
    @xml=@xml + "</testsuite>\n"
    @xml
  end
end

class AllTestSuite
  attr_accessor :testsuite
  @testsuite
  def initialize(ts)
    @testsuite=ts
  end
  def getXML
    @xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
    @xml=@xml + @testsuite.getXML
    @xml
  end
end


class Csv2testcase
  Name = 0
  Summary = 1
  Steps = 2
  Expectedresults = 3
  Keyword = 4
	attr_accessor :useTitleLine

  @testsuite
  def initialize
  end

  def initTestSuite(name,details)
    @testsuite=TestSuite.new(name,details)
  end

  def addTestcase(name,summary,steps,expectedresults,keyword)
      s=TestCase.new(name,summary,steps,expectedresults,keyword)
      @testsuite.addTestCase(s)
  end

  def readFile(infile)
    csv = CSV.open(infile, 'r')
    csv.each_with_index {|line, i|
      line.each{|d|d = "" if d == nil}
			if i == 0 and @useTitleLine == true then
				#skip title line
			else
				addTestcase(line[Name],line[Summary],line[Steps],line[Expectedresults],line[Keyword..-1])
			end
    }
  end

  def writeFile(outfile)
    f = File.open(outfile,"w")
    ats=AllTestSuite.new(@testsuite)
    f.puts ats.getXML
    f.close
  end

  def convCvs2Testcase(infile,outfile,testSuiteName)
    initTestSuite(testSuiteName,"")
    readFile(infile)
    writeFile(outfile)
  end
end


module Frm_form1
  def self_created
    
  end
  def open_clicked
  	@edit1.text=openFilenameDialog([["all(*.*)", "*.*"]],0x1000,nil,nil)
  	@edit2.text =File.basename(@edit1.text)
  end

  def exit_clicked
  	exit(0)
  end

  def doConvert_clicked
  	button2_clicked
  end

  def button2_clicked
  	if @edit1.text =="" then
			messageBox "Filename error","MSGBOX",0
		else
			cx=Csv2testcase.new
			if @checkBox1.checked? == true then
				cx.useTitleLine = true
			else
				cx.useTitleLine = false
			end
			file = @edit1.text
			wrfile = File.dirname(file) + "/" + File.basename(file, ".*") + ".xml"
			testSuiteName = @edit2.text
			cx.convCvs2Testcase(file,wrfile,testSuiteName)
			messageBox "finish","MSGBOX",0
		end
  end
end

VRLocalScreen.start Frm_form1
