#! /usr/local/bin/ruby -Ks
# pdfpagelist2testcase
# pdfpagelist -> testcase converter
# 
# 2007/11/15 0.00 garyo release 


require 'csv'
require 'kconv'
require 'vr/vruby'
require '_frm_pdfpagelist2testcace.rb'

class TestCase
  attr_accessor :name,:summary,:steps,:expectedresults
  @name
  @summary
  @steps
  @expectedresults
  @xml
  def initialize(name,summary,steps,expectedresults)
    @name=Kconv.toutf8(name)
    @summary=Kconv.toutf8(summary)
    @steps=Kconv.toutf8(steps)
    @expectedresults=Kconv.toutf8(expectedresults)
  end
  def getXML
    @xml="<testcase name=\"#{name}\">"
    @xml=@xml+"<summary><![CDATA[\n#{summary}\n]]></summary>"
    @xml=@xml+"<steps><![CDATA[\n#{steps}\n]]></steps>"
    @xml=@xml+"<expectedresults><![CDATA[\n#{expectedresults}\n]]></expectedresults>\n"
    @xml=@xml+"</testcase>\n"
    @xml
  end
end

class TestSuite
  attr_accessor :name,:details,:testcase,:testsuite
  @name
  @details
  @testcase
  @testsuite
  @xml
  def initialize(name,details)
    @name=Kconv.toutf8(name)
    @details=Kconv.toutf8(details)
    @testcase=[]
    @testsuite=[]
  end
  def addTestCase(t)
    @testcase << t
  end
  def addTestSuite(t)
    @testsuite << t
  end
  def getXML
    @xml="<testsuite name=\"#{name}\"><details><![CDATA[\n#{details}\n]]></details>\n"
    @testcase.each{|s| @xml = @xml + s.getXML}
    @testsuite.each{|s| @xml = @xml + s.getXML}
    @xml=@xml + "</testsuite>\n"
    @xml
  end
end

class AllTestSuite
  attr_accessor :testsuite
  @testsuite
  def initialize(ts)
    @testsuite=ts
  end
  def getXML
    @xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
    @xml=@xml + @testsuite.getXML
    @xml
  end
end


class Pdfpagelist2testcase
  TestcaseTitle = 0
  TestcasePage = 1

	attr_accessor :pdfFileName

  def initialize
  end

  def initTestSuite(name,details)
    @testsuite=TestSuite.new(name,details)
  end

  def addTestcase(name,summary,steps,expectedresults)
      s=TestCase.new(name,summary,steps,expectedresults)
      @testsuite.addTestCase(s)
  end

  def readFile(infile)
    pdfpagelist = CSV.open(infile, 'r')
    pdfpagelist.each_with_index {|line, i|
			if /^#/ =~ line[0] then
				#commnet
			elsif /PDF file/ =~ line[0] then
				#PDF filename
				@pdfFileName = line[1]
			elsif  /Test Suite Name/ =~ line[0] then
				#Test Suite Name
				@testsuite.name = Kconv.toutf8(line[1])
			else
				#page data
				steps="<p><a href=\"#{@pdfFileName}#page=#{line[TestcasePage]}\" target=\"_blank\">#{line[TestcaseTitle]}</a></p>"
				addTestcase(line[TestcaseTitle],line[TestcaseTitle],steps,"")
			end
    }
  end

  def writeFile(outfile)
    f = File.open(outfile,"w")
    ats=AllTestSuite.new(@testsuite)
    f.puts ats.getXML
    f.close
  end

  def convCvs2Testcase(infile,outfile,testSuiteName)
    initTestSuite(testSuiteName,"")
    readFile(infile)
    writeFile(outfile)
  end
end


module Frm_form1
  def self_created
    
  end
  def open_clicked
  	@edit1.text=openFilenameDialog([["all(*.*)", "*.*"]],0x1000,nil,nil)
  end

  def exit_clicked
  	exit(0)
  end

  def doConvert_clicked
  	button2_clicked
  end

  def button2_clicked
  	if @edit1.text =="" then
			messageBox "Filename error","MSGBOX",0
		else
			cx=Pdfpagelist2testcase.new
			file = @edit1.text
			wrfile = File.dirname(file) + "/" + File.basename(file, ".*") + ".xml"
			cx.convCvs2Testcase(file,wrfile,"testSuiteName")
			messageBox "finish","MSGBOX",0
		end
  end
end

VRLocalScreen.start Frm_form1
