#! /usr/local/bin/ruby -Ks
# csv2testcase
# csv -> testcase converter
# 
# 2007/09/28 0.00 garyo release 
# 2007/09/29 0.01 garyo allpairs2testcaseg悤ɕύX
# 2007/10/29 0.02 garyo GUIǉ

require 'csv'
require 'kconv'
require 'vr/vruby'
require '_frm_csv2testcace.rb'

class TestCase
  attr_accessor :name,:summary,:steps,:expectedresults
  @name
  @summary
  @steps
  @expectedresults
  @xml
  def initialize(name,summary,steps,expectedresults)
    @name=Kconv.toutf8(name)
    @summary=Kconv.toutf8(summary)
    @steps=Kconv.toutf8(steps)
    @expectedresults=Kconv.toutf8(expectedresults)
  end
  def getXML
    @xml="<testcase name=\"#{name}\">"
    @xml=@xml+"<summary><![CDATA[\n#{summary}\n]]></summary>"
    @xml=@xml+"<steps><![CDATA[\n#{steps}\n]]></steps>"
    @xml=@xml+"<expectedresults><![CDATA[\n#{expectedresults}\n]]></expectedresults>\n"
    @xml=@xml+"</testcase>\n"
    @xml
  end
end

class TestSuite
  attr_accessor :name,:details,:testcase,:testsuite
  @name
  @details
  @testcase
  @testsuite
  @xml
  def initialize(name,details)
    @name=Kconv.toutf8(name)
    @details=Kconv.toutf8(details)
    @testcase=[]
    @testsuite=[]
  end
  def addTestCase(t)
    @testcase << t
  end
  def addTestSuite(t)
    @testsuite << t
  end
  def getXML
    @xml="<testsuite name=\"#{name}\"><details><![CDATA[\n#{details}\n]]></details>\n"
    @testcase.each{|s| @xml = @xml + s.getXML}
    @testsuite.each{|s| @xml = @xml + s.getXML}
    @xml=@xml + "</testsuite>\n"
    @xml
  end
end

class AllTestSuite
  attr_accessor :testsuite
  @testsuite
  def initialize(ts)
    @testsuite=ts
  end
  def getXML
    @xml="<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
    @xml=@xml + @testsuite.getXML
    @xml
  end
end


class Csv2testcase
  Name = 0
  Summary = 1
  Steps = 2
  Expectedresults = 3

  @testsuite
  def initialize
  end

  def initTestSuite(name,details)
    @testsuite=TestSuite.new(name,details)
  end

  def addTestcase(name,summary,steps,expectedresults)
      s=TestCase.new(name,summary,steps,expectedresults)
      @testsuite.addTestCase(s)
  end

  def readFile(infile)
    csv = CSV.open(infile, 'r')
    csv.each_with_index {|line, i|
			addTestcase(line[Name],line[Summary],line[Steps],line[Expectedresults])
    }
  end

  def writeFile(outfile)
    f = File.open(outfile,"w")
    ats=AllTestSuite.new(@testsuite)
    f.puts ats.getXML
    f.close
  end

  def convCvs2Testcase(infile,outfile,testSuiteName)
    initTestSuite(testSuiteName,"")
    readFile(infile)
    writeFile(outfile)
  end
end


module Frm_form1
  def self_created
    
  end
  def button1_clicked
  	@edit1.text=openFilenameDialog([["all(*.*)", "*.*"]],0x1000,nil,nil)
  	@edit2.text =File.basename(@edit1.text)
  end
  def button2_clicked
  	if @edit1.text =="" then
			messageBox "Filename error","MSGBOX",0
		else
			cx=Csv2testcase.new
			file = @edit1.text
			wrfile = File.dirname(file) + "/" + File.basename(file, ".*") + ".xml"
			testSuiteName = @edit2.text
			cx.convCvs2Testcase(file,wrfile,testSuiteName)
			messageBox "end","MSGBOX",0
		end
  end
end

VRLocalScreen.start Frm_form1
