/*
 * $Id: LogUTUtil.java 5230 2007-09-28 10:04:13Z anh $
 *
 * Copyright (c) 2005 NTT DATA Corporation
 */
package jp.terasoluna.fw.file.ut;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import junit.framework.TestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.LogFactoryImpl;

/**
 * p̃[eBeBNXB
 * <p>
 * <code>Log</code> C^[tF[XNXł <code>LogFactory</code> NXłBB
 * </p>
 * @author Ec N
 * @version 1.1 2005/03/01
 */
public class LogUTUtil extends LogFactoryImpl implements Log {

    // ------------------------------------------------------- Test Properties

    /**
     * Ȍo͌ʂi[ <code>List
     * </code> IuWFNgB
     */
    private final static List<LogObject> __logObjects = Collections
            .synchronizedList(new ArrayList<LogObject>());

    // ----------------------------------------------------------- Test Method

    /**
     * ~ςꂽOIuWFNgB
     */
    public static void initialize() {
        __logObjects.clear();
    }

    /**
     * o͂ꂽÕ`FbNsB
     * <p>
     * <code>fatal, error, warn, info, debug, trace</code> ̏ɃȌo͊mFsB
     * </p>
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean check(Object message) {
        return check(message, null);
    }

    /**
     * o͂ꂽÕ`FbNsB
     * <p>
     * <code>fatal, error, warn, info, debug, trace</code> ̏ɃȌo͊mFsB
     * </p>
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean check(Object message, Throwable t) {
        return checkFatal(message, t) || checkError(message, t)
                || checkWarn(message, t) || checkInfo(message, t)
                || checkDebug(message, t) || checkTrace(message, t);
    }

    /**
     * <code>debug</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkDebug(Object message) {
        return checkDebug(message, null);
    }

    /**
     * <code>debug</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkDebug(Object message, Throwable t) {
        return searchLogObject(message, t, LogObject.DEBUG);
    }

    /**
     * <code>error</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkError(Object message) {
        return checkError(message, null);
    }

    /**
     * <code>error</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkError(Object message, Throwable t) {
        return searchLogObject(message, t, LogObject.ERROR);
    }

    /**
     * <code>fatal</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkFatal(Object message) {
        return checkFatal(message, null);
    }

    /**
     * <code>fatal</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkFatal(Object message, Throwable t) {
        return searchLogObject(message, t, LogObject.FATAL);
    }

    /**
     * <code>info</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkInfo(Object message) {
        return checkInfo(message, null);
    }

    /**
     * <code>info</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkInfo(Object message, Throwable t) {
        return searchLogObject(message, t, LogObject.INFO);
    }

    /**
     * <code>trace</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkTrace(Object message) {
        return checkTrace(message, null);
    }

    /**
     * <code>trace</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkTrace(Object message, Throwable t) {
        return searchLogObject(message, t, LogObject.TRACE);
    }

    /**
     * <code>warn</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkWarn(Object message) {
        return checkWarn(message, null);
    }

    /**
     * <code>warn</code> xŏo͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @return w肳ꂽbZ[WƗOOo͂Ăꍇ́A <code>true</code>B
     */
    public static boolean checkWarn(Object message, Throwable t) {
        return searchLogObject(message, t, LogObject.WARN);
    }

    /**
     * ̃\bhĂяoXbhAǂ̃eXgP[X\bh甭̂𒲂ׂB
     * @return ̃\bhĂяoXbh̋N\bhB
     */
    @SuppressWarnings("unchecked")
    protected static Method getCalledTestCaseMethod() {
        StackTraceElement[] elements = new Throwable().getStackTrace();
        for (int index = 0; index < elements.length; index++) {

            StackTraceElement stackTraceElement = elements[index];
            String elementClassName = stackTraceElement.getClassName();
            String elementMethodName = stackTraceElement.getMethodName();

            Class elementClass = null;
            try {
                elementClass = Class.forName(elementClassName);
            } catch (ClassNotFoundException e) {
                // do nothing.
            }

            Class targetClass = elementClass;
            while (targetClass != null) {
                if (TestCase.class.getName().equals(targetClass.getName())) {

                    if (elementMethodName.startsWith("test")) {
                        try {
                            return elementClass.getDeclaredMethod(
                                    elementMethodName, (Class[]) null);
                        } catch (SecurityException e) {
                            // do nothing.
                        } catch (NoSuchMethodException e) {
                            // do nothing.
                        }
                    }
                }

                targetClass = targetClass.getSuperclass();
            }
        }

        return null;
    }

    /**
     * ÕL[ۑAWo͂ɃOo͂B
     * @param message ObZ[W
     * @param t g[XΏۂ̗O
     * @param level Ox
     * @param logName <code>Log</code> CX^X̖O
     */
    protected synchronized static void recordLogObject(Object message,
            Throwable t, String level, String logName) {
        LogObject logObject = new LogObject(getCalledTestCaseMethod(), message,
                t, level);

        __logObjects.add(logObject);

        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(logName);
        buffer.append("]");
        buffer.append(logObject.toString());

        System.out.println(buffer);
    }

    /**
     * o͂ꂽÕ`FbNsB
     * @param message o͂Ă郁bZ[WB
     * @param t o͂ĂOB
     * @param level OxB
     * @return w肳ꂽbZ[WOo͂Ăꍇ́A <code>true</code>B
     */
    protected static boolean searchLogObject(Object message, Throwable t,
            String level) {
        LogObject logObject = new LogObject(getCalledTestCaseMethod(), message,
                t, level);
        boolean result = __logObjects.contains(logObject);
        __logObjects.remove(logObject);
        return result;
    }

    // ---------------------------------------------------- Logging Properties

    /**
     * ̃OCX^XB
     */
    private String _name;

    // ------------------------------------------------ LogFactory Constructor

    /**
     * RXgN^B
     */
    public LogUTUtil() {
        super();
        _name = LogUTUtil.class.getName();
    }

    // --------------------------------------------------- Logging Constructor

    /**
     * RXgN^B
     * @param name ȎΏۂƂȂNX
     */
    public LogUTUtil(String name) {
        super();
        _name = name;
    }

    // -------------------------------------------------------- Logging Method

    /**
     * <code>debug</code> xŃMOsȂB
     * @param message o͂郁bZ[W
     * @see org.apache.commons.logging.Log#debug(java.lang.Object)
     */
    public void debug(Object message) {
        debug(message, null);
    }

    /**
     * <code>debug</code> xŃG[MOsȂB
     * @param message o͂郁bZ[W
     * @param t ƂȂO
     * @see org.apache.commons.logging.Log#debug(java.lang.Object, java.lang.Throwable)
     */
    public void debug(Object message, Throwable t) {
        recordLogObject(message, t, LogObject.DEBUG, _name);
    }

    /**
     * <code>error</code> xŃMOsȂB
     * @param message o͂郁bZ[W
     * @see org.apache.commons.logging.Log#error(java.lang.Object)
     */
    public void error(Object message) {
        error(message, null);
    }

    /**
     * <code>error</code> xŃG[MOsȂB
     * @param message o͂郁bZ[W
     * @param t ƂȂO
     * @see org.apache.commons.logging.Log#error(java.lang.Object, java.lang.Throwable)
     */
    public void error(Object message, Throwable t) {
        recordLogObject(message, t, LogObject.ERROR, _name);
    }

    /**
     * <code>fatal</code> xŃMOsȂB
     * @param message o͂郁bZ[W
     * @see org.apache.commons.logging.Log#fatal(java.lang.Object)
     */
    public void fatal(Object message) {
        fatal(message, null);
    }

    /**
     * <code>fatal</code> xŃG[MOsȂB
     * @param message o͂郁bZ[W
     * @param t ƂȂO
     * @see org.apache.commons.logging.Log#fatal(java.lang.Object, java.lang.Throwable)
     */
    public void fatal(Object message, Throwable t) {
        recordLogObject(message, t, LogObject.FATAL, _name);
    }

    /**
     * <code>info</code> xŃMOsȂB
     * @param message o͂郁bZ[W
     * @see org.apache.commons.logging.Log#info(java.lang.Object)
     */
    public void info(Object message) {
        info(message, null);
    }

    /**
     * <code>info</code> xŃG[MOsȂB
     * @param message o͂郁bZ[W
     * @param t ƂȂO
     * @see org.apache.commons.logging.Log#info(java.lang.Object, java.lang.Throwable)
     */
    public void info(Object message, Throwable t) {
        recordLogObject(message, t, LogObject.INFO, _name);
    }

    /**
     * <code>trace</code> xŃMOsȂB
     * @param message o͂郁bZ[W
     * @since 1.1
     * @see org.apache.commons.logging.Log#trace(java.lang.Object)
     */
    public void trace(Object message) {
        trace(message, null);
    }

    /**
     * <code>trace</code> xŃG[MOsȂB
     * @param message o͂郁bZ[W
     * @param t ƂȂO
     * @see org.apache.commons.logging.Log#trace(java.lang.Object, java.lang.Throwable)
     */
    public void trace(Object message, Throwable t) {
        recordLogObject(message, t, LogObject.TRACE, _name);
    }

    /**
     * <code>warn</code> xŃMOsȂB
     * @param message o͂郁bZ[W
     * @since 1.1
     * @see org.apache.commons.logging.Log#warn(java.lang.Object)
     */
    public void warn(Object message) {
        warn(message, null);
    }

    /**
     * <code>warn</code> xŃG[MOsȂB
     * @param message o͂郁bZ[W
     * @param t ƂȂO
     * @see org.apache.commons.logging.Log#warn(java.lang.Object, java.lang.Throwable)
     */
    public void warn(Object message, Throwable t) {
        recordLogObject(message, t, LogObject.WARN, _name);
    }

    /**
     * <code>debug</code> x̃OݗLǂ`FbNB
     * @return  <code>true</code>
     * @see org.apache.commons.logging.Log#isDebugEnabled()
     */
    public boolean isDebugEnabled() {
        return true;
    }

    /**
     * <code>error</code> x̃OݗLǂ`FbNB
     * @return  <code>true</code>
     * @see org.apache.commons.logging.Log#isErrorEnabled()
     */
    public boolean isErrorEnabled() {
        return true;
    }

    /**
     * <code>fatal</code> x̃OݗLǂ`FbNB
     * @return true
     * @see org.apache.commons.logging.Log#isFatalEnabled()
     */
    public boolean isFatalEnabled() {
        return true;
    }

    /**
     * <code>info</code> x̃OݗLǂ`FbNB
     * @return  <code>true</code>
     * @see org.apache.commons.logging.Log#isInfoEnabled()
     */
    public boolean isInfoEnabled() {
        return true;
    }

    /**
     * <code>trace</code> x̃OݗLǂ`FbNB
     * @return  <code>true</code>
     * @see org.apache.commons.logging.Log#isTraceEnabled()
     */
    public boolean isTraceEnabled() {
        return true;
    }

    /**
     * <code>warn</code> x̃OݗLǂ`FbNB
     * @return  <code>true</code>
     * @see org.apache.commons.logging.Log#isWarnEnabled()
     */
    public boolean isWarnEnabled() {
        return true;
    }

    // ----------------------------------------------------- LogFactory Method

    /**
     * <code>Log</code> CX^X𐶐B
     * @param name  <code>Log</code> CX^XɕRÂOB
     * @return <code>LogUTUtil</code> CX^XB
     * @see LogFactoryImpl#newInstance(java.lang.String)
     */
    @Override
    protected Log newInstance(String name) {
        return new LogUTUtil(name);
    }

    // ------------------------------------------------------------- LogObject

    /**
     * ÕL[\NXB
     * @author Ec N
     */
    private static class LogObject {

        // ------------------------------------- LogObject Constant Properties

        /**
         * <code>debug</code> x\B
         */
        public static final String DEBUG = "DEBUG";

        /**
         * <code>error</code> x\B
         */
        public static final String ERROR = "ERROR";

        /**
         * <code>error</code> x\B
         */
        public static final String FATAL = "FATAL";

        /**
         * <code>info</code> x\B
         */
        public static final String INFO = "INFO";

        /**
         * <code>trace</code> x\B
         */
        public static final String TRACE = "TRACE";

        /**
         * <code>warn</code> x\B
         */
        public static final String WARN = "WARN";

        // ---------------------------------------------- LogObject Properties

        /**
         * ̃IuWFNg𐶐XbhɕRÂ\bhIuWFNgB
         */
        private final Method _calledMethod;

        /**
         * OxB
         */
        private final String _level;

        /**
         * ObZ[WB
         */
        private final Object _message;

        /**
         * Oo͂̌ƂȂOB
         */
        private final Throwable _t;

        // --------------------------------------------- LogObject Constructor

        /**
         * RXgN^B
         * @param calledMethod ̃IuWFNg𐶐XbhɕRÂ\bh
         * @param message ObZ[W
         * @param t Oo͂̌ƂȂO
         * @param level Ox
         */
        public LogObject(Method calledMethod, Object message, Throwable t,
                String level) {
            super();
            _calledMethod = calledMethod;
            _message = message;
            _t = t;
            _level = level;
        }

        // ---------------------------------------------------- Logging Method

        /**
         * ̃IuWFNgƑ̃IuWFNgǂB
         * @param obj rΏۂ̎QƃIuWFNg
         * @return obj Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇ <code>true</code> AłȂꍇ <code>false</code>B
         */
        @Override
        public boolean equals(Object obj) {
            LogObject other = null;
            if (obj instanceof LogObject) {
                other = (LogObject) obj;
                if (other._calledMethod == null) {
                    return false;
                }
            } else {
                return false;
            }

            if (!other._calledMethod.equals(this._calledMethod)) {
                return false;
            }

            if ((other._message == null) ? this._message != null
                    : this._message == null
                            || !other._message.equals(this._message)) {
                return false;
            }

            if ((other._t == null) ? (this._t != null) : (this._t == null)
                    || !other._t.getClass().getName().equals(
                            this._t.getClass().getName())) {
                return false;
            }

            if ((other._level == null) ? (this._level != null)
                    : (this._level == null)
                            || !other._level.equals(this._level)) {
                return false;
            }

            return true;
        }

        /**
         * ̃CX^X̏𕶎ƂĎ擾B
         * @return ̃CX^X̏
         * @since 1.1
         * @see java.lang.Object#toString()
         */
        @Override
        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[");
            buffer.append(_level);
            if (_level.length() == 4) {
                buffer.append(" ");
            }
            buffer.append("] ");
            buffer.append(_message);

            if (_t != null) {
                ByteArrayOutputStream byteArrayOutputStream = null;
                PrintStream printStream = null;
                try {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    printStream = new PrintStream(byteArrayOutputStream);
                    _t.printStackTrace(printStream);
                    buffer.append("\n");
                    buffer.append(byteArrayOutputStream.toString());
                } finally {
                    if (printStream != null) {
                        printStream.close();
                    } else if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        } catch (IOException e) {
                            // do nothing.
                        }
                    }
                }
            }

            return buffer.toString();
        }
    }

}
