/*
 * $Id:$
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.IntColumnFormatter} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Ame[VcolumnFormat̋Lqɏ]A̕ϊsB
 * <p>
 * @author c Ni
 * @see jp.terasoluna.fw.file.dao.standard.IntColumnFormatter
 */
public class IntColumnFormatterTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(IntColumnFormatterTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public IntColumnFormatterTest(String name) {
        super(name);
    }

    /**
     * testFormat01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :tB[h1X^uNX<br>
     * () t@CsIuWFNg(t)ɂint^ getter\bh<br>
     * method:ΏۂƂȂgetter\bh̉public<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * () ot@CsIuWFNg(t)int^̑: int i=3<br>
     * <br>
     * ҒlF(߂l) :methodint^ i[Ăl̕B<br>
     * "3"<br>
     * <br>
     * t@CsIuWFNgint^Ɋi[ĂIuWFNg 擾邱Ƃł邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat01() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new IntColumnFormatter();

        // ̐ݒ
        IntColumnFormatter_Stub01 t = new IntColumnFormatter_Stub01();
        Method method = t.getClass().getMethod("getIntValue");
        String columnFormat = new String();

        // O̐ݒ
        t.setIntValue(3);

        // eXg{
        String testResult = columnFormatter.format(t, method, columnFormat);

        // ԋpl̊mF
        assertEquals("3", testResult);

        // ԕω̊mF
        // Ȃ
    }

    /**
     * testFormat02() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :tB[h1X^uNX<br>
     * () t@CsIuWFNg(t)ɂint^ getter\bh<br>
     * method:ΏۂƂȂgetter\bh̉private<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * () ot@CsIuWFNg(t) int^̑:int i=0<br>
     * <br>
     * ҒlF(ԕω) O:IllegalAccessException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgint^getter\bhɃANZXłȂꍇA IllegalAccessExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat02() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new IntColumnFormatter();

        // ̐ݒ
        IntColumnFormatter_Stub02 t = new IntColumnFormatter_Stub02();
        Method method = t.getClass().getDeclaredMethod("getIntValue",
                new Class[0]);
        String columnFormat = new String();

        // O̐ݒ
        UTUtil.setPrivateField(t, "intValue", 0);

        try {
            // eXg{
            columnFormatter.format(t, method, columnFormat);
            fail("IllegalAccessExceptionX[܂łB");
        } catch (IllegalAccessException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalAccessException.class.getName(), e.getClass()
                    .getName());
        }
    }

    /**
     * testFormat03() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :tB[h1X^uNX<br>
     * () t@CsIuWFNg(t)ɂint^ getter\bh<br>
     * method:getter\bhOX[<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * () ot@CsIuWFNg(t) int^̑:int i=0<br>
     * <br>
     * ҒlF(ԕω) O:InvocationTargetException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgint^getter\bhOX[ꍇA getter\bhX[Obv InvocationTargetExceptionX[邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat03() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new IntColumnFormatter();

        // ̐ݒ
        IntColumnFormatter_Stub03 t = new IntColumnFormatter_Stub03();
        Method method = t.getClass().getMethod("getIntValue");
        String columnFormat = new String();

        // O̐ݒ
        UTUtil.setPrivateField(t, "intValue", 0);

        try {
            // eXg{
            columnFormatter.format(t, method, columnFormat);
            fail("InvocationTargetExceptionX[܂łB");
        } catch (InvocationTargetException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(InvocationTargetException.class.getName(), e
                    .getClass().getName());
        }
    }

    /**
     * testFormat04() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() t@CsIuWFNg<br>
     * :tB[h1X^uNX<br>
     * () t@CsIuWFNg(t)ɂ int^getter\bh<br>
     * method:getter̈<br>
     * () tH[}bgp̕<br>
     * columnFormat:StringCX^X<br>
     * () ot@CsIuWFNg(t) int^̑:int i=0<br>
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException邱Ƃ mFB<br>
     * <br>
     * t@CsIuWFNgint^getter\bḧꍇA IllegalArgumentExceptionX[邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    public void testFormat04() throws Exception {
        // eXgΏۂ̃CX^X
        ColumnFormatter columnFormatter = new IntColumnFormatter();

        // ̐ݒ
        IntColumnFormatter_Stub04 t = new IntColumnFormatter_Stub04();
        Method method = t.getClass().getMethod("getIntValue",
                new Class[] { int.class, String.class });
        String columnFormat = new String();

        // O̐ݒ
        UTUtil.setPrivateField(t, "intValue", 0);

        try {
            // eXg{
            columnFormatter.format(t, method, columnFormat);
            fail("IllegalArgumentExceptionX[܂łB");
        } catch (IllegalArgumentException e) {
            // ԋpl̊mF
            // Ȃ

            // ԕω̊mF
            assertEquals(IllegalArgumentException.class.getName(), e.getClass()
                    .getName());
        }
    }
}
