/*
 * $Id: FixedFileQueryDAOTest.java 5576 2007-11-15 13:13:32Z pakucn $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.FixedFileQueryDAO} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> Œ蒷t@CǎpFileLineIteratorNXB
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.FixedFileQueryDAO
 */
public class FixedFileQueryDAOTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ GUI AvP[VNB
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        // junit.swingui.TestRunner.run(FixedFileQueryDAOTest.class);
    }

    /**
     * sB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        VMOUTUtil.initialize();
    }

    /**
     * IsB
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * @param name ̃eXgP[X̖OB
     */
    public FixedFileQueryDAOTest(String name) {
        super(name);
    }

    /**
     * testExecute01() <br>
     * <br>
     * (n) <br>
     * ϓ_FE.F <br>
     * <br>
     * ͒lF() fileName:"aaa.txt"<br>
     * () clazz:not null(FileFormatAme[VX^ugp)<br>
     * () FileQueryDAO.columnParserMap:ȉ̐ݒHashMap̃CX^X<br>
     * vf1<br>
     * key:"java.lang.String"<br>
     * value:ColumnParserCX^X<br>
     * FixedFileLineIterator_ColumnParserStub01CX^X<br>
     * <br>
     * <br>
     * ҒlF(߂l) fileLineIterator:FixedFileLineIterator̃CX^X<br>
     * (ԕω) FixedFileLineIterator():FixedFileLineIterator()̃RXgN^1Ă΂B<br>
     * 1FfileName<br>
     * 2Fclazz<br>
     * 3FFileQueryDAO.columnParserMap<br>
     * <br>
     * p^[ <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testExecute01() throws Exception {
        // eXgΏۂ̃CX^X
        FixedFileQueryDAO fileQueryDAO = new FixedFileQueryDAO();

        // ̐ݒ
        URL url = FixedFileLineIteratorTest.class.getResource("/aaa.txt");
        String fileName = url.getPath();
        Class<FixedFileQueryDAO_Stub01> clazz = FixedFileQueryDAO_Stub01.class;

        // O̐ݒ
        Map<String, ColumnParser> columnParser = new HashMap<String, ColumnParser>();
        ColumnParser parser = new FixedFileQueryDAO_ColumnParserStub01();
        columnParser.put("java.lang.String", parser);
        UTUtil.setPrivateField(fileQueryDAO, "columnParserMap", columnParser);

        // eXg{
        FileLineIterator fileLineiterator = fileQueryDAO.execute(fileName,
                clazz);

        // ԋpl̊mF
        assertEquals(FixedFileLineIterator.class, fileLineiterator.getClass());

        // ԕω̊mF
        assertEquals(1, VMOUTUtil.getCallCount(FixedFileLineIterator.class,
                "<init>"));
        List arguments = VMOUTUtil.getArguments(FixedFileLineIterator.class,
                "<init>", 0);
        assertEquals(fileName, arguments.get(0));
        assertEquals(clazz, arguments.get(1));
        assertSame(columnParser, arguments.get(2));
    }
}
