/*
 * $Id: FileDAOUtilityTest.java 5230 2007-09-28 10:04:13Z anh $
 *
 * Copyright (c) 2006 NTT DATA Corporation
 *
 */

package jp.terasoluna.fw.file.dao.standard;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.annotation.TrimType;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.ut.VMOUTUtil;
import jp.terasoluna.utlib.UTUtil;

import org.junit.Before;
import org.junit.Test;

/**
 * {@link jp.terasoluna.fw.file.dao.standard.FileDAOUtility} NX̃eXgB
 * <p>
 * <h4>yNX̊Tvz</h4> pfBOAg񋟂B
 * <p>
 * @author cNi
 * @see jp.terasoluna.fw.file.dao.standard.FileDAOUtility
 */
public class FileDAOUtilityTest {

    @Before
    public void setUp() throws Exception {
        VMOUTUtil.initialize();
    }

    /**
     * testPadding01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:0<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (pfBO)<br>
     * columnBytescolumnString菬ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding01() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 0;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:1<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (pfBO)<br>
     * columnBytescolumnString̃oCgƓꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding02() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 1;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"  1"(1̍ɔpXy[X2)<br>
     * <br>
     * P[X<br>
     * (pfBO)<br>
     * columnStringɕsf[^̍paddingCharŖ߂ĕ񂪎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding03() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("  1", result);
    }

    /**
     * testPadding04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:0<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (EpfBO)<br>
     * columnBytescolumnString菬ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding04() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 0;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding05() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:1<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (EpfBO)<br>
     * columnBytescolumnString̃oCgƓꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding05() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 1;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding06() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"1  "(1̉EɔpXy[X2)<br>
     * <br>
     * P[X<br>
     * (EpfBO)<br>
     * columnStringɕsf[^̉EpaddingCharŖ߂ĕ񂪎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding06() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1  ", result);
    }

    /**
     * testPadding07() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.NONE<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (pfBOȂ)<br>
     * columnStrinĝ܂܎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding07() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.NONE;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:'@'(Sp󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Padding char is not half-width character."<br>
     * <br>
     * ُP[X<br>
     * (pfBO)<br>
     * pfBO͔pł͂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding08() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = '@';
        PaddingType paddingType = PaddingType.LEFT;

        try {
            // eXg{
            FileDAOUtility.padding(columnString, fileEncoding, columnBytes,
                    paddingChar, paddingType);
            fail("FileExceptionO܂łB");
        } catch (FileException e) {
            // 
            assertEquals("Padding char is not half-width character.", e
                    .getMessage());
        }
    }

    /**
     * testPadding09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:"XXX"<br>
     * ݂ȂGR[fBO<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"Specified Encoding : XXX is not supported"<br>
     * EOFUnsupportedEncodingException<br>
     * <br>
     * ُP[X<br>
     * (pfBO)<br>
     * ݂ȂGR[fBOw肳ꂽꍇAO邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding09() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "XXX";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        try {
            // eXg{
            FileDAOUtility.padding(columnString, fileEncoding, columnBytes,
                    paddingChar, paddingType);
            fail("FileExceptionO܂łB");
        } catch (FileException e) {
            // 
            assertEquals("Specified Encoding : XXX is not supported", e
                    .getMessage());
            assertTrue(e.getCause() instanceof UnsupportedEncodingException);
        }
    }

    /**
     * testPadding10() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:"XXX"<br>
     * ݂ȂGR[fBO<br>
     * () columnBytes:3<br>
     * () paddingChar:'@'(Sp󔒕)<br>
     * () paddingType:PaddingType.NONE<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (pfBOȂ)<br>
     * ̏ԂƊ֌WȂcolumnStrinĝ܂܎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding10() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "XXX";
        int columnBytes = 3;
        char paddingChar = '@';
        PaddingType paddingType = PaddingType.NONE;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding11() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:0<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (pfBOAΏۃf[^󕶎)<br>
     * columnBytescolumnString菬ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding11() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 0;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testPadding12() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:0<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (pfBOAΏۃf[^󕶎)<br>
     * columnBytescolumnString̃oCgƓꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding12() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 0;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testPadding13() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"!!!"<br>
     * <br>
     * P[X<br>
     * (pfBOAΏۃf[^󕶎)<br>
     * columnStringɕsf[^̍paddingCharŖ߂ĕ 擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding13() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("!!!", result);
    }

    /**
     * testPadding14() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:0<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (EpfBOAΏۃf[^󕶎)<br>
     * columnBytescolumnString菬ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding14() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 0;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testPadding15() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:0<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (EpfBOAΏۃf[^󕶎)<br>
     * columnBytescolumnString̃oCgƓꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding15() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 0;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testPadding16() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"!!!"<br>
     * <br>
     * P[X<br>
     * (EpfBOAΏۃf[^󕶎)<br>
     * columnStringɕsf[^̉EpaddingCharŖ߂ĕ 擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding16() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("!!!", result);
    }

    /**
     * testPadding17() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:'!'(p)<br>
     * () paddingType:PaddingType.NONE<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (pfBOȂAΏۃf[^󕶎)<br>
     * columnStrinĝ܂܎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding17() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = '!';
        PaddingType paddingType = PaddingType.NONE;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testPadding18() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() columnString:null<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:NullPointerExceptionB<br>
     * <br>
     * ُP[X<br>
     * columnStringnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding18() throws Exception {
        // O()
        String columnString = null;
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        try {
            // eXg{
            FileDAOUtility.padding(columnString, fileEncoding, columnBytes,
                    paddingChar, paddingType);
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // 
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testPadding19() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:null<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:NullPointerExceptionB<br>
     * <br>
     * ُP[X<br>
     * fileEncodingnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding19() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = null;
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        try {
            // eXg{
            FileDAOUtility.padding(columnString, fileEncoding, columnBytes,
                    paddingChar, paddingType);
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // 
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testPadding20() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:-3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (pfBO)<br>
     * columnBytes0菬ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding20() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = -3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding21() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:null<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * paddingTypenull̏ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding21() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = null;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testPadding22() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"P"(Sp)<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.LEFT<br>
     * <br>
     * ҒlF(߂l) :" 1"(1̍ɔpXy[X1)<br>
     * <br>
     * P[X<br>
     * (pfBOASp)<br>
     * columnStringɕsf[^̍paddingChar ߂ĕ񂪎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding22() throws Exception {
        // O()
        String columnString = "P";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.LEFT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals(" P", result);
    }

    /**
     * testPadding23() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"P"(Sp)<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"1 "(1̉EɔpXy[X1)<br>
     * <br>
     * P[X<br>
     * (EpfBOASp)<br>
     * columnStringɕsf[^̉EpaddingCharŖ߂ĕ񂪎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding23() throws Exception {
        // O()
        String columnString = "P";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.RIGHT;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("P ", result);
    }

    /**
     * testPadding24() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"P"(Sp)<br>
     * () fileEncoding:Shift_JIS<br>
     * () columnBytes:3<br>
     * () paddingChar:' '(p󔒕)<br>
     * () paddingType:PaddingType.NONE<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (pfBOȂASp)<br>
     * columnStrinĝ܂܎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testPadding24() throws Exception {
        // O()
        String columnString = "P";
        String fileEncoding = "Shift_JIS";
        int columnBytes = 3;
        char paddingChar = ' ';
        PaddingType paddingType = PaddingType.NONE;

        // eXg{
        String result = FileDAOUtility.padding(columnString, fileEncoding,
                columnBytes, paddingChar, paddingType);

        // 
        assertNotNull(result);
        assertEquals("P", result);
    }

    /**
     * testTrim01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (g)<br>
     * trimCharŐݒ肵columnStringɂȂꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim01() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testTrim02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"1aaa"<br>
     * <br>
     * P[X<br>
     * (g)<br>
     * ̍trimCharŐݒ肵ȂꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim02() throws Exception {
        // O()
        String columnString = "1aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("1aaa", result);
    }

    /**
     * testTrim03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa1aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"1aaa"<br>
     * <br>
     * P[X<br>
     * (g)<br>
     * colum̐̕擪珇trimCharŐݒ肵폜B trimCharƈقȂ镶ꂽ_ŏI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim03() throws Exception {
        // O()
        String columnString = "aaa1aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("1aaa", result);
    }

    /**
     * testTrim04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (Eg)<br>
     * trimCharŐݒ肵ȂꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim04() throws Exception {
        // O()
        String columnString = "1";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.RIGHT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testTrim05() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa1"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"aaa1"<br>
     * <br>
     * P[X<br>
     * (Eg)<br>
     * ̉EtrimCharŐݒ肵ȂꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim05() throws Exception {
        // O()
        String columnString = "aaa1";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.RIGHT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaa1", result);
    }

    /**
     * testTrim06() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa1aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"aaa1"<br>
     * <br>
     * P[X<br>
     * (Eg)<br>
     * colum̌̕납珇trimCharŐݒ肵폜BtrimCharƈقȂ镶ꂽ_ŏI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim06() throws Exception {
        // O()
        String columnString = "aaa1aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.RIGHT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaa1", result);
    }

    /**
     * testTrim07() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.NONE<br>
     * <br>
     * ҒlF(߂l) :"aaa"<br>
     * <br>
     * P[X<br>
     * (gȂ)<br>
     * p^[B<br>
     * column̂܂ܕԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim07() throws Exception {
        // O()
        String columnString = "aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.NONE;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaa", result);
    }

    /**
     * testTrim08() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() columnString:"aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:''<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Trim char is not half-width character."<br>
     * <br>
     * ُP[X<br>
     * (g)<br>
     * pfBO͔pł͂ȂꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim08() throws Exception {
        // O()
        String columnString = "aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = '';
        TrimType trimType = TrimType.LEFT;

        try {
            // eXg{
            FileDAOUtility.trim(columnString, fileEncoding, trimChar, trimType);
            fail("FileException܂łB");
        } catch (FileException e) {
            // 
            assertEquals("Trim char is not half-width character.", e
                    .getMessage());
        }
    }

    /**
     * testTrim09() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() columnString:"aaa"<br>
     * () fileEncoding:"XXX"<br>
     * ݂ȂGR[fBO<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:ȉ̐ݒFileExceptionB<br>
     * EbZ[WF"Specified Encoding : XXX is not supported"<br>
     * EOFUnsupportedEncodingException<br>
     * <br>
     * ُP[X<br>
     * (g)<br>
     * ݂ȂGR[fBOw肳ꂽꍇAO邱ƂmF <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim09() throws Exception {
        // O()
        String columnString = "aaa";
        String fileEncoding = "XXX";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        try {
            // eXg{
            FileDAOUtility.trim(columnString, fileEncoding, trimChar, trimType);
            fail("FileException܂łB");
        } catch (FileException e) {
            // 
            assertEquals("Specified Encoding : XXX is not supported", e
                    .getMessage());
            assertTrue(e.getCause() instanceof UnsupportedEncodingException);
        }
    }

    /**
     * testTrim10() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa"<br>
     * () fileEncoding:"XXX"<br>
     * ݂ȂGR[fBO<br>
     * () trimChar:''<br>
     * () trimType:TrimType.NONE<br>
     * <br>
     * ҒlF(߂l) :"aaa"<br>
     * <br>
     * P[X<br>
     * (gȂ)<br>
     * ̏ԂƊ֌WȂcolumnStrinĝ܂܎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim10() throws Exception {
        // O()
        String columnString = "aaa";
        String fileEncoding = "XXX";
        char trimChar = '';
        TrimType trimType = TrimType.NONE;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaa", result);
    }

    /**
     * testTrim11() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:' '<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (gAΏۃf[^󕶎)<br>
     * trimCharŐݒ肵columnStringɂȂꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim11() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testTrim12() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (EgAΏۃf[^󕶎)<br>
     * trimCharŐݒ肵ȂꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim12() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.RIGHT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testTrim13() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.NONE<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (gȂAΏۃf[^󕶎)<br>
     * p^[B<br>
     * column̂܂ܕԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim13() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.NONE;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testTrim14() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa1aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.BOTH<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (g)<br>
     * colum̐̕擪珇trimCharŐݒ肵폜BtrimCharƈقȂ镶ꂽ_ŏI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim14() throws Exception {
        // O()
        String columnString = "aaa1aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.BOTH;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("1", result);
    }

    /**
     * testTrim15() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:""<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.BOTH<br>
     * <br>
     * ҒlF(߂l) :"1"<br>
     * <br>
     * P[X<br>
     * (gAΏۃf[^󕶎)<br>
     * Ώۃf[^̂܂܎擾邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim15() throws Exception {
        // O()
        String columnString = "";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.BOTH;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testTrim16() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC, D, E, G <br>
     * <br>
     * ͒lF() columnString:null<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:NullPointerExceptionB<br>
     * <br>
     * ُP[X<br>
     * columnStringnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim16() throws Exception {
        // O()
        String columnString = null;
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        try {
            // eXg{
            FileDAOUtility.trim(columnString, fileEncoding, trimChar, trimType);
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // 
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testTrim17() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FC, D, E, G <br>
     * <br>
     * ͒lF() columnString:"aaa1aaa"<br>
     * () fileEncoding:null<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(ԕω) -:NullPointerExceptionB<br>
     * <br>
     * ُP[X<br>
     * fileEncodingnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim17() throws Exception {
        // O()
        String columnString = "aaa1aaa";
        String fileEncoding = null;
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        try {
            // eXg{
            FileDAOUtility.trim(columnString, fileEncoding, trimChar, trimType);
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // 
            assertTrue(e instanceof NullPointerException);
        }
    }

    /**
     * testTrim18() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaa1aaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:null<br>
     * <br>
     * ҒlF(߂l) :"aaa1aaa"<br>
     * <br>
     * P[X<br>
     * trimTypenull̏ꍇAsȂƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim18() throws Exception {
        // O()
        String columnString = "aaa1aaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = null;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaa1aaa", result);
    }

    /**
     * testTrim19() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaaaaa"<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.BOTH<br>
     * <br>
     * ҒlF(߂l) :""<br>
     * <br>
     * P[X<br>
     * (g)<br>
     * SgΏە̏ꍇA󕶎ɂȂ邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim19() throws Exception {
        // O()
        String columnString = "aaaaaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.BOTH;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("", result);
    }

    /**
     * testTrim20() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaaPaaa"iSpj<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.LEFT<br>
     * <br>
     * ҒlF(߂l) :"Paaa"<br>
     * <br>
     * P[X<br>
     * (gASp)<br>
     * colum̐̕擪珇trimCharŐݒ肵폜B trimCharƈقȂ镶ꂽ_ŏI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim20() throws Exception {
        // O()
        String columnString = "aaaPaaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.LEFT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("Paaa", result);
    }

    /**
     * testTrim21() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaaPaaa"iSpj<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.RIGHT<br>
     * <br>
     * ҒlF(߂l) :"aaaP"<br>
     * <br>
     * P[X<br>
     * (EgASp)<br>
     * colum̌̕납珇trimCharŐݒ肵폜B trimCharƈقȂ镶ꂽ_ŏI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim21() throws Exception {
        // O()
        String columnString = "aaaPaaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.RIGHT;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaaP", result);
    }

    /**
     * testTrim22() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaaPaaa"iSpj<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.NONE<br>
     * <br>
     * ҒlF(߂l) :"aaaPaaa"<br>
     * <br>
     * P[X<br>
     * (gȂASp)<br>
     * p^[B<br>
     * column̂܂ܕԋpB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim22() throws Exception {
        // O()
        String columnString = "aaaPaaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.NONE;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("aaaPaaa", result);
    }

    /**
     * testTrim23() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() columnString:"aaaPaaa"(Spj<br>
     * () fileEncoding:Shift_JIS<br>
     * () trimChar:'a'<br>
     * () trimType:TrimType.BOTH<br>
     * <br>
     * ҒlF(߂l) :"P"<br>
     * <br>
     * P[X<br>
     * (gASp)<br>
     * colum̐̕擪珇trimCharŐݒ肵폜B trimCharƈقȂ镶ꂽ_ŏI邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @Test
    public void testTrim23() throws Exception {
        // O()
        String columnString = "aaaPaaa";
        String fileEncoding = "Shift_JIS";
        char trimChar = 'a';
        TrimType trimType = TrimType.BOTH;

        // eXg{
        String result = FileDAOUtility.trim(columnString, fileEncoding,
                trimChar, trimType);

        // 
        assertNotNull(result);
        assertEquals("P", result);
    }

    /**
     * testIsHalfWidthChar01() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() fileEncoding:"Shift_JIS"<br>
     * () checkChar:','<br>
     * () encodingCache:vfȂConcurrentHashMapCX^X<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * (ԕω) encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF',' | valueFTRUE<br>
     * (ԕω) Map#put():2Ă΂<br>
     * <br>
     * P[X<br>
     * (LbVȂ)<br>
     * GR[fBOɍp͂ꂽꍇATRUEԂ邱ƂmFB<br>
     * ܂Ȁ񂪃LbVɎc邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar01() throws Exception {
        // O()
        String fileEncoding = "Shift_JIS";
        char checkChar = ',';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        // eXg{
        Object result = UTUtil.invokePrivate(FileDAOUtility.class,
                "isHalfWidthChar", new Class[] { String.class, char.class },
                new Object[] { fileEncoding, checkChar });

        // 
        assertTrue(Boolean.class.cast(result));

        assertEquals(1, encodingCache.size());
        assertTrue(encodingCache.containsKey(fileEncoding));

        Map<Character, Boolean> shiftJISCacheMap = encodingCache
                .get(fileEncoding);
        assertEquals(1, shiftJISCacheMap.size());
        assertTrue(shiftJISCacheMap.containsKey(checkChar));
        assertTrue(Boolean.class.cast(shiftJISCacheMap.get(checkChar)));

        assertEquals(2, VMOUTUtil.getCallCount(Map.class, "put"));

        // Ώۏ
        encodingCache.clear();
    }

    /**
     * testIsHalfWidthChar02() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() fileEncoding:"Shift_JIS"<br>
     * () checkChar:','<br>
     * () encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"UTF-8"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF',' | valueFTRUE<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * (ԕω) encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"UTF-8"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF',' | valueFTRUE<br>
     * ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF',' | valueFTRUE<br>
     * (ԕω) Map#put():2Ă΂<br>
     * <br>
     * P[X<br>
     * (LbVAGR[fBOɑ΂LbVȂ)<br>
     * GR[fBOɍp͂ꂽꍇATRUEԂ邱ƂmFB<br>
     * ܂Ȁ񂪃LbVɎc邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar02() throws Exception {
        // O()
        String fileEncoding = "Shift_JIS";
        char checkChar = ',';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        Map<Character, Boolean> inputEncodingCache = new ConcurrentHashMap<Character, Boolean>();

        inputEncodingCache.put(checkChar, Boolean.TRUE);
        encodingCache.put("UTF-8", inputEncodingCache);

        VMOUTUtil.initialize();

        // eXg{
        Object result = UTUtil.invokePrivate(FileDAOUtility.class,
                "isHalfWidthChar", new Class[] { String.class, char.class },
                new Object[] { fileEncoding, checkChar });

        // (߂l)
        assertTrue(Boolean.class.cast(result));

        // (encodingCache)
        assertEquals(2, encodingCache.size());

        // (UTF-8)
        assertTrue(encodingCache.containsKey("UTF-8"));
        Map<Character, Boolean> uTF8CacheMap = encodingCache.get("UTF-8");
        assertEquals(1, uTF8CacheMap.size());
        assertTrue(uTF8CacheMap.containsKey(checkChar));
        assertTrue(Boolean.class.cast(uTF8CacheMap.get(checkChar)));

        // (Shif_JIS)
        assertTrue(encodingCache.containsKey(fileEncoding));
        Map<Character, Boolean> shiftJISCacheMap = encodingCache
                .get(fileEncoding);
        assertEquals(1, shiftJISCacheMap.size());
        assertTrue(shiftJISCacheMap.containsKey(checkChar));
        assertTrue(Boolean.class.cast(shiftJISCacheMap.get(checkChar)));

        assertEquals(2, VMOUTUtil.getCallCount(Map.class, "put"));
    }

    /**
     * testIsHalfWidthChar03() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() fileEncoding:"Shift_JIS"<br>
     * () checkChar:','<br>
     * () encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF',' | valueFTRUE<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * (ԕω) encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF',' | valueFTRUE<br>
     * (ԕω) Map#put():Ă΂Ȃ<br>
     * <br>
     * P[X<br>
     * (LbVAGR[fBOE`FbNɑ΂LbV)<br>
     * GR[fBOɍp͂ꂽꍇATRUEԂ邱ƂmFB<br>
     * ܂Ȁ񂪃LbV擾ꂽƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar03() throws Exception {
        // O()
        String fileEncoding = "Shift_JIS";
        char checkChar = ',';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        Map<Character, Boolean> inputEncodingCache = new ConcurrentHashMap<Character, Boolean>();

        inputEncodingCache.put(checkChar, Boolean.TRUE);
        encodingCache.put("Shift_JIS", inputEncodingCache);

        VMOUTUtil.initialize();
        // eXg{
        Object result = UTUtil.invokePrivate(FileDAOUtility.class,
                "isHalfWidthChar", new Class[] { String.class, char.class },
                new Object[] { fileEncoding, checkChar });

        // (߂l)
        assertTrue(Boolean.class.cast(result));

        // (encodingCache)
        assertEquals(1, encodingCache.size());

        assertTrue(encodingCache.containsKey(fileEncoding));
        Map<Character, Boolean> shiftJISCacheMap = encodingCache
                .get(fileEncoding);
        assertEquals(1, shiftJISCacheMap.size());
        assertTrue(shiftJISCacheMap.containsKey(checkChar));
        assertTrue(Boolean.class.cast(shiftJISCacheMap.get(checkChar)));
        assertFalse(VMOUTUtil.isCalled(Map.class, "put"));
    }

    /**
     * testIsHalfWidthChar04() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() fileEncoding:"Shift_JIS"<br>
     * () checkChar:','<br>
     * () encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF'A' | valueFFALSE<br>
     * <br>
     * ҒlF(߂l) boolean:true<br>
     * (ԕω) encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF'A' | valueFFALSE<br>
     * - keyF',' | valueFTRUE<br>
     * (ԕω) Map#put():1Ă΂<br>
     * <br>
     * P[X<br>
     * (LbVAGR[fBOɑ΂LbV͂邪A `FbNɑ΂LbVł͂ȂB)<br>
     * GR[fBOɍp͂ꂽꍇATRUEԂ邱ƂmFB<br>
     * ܂Ȁ񂪃LbV邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar04() throws Exception {
        // O()
        String fileEncoding = "Shift_JIS";
        char checkChar = ',';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        Map<Character, Boolean> inputEncodingCache = new ConcurrentHashMap<Character, Boolean>();
        inputEncodingCache.put('A', Boolean.FALSE);
        encodingCache.put("Shift_JIS", inputEncodingCache);

        VMOUTUtil.initialize();

        // eXg{
        Object result = UTUtil.invokePrivate(FileDAOUtility.class,
                "isHalfWidthChar", new Class[] { String.class, char.class },
                new Object[] { fileEncoding, checkChar });

        // (߂l)
        assertTrue(Boolean.class.cast(result));

        // (encodingCache)
        assertEquals(1, encodingCache.size());
        assertTrue(encodingCache.containsKey(fileEncoding));

        Map<Character, Boolean> shiftJISCacheMap = encodingCache
                .get(fileEncoding);
        assertEquals(2, shiftJISCacheMap.size());
        assertTrue(shiftJISCacheMap.containsKey(checkChar));
        assertFalse(Boolean.class.cast(shiftJISCacheMap.get('A')));
        assertTrue(Boolean.class.cast(shiftJISCacheMap.get(checkChar)));

        assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
    }

    /**
     * testIsHalfWidthChar05() <br>
     * <br>
     * (n) <br>
     * ϓ_FC, D, E <br>
     * <br>
     * ͒lF() fileEncoding:"Shift_JIS"<br>
     * () checkChar:'A'<br>
     * () encodingCache:vfȂConcurrentHashMapCX^X<br>
     * <br>
     * ҒlF(߂l) boolean:false<br>
     * (ԕω) encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFȉ̗vfConcurrentHashMapCX^X<br>
     * - keyF'A' | valueFFALSE<br>
     * (ԕω) Map#put():2Ă΂<br>
     * <br>
     * P[X<br>
     * (LbVȂ)<br>
     * GR[fBOɍSp͂ꂽꍇAFALSEԂ邱ƂmFB<br>
     * ܂Ȁ񂪃LbVɎc邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar05() throws Exception {
        // O()
        String fileEncoding = "Shift_JIS";
        char checkChar = 'A';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        // eXg{
        Object result = UTUtil.invokePrivate(FileDAOUtility.class,
                "isHalfWidthChar", new Class[] { String.class, char.class },
                new Object[] { fileEncoding, checkChar });

        // (߂l)
        assertFalse(Boolean.class.cast(result));

        // (encodingCache)
        assertEquals(1, encodingCache.size());
        assertTrue(encodingCache.containsKey(fileEncoding));

        Map<Character, Boolean> shiftJISCacheMap = encodingCache
                .get(fileEncoding);
        assertEquals(1, shiftJISCacheMap.size());
        assertTrue(shiftJISCacheMap.containsKey(checkChar));
        assertFalse(Boolean.class.cast(shiftJISCacheMap.get(checkChar)));

        assertEquals(2, VMOUTUtil.getCallCount(Map.class, "put"));

        // Ώۏ
        encodingCache.clear();
    }

    /**
     * testIsHalfWidthChar06() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileEncoding:"XXX"<br>
     * () checkChar:','<br>
     * () encodingCache:vfȂConcurrentHashMapCX^X<br>
     * <br>
     * ҒlF(ԕω) encodingCache:ȉ̗vfConcurrentHashMapCX^X<br>
     * EkeyF"Shift_JIS"<br>
     * valueFvfȂConcurrentHashMapCX^X<br>
     * (ԕω) Map#put():1Ă΂<br>
     * (ԕω) -:ȉ̏FileExceptionB<br>
     * EbZ[WF"Specified Encoding : XXX is not supported"<br>
     * EOFUnsupportedEncodingException<br>
     * <br>
     * ُP[X<br>
     * (LbVȂ)<br>
     * ݂ȂGR[fBO͂ꂽꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar06() throws Exception {
        // O()
        String fileEncoding = "XXX";
        char checkChar = ',';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        try {
            // eXg{
            UTUtil.invokePrivate(FileDAOUtility.class, "isHalfWidthChar",
                    new Class[] { String.class, char.class }, new Object[] {
                            fileEncoding, checkChar });
            fail("FileException܂łB");
        } catch (FileException e) {
            // (O)
            assertTrue(e instanceof FileException);
            assertEquals("Specified Encoding : XXX is not supported", e
                    .getMessage());
            assertTrue(e.getCause() instanceof UnsupportedEncodingException);

            // (encodingCache)
            assertEquals(1, encodingCache.size());

            assertTrue(encodingCache.containsKey(fileEncoding));
            Map<Character, Boolean> shiftJISCacheMap = encodingCache
                    .get(fileEncoding);
            assertEquals(0, shiftJISCacheMap.size());
            assertEquals(1, VMOUTUtil.getCallCount(Map.class, "put"));
        }

        // Ώۏ
        encodingCache.clear();
    }

    /**
     * testIsHalfWidthChar07() <br>
     * <br>
     * (ُn) <br>
     * ϓ_FG <br>
     * <br>
     * ͒lF() fileEncoding:null<br>
     * () checkChar:','<br>
     * () encodingCache:vfȂConcurrentHashMapCX^X<br>
     * <br>
     * ҒlF(ԕω) encodingCache:vfȂConcurrentHashMapCX^X<br>
     * (ԕω) Map#put():Ă΂Ȃ<br>
     * (ԕω) -:NullPointerExceptionB<br>
     * <br>
     * ُP[X<br>
     * (LbVȂ)<br>
     * GR[fBOnull̏ꍇAO邱ƂmFB <br>
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testIsHalfWidthChar07() throws Exception {
        // O()
        String fileEncoding = null;
        char checkChar = ',';

        // O()
        Map<String, Map<Character, Boolean>> encodingCache = (Map<String, Map<Character, Boolean>>) UTUtil
                .getPrivateField(FileDAOUtility.class, "encodingCache");
        encodingCache.clear();

        try {
            // eXg{
            UTUtil.invokePrivate(FileDAOUtility.class, "isHalfWidthChar",
                    new Class[] { String.class, char.class }, new Object[] {
                            fileEncoding, checkChar });
            fail("NullPointerException܂łB");
        } catch (NullPointerException e) {
            // (O)
            assertTrue(e instanceof NullPointerException);
            assertEquals(0, encodingCache.size());
            assertFalse(VMOUTUtil.isCalled(Map.class, "put"));
        }
    }
}
