/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import jp.terasoluna.fw.batch.message.MessageAccessor;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import jp.terasoluna.fw.util.PropertyUtil;
import junit.framework.TestCase;

import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 * O<br>
 * <br>
 * Esrc/test/resourcestH_zAppricationResources.properties݂邱ƁB<br>
 * <br>
 * EvpeBMessageAccessor.default̒lݒ肳Ă邱ƁB<br>
 * <fieldset><legend>batch.propertiesݒ</legend> #bZ[W\[XANZTBean<br>
 * MessageAccessor.default=msgAcc </fieldset> <br>
 * EBean`t@CɃvpeBŐݒ肳ꂽ̒lBeanݒ肳Ă邱ƁB<br>
 * <fieldset><legend>AdminContext.xmlݒ</legend> &lt;!-- bZ[WANZT --&gt;<br>
 * &lt;bean id=&quot;msgAcc&quot; class=&quot;jp.terasoluna.fw.batch.message.MessageAccessorImpl&quot; /&gt; </fieldset> <br>
 * Emessages.propertiest@C݂邱<br>
 */
public class MessageUtilTest extends TestCase {

    /**
     * vpeBl擾l
     */
    private String value = null;

    /**
     * Reip̃tB[h
     */
    private ApplicationContext context;

    /**
     * MessageAccessorNX̃tB[h
     */
    private MessageAccessor messageAccessor;

    @Override
    protected void setUp() throws Exception {

        // bZ[W\[XANZTBean擾
        context = new ClassPathXmlApplicationContext(
                "beansDef/AdminContext.xml");
        value = PropertyUtil.getProperty("messageAccessor.default");
        messageAccessor = (MessageAccessor) context.getBean(value,
                MessageAccessor.class);
        MessageUtil.setMessageAccessor(messageAccessor);
    }

    /**
     * testGetMessage01()<br>
     * <br>
     * OԁFmessages.propertieserrors.alphaNumericStringݒ肳Ă邱<br>
     * <br>
     * eXgTvFbZ[WL[ɊY郁bZ[W𐳏Ɏ擾邱Ƃł邱ƂmF<br>
     * <br>
     * mFځFvpeBɐݒ肵bZ[W擾Ă邱ƂmF<br>
     * <br>
     * @throws Exception
     */
    public void testGetMessage01() throws Exception {

        String result = MessageUtil.getMessage("errors.alphaNumericString");

        assertEquals("{0}ɂ͔ppœ͂Ă.", result);
    }

    /**
     * testGetMessage02()<br>
     * <br>
     * OԁFerrors.alphaNumericStringݒ肳Ă邱<br>
     * <br>
     * eXgTvFp[^1bZ[WL[ɊY郁bZ[W𐳏Ɏ擾邱Ƃł邱ƂmF<br>
     * <br>
     * mFځFvpeBɐݒ肵bZ[W擾Ă邱ƂmF<br>
     * <br>
     * @throws Exception
     */
    public void testGetMessage02() throws Exception {

        String[] args = { "test1" };
        String result = MessageUtil.getMessage("errors.alphaNumericString",
                args);

        assertEquals("test1ɂ͔ppœ͂Ă.", result);
    }

    /**
     * testGetMessage03()<br>
     * <br>
     * OԁFerrors.rangeݒ肳Ă邱<br>
     * <br>
     * eXgTvFp[^RbZ[WL[ɊY郁bZ[W𐳏Ɏ擾邱Ƃł邱ƂmF<br>
     * <br>
     * mFځFvpeBɐݒ肵bZ[W擾Ă邱ƂmF<br>
     * <br>
     * @throws Exception
     */
    public void testGetMessage03() throws Exception {

        Object[] args = { "test1", 10, 20 };
        String result = MessageUtil.getMessage("errors.range", args);

        assertEquals("test1ɂ1020܂ł͈̔͂œ͂Ă.", result);
    }

    /**
     * testGetMessage04()<br>
     * <br>
     * OԁFtestƂbZ[WL[ݒ肳ĂȂ<br>
     * <br>
     * eXgTvFbZ[WL[ɊY郁bZ[W擾邱ƂłȂƂmF<br>
     * <br>
     * mFځFG[bZ[W擾Ă邱ƂmF<br>
     * <br>
     * @throws Exception
     */
    public void testGetMessage04() throws Exception {

        String[] args = { "test1" };
        String result = MessageUtil.getMessage("test", args);

        assertNotNull(result);
        assertEquals("Message not found. CODE:[test]", result);
    }

    /**
     * testGetMessage04()<br>
     * <br>
     * eXgTvFnullݒ肵ꍇɊY郁bZ[W擾邱ƂłȂƂmF<br>
     * <br>
     * mFځFG[bZ[W擾Ă邱ƂmF<br>
     * <br>
     * @throws Exception
     */
    public void testGetMessage05() throws Exception {

        String result = MessageUtil.getMessage(null);

        assertNotNull(result);
        assertEquals("Message not found. CODE:[null]", result);
    }

    /**
     * testGetMessage06
     */
    public void testGetMessage06() {
        Thread th = Thread.currentThread();
        ThreadGroup g = th.getThreadGroup();
        try {
            ReflectionUtils.setField(th, "group", null);
            String result = MessageUtil.getMessage("hoge");
            assertEquals("Message not found. CODE:[hoge]", result);
        } finally {
            ReflectionUtils.setField(th, "group", g);
        }
    }

    /**
     * testSetMessageAccessor01
     * @throws Exception
     */
    public void testSetMessageAccessor01() throws Exception {
        MessageUtil.setMessageAccessor(null);
        assertTrue(true);
    }

    /**
     * testRemoveMessageAccessor01
     * @throws Exception
     */
    public void testRemoveMessageAccessor01() throws Exception {
        MessageUtil.removeMessageAccessor();
        assertTrue(true);
    }

    /**
     * testGetThreadGroup01
     * @throws Exception
     */
    public void testGetThreadGroup01() throws Exception {
        // Thread.currentThread().setContextClassLoader(null);
        ReflectionUtils.invoke(MessageUtil.class, "getThreadGroup");
        // MessageUtil.getThreadGroup();
        assertTrue(true);
    }

    /**
     * testMessageUtil001
     * @throws Exception
     */
    public void testMessageUtil001() throws Exception {
        MessageUtil mu = new MessageUtil();
        assertNotNull(mu);
    }

}
