/**
 * 
 */
package jp.terasoluna.fw.collector.db;

import java.util.List;

import jp.terasoluna.fw.collector.CollectorTestUtil;
import jp.terasoluna.fw.collector.util.MemoryInfo;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import jp.terasoluna.fw.ex.unit.testcase.DaoTestCase;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

/**
 * DBCollectorTest
 * Call̓mFƁADBCollectorPrePostProcessAg̊mFp
 */
public class DBCollector007Test extends DaoTestCase {

    /**
     * Log.
     */
    private static Log logger = LogFactory.getLog(DBCollector007Test.class);

    private QueryRowHandleDAO queryRowHandleDAO = null;

    private int previousThreadCount = 0;

    @Override
    protected void addConfigLocations(List<String> configLocations) {
        configLocations.add("jp/terasoluna/fw/collector/db/dataSource.xml");
    }

    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    @Override
    protected void onSetUp() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        super.onSetUp();
    }

    @Override
    protected void onTearDown() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        CollectorTestUtil.allInterrupt();
        super.onTearDown();
    }

    /**
     * Call()̃eXgigC@\j
     * Call()\bh̏ɂāAexpStatusRETRY̎Ƀ[vJԂs邱ƂmF
     */
    @Test
    public void testCall001() {
    	DBCollectorPrePostProcessStub002 dbcppp = new DBCollectorPrePostProcessStub002();
    	// config̈Ɏw肵SQLID݂͑Ȃe[uQƁiCallExceptionNj
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setExecuteByConstructor(true);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	try {
    		dbc.call();
    	} catch (Exception e) {
    		fail();
    	}
    	
    	assertTrue(dbcppp.getRetryFlag());
    	
    }
    
    /**
     * Call()̃eXg
     * SQLsɃG[Iꍇ
     * @throws Exception
     */
    @Test
    public void testCall002() throws Exception {
    	DBCollectorPrePostProcessStub004 dbcppp = new DBCollectorPrePostProcessStub004();
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserList", null);
    	config.setExecuteByConstructor(true);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	dbc.rowHandler = new QueueingDataRowHandlerImpl();
    	Integer returncode = new Integer(99);
    	
    	// Calls
    	try {
    		returncode = dbc.call();
    	} catch (Exception e) {
    		fail();
    	}
    	
    	// Call߂lmF
    	assertEquals(0, returncode.intValue());
    	// PrePostProcesssʊmF
    	assertTrue(dbcppp.getExecPreprocFlg());
    	assertTrue(dbcppp.getExecPostProcCompFlg());
    	assertFalse(dbcppp.getExecPostProcExcpFlg());
    }

    /**
     * Call()̃eXg
     * SQLsɃG[AG[̃Xe[^XTHROWłꍇ
     * @throws Exception
     */
    @Test
    public void testCall003() throws Exception {
    	DBCollectorPrePostProcessStub004 dbcppp = new DBCollectorPrePostProcessStub004();
    	// config̈Ɏw肵SQLID݂͑Ȃe[uQƁiCallExceptionNj
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setExecuteByConstructor(true);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	dbc.rowHandler = new QueueingDataRowHandlerImpl();
    	Integer returncode = new Integer(99);
    	
    	// Calls
    	try {
    		returncode = dbc.call();
    	} catch (Exception e) {
    		fail();
    	}
    	
    	// Call߂lmF
    	assertEquals(-1, returncode.intValue());
    	// PrePostProcesssʊmF
    	assertTrue(dbcppp.getExecPreprocFlg());
    	assertTrue(dbcppp.getExecPostProcCompFlg());
    	assertTrue(dbcppp.getExecPostProcExcpFlg());
    }

    /**
     * Call()̃eXg
     * SQLsɃG[AG[̃Xe[^XNULLłꍇ
     * @throws Exception
     */
    @Test
    public void testCall004() throws Exception {
    	DBCollectorPrePostProcessStub005 dbcppp = new DBCollectorPrePostProcessStub005();
    	// config̈Ɏw肵SQLID݂͑Ȃe[uQƁiCallExceptionNj
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setExecuteByConstructor(true);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	dbc.rowHandler = new QueueingDataRowHandlerImpl();
    	Integer returncode = new Integer(99);
    	
    	// Calls
    	try {
    		returncode = dbc.call();
    	} catch (Exception e) {
    		fail();
    	}
    	
    	// Call߂lmF
    	assertEquals(-1, returncode.intValue());
    	// PrePostProcesssʊmF
    	assertTrue(dbcppp.getExecPreprocFlg());
    	assertTrue(dbcppp.getExecPostProcCompFlg());
    	assertTrue(dbcppp.getExecPostProcExcpFlg());
    }

    /**
     * Call()̃eXg
     * SQLsɃG[AG[̃Xe[^XENDłꍇ
     * @throws Exception
     */
    @Test
    public void testCall005() throws Exception {
    	DBCollectorPrePostProcessStub006 dbcppp = new DBCollectorPrePostProcessStub006();
    	// config̈Ɏw肵SQLID݂͑Ȃe[uQƁiCallExceptionNj
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setExecuteByConstructor(true);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	dbc.rowHandler = new QueueingDataRowHandlerImpl();
    	Integer returncode = new Integer(99);
    	
    	// Calls
    	try {
    		returncode = dbc.call();
    	} catch (Exception e) {
    		fail();
    	}
    	
    	// Call߂lmF
    	assertEquals(0, returncode.intValue());
    	// PrePostProcesssʊmF
    	assertTrue(dbcppp.getExecPreprocFlg());
    	assertTrue(dbcppp.getExecPostProcCompFlg());
    	assertTrue(dbcppp.getExecPostProcExcpFlg());
    }
    
    /**
     * Call()̃eXg
     * SQLsɃG[AG[̃Xe[^XRETRYłꍇ
     * @throws Exception
     */
//    @Test
//    public void testCall00x() throws Exception {
//    	// testCall001Ɠed邽ߏȗ
//    	fail();
//    }
    
    
    /**
     * preprocess()̃eXg
     * DBCollectorDBCollectorPrePostProcess#preprocess(DBCollector<P> collector)
     * ւ̒l̎󂯓nɂł邱ƂmF
     */
    @Test
    public void testPreprocess001() throws Exception{
    	DBCollectorPrePostProcessStub003 dbcppp = new DBCollectorPrePostProcessStub003();
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	// preprocesssO̊mFirowHandlernullj
    	assertNull(dbc.rowHandler);
    	
    	// preprocesssip[^ɓnrowHandlerݒ肳j
    	dbc.preprocess();
    	
    	// preprocesssmFirowHandlerݒ肳Ă邱Ɓj
    	assertTrue(dbc.rowHandler instanceof QueueingDataRowHandlerImpl);
    }

    /**
     * postprocessException(Throwable th)̃eXg
     * DBCollectorDBCollectorPrePostProcess#postprocessException(DBCollector<P> collector, Throwable throwable)
     * ւ̒l̎󂯓nɂł邱ƂmF
     */
    @Test
    public void testPostprocessException001() throws Exception {
    	DBCollectorPrePostProcessStub003 dbcppp = new DBCollectorPrePostProcessStub003();
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	
    	Exception ex = new Exception("postprocessExceptioneXg");
    	// preprocesssip[^ɓnDBCollectorPreProcessStatus.THROW߂lɂȂj
    	DBCollectorPrePostProcessStatus status = dbc.postprocessException(ex);
    	
    	// preprocesssmFistatusTHROWȂOKj
    	assertEquals(DBCollectorPrePostProcessStatus.THROW, status);

    }

    /**
     * postprocessComplete()̃eXg
     * DBCollectorDBCollectorPrePostProcess#postprocessComplete(DBCollector<P> collector)
     * ւ̒l̎󂯓nɂł邱ƂmF
     */
    @Test
    public void testPostprocessComplete001() throws Exception {
    	DBCollectorPrePostProcessStub003 dbcppp = new DBCollectorPrePostProcessStub003();
    	DBCollectorConfig config = new DBCollectorConfig(
    			this.queryRowHandleDAO, "selectUserListDummy", null);
    	config.setDbCollectorPrePostProcess(dbcppp);
    	DBCollector<UserBean> dbc = new DBCollector<UserBean>(config);
    	// preprocesssO̊mFirowHandlernullj
    	assertNull(dbc.rowHandler);
    	
    	// preprocesssip[^ɓnrowHandlerݒ肳j
    	dbc.postprocessComplete();
    	
    	// preprocesssmFirowHandlerݒ肳Ă邱Ɓj
    	assertTrue(dbc.rowHandler instanceof QueueingDataRowHandlerImpl);

    }
}
