/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.db;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jp.terasoluna.fw.collector.db.DBCollector;
import jp.terasoluna.fw.collector.db.InterruptedRuntimeException;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandler;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueingDataRowHandlerImpl
implements QueueingDataRowHandler {
    private static final TLogger LOGGER = TLogger.getLogger(QueueingDataRowHandlerImpl.class);
    protected static AtomicBoolean verboseLog = new AtomicBoolean(false);
    protected Object prevRow = null;
    protected DBCollector<?> dbCollector = null;
    protected AtomicLong dataCount = new AtomicLong(0L);

    public void handleRow(Object valueObject) {
        if (Thread.currentThread().isInterrupted()) {
            if (verboseLog.get()) {
                LOGGER.trace("TAL041003");
            }
            throw new InterruptedRuntimeException();
        }
        this.delayCollect();
        this.prevRow = valueObject;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delayCollect() {
        if (this.prevRow == null) return;
        if (!Thread.currentThread().isInterrupted()) {
            long dtcnt = this.dataCount.incrementAndGet();
            try {
                if (this.dbCollector == null) return;
                this.dbCollector.addQueue(new DataValueObject(this.prevRow, dtcnt));
                return;
            }
            catch (InterruptedException e) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("TAL041002", new Object[]{Thread.currentThread().getName()});
                }
                Thread.currentThread().interrupt();
                throw new InterruptedRuntimeException(e);
            }
        } else {
            if (!verboseLog.get()) throw new InterruptedRuntimeException();
            LOGGER.trace("TAL041003");
            throw new InterruptedRuntimeException();
        }
    }

    @Override
    public void setDbCollector(DBCollector<?> dbCollector) {
        this.dbCollector = dbCollector;
    }

    public static void setVerbose(boolean verbose) {
        verboseLog.set(verbose);
    }
}

