/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import jp.terasoluna.fw.batch.exception.BatchException;
import jp.terasoluna.fw.batch.executor.vo.BatchJobData;
import jp.terasoluna.fw.batch.executor.vo.BatchJobListParam;
import jp.terasoluna.fw.batch.executor.vo.BatchJobListResult;
import jp.terasoluna.fw.batch.executor.vo.BatchJobManagementParam;
import jp.terasoluna.fw.batch.executor.vo.BatchJobManagementUpdateParam;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;
import org.springframework.dao.DataAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobUtil {
    private static final TLogger LOGGER = TLogger.getLogger(JobUtil.class);

    protected JobUtil() {
    }

    public static List<BatchJobListResult> selectJobList(QueryDAO queryDAO) {
        return JobUtil.selectJobList(null, queryDAO);
    }

    public static List<BatchJobListResult> selectJobList(QueryDAO queryDAO, int beginIndex, int maxCount) {
        return JobUtil.selectJobList(null, queryDAO, beginIndex, maxCount);
    }

    public static List<BatchJobListResult> selectJobList(String jobAppCd, QueryDAO queryDAO) {
        return JobUtil.selectJobList(jobAppCd, queryDAO, -1, -1);
    }

    public static List<BatchJobListResult> selectJobList(String jobAppCd, QueryDAO queryDAO, int beginIndex, int maxCount) {
        ArrayList<String> curAppStatusList = new ArrayList<String>();
        curAppStatusList.add("0");
        return JobUtil.selectJobList(jobAppCd, curAppStatusList, queryDAO, beginIndex, maxCount);
    }

    public static List<BatchJobListResult> selectJobList(String jobAppCd, List<String> curAppStatusList, QueryDAO queryDAO, int beginIndex, int maxCount) {
        BatchJobListParam param = new BatchJobListParam();
        param.setJobAppCd(jobAppCd);
        if (curAppStatusList != null) {
            param.setCurAppStatusList(curAppStatusList);
        }
        List result = null;
        try {
            result = beginIndex == -1 || maxCount == -1 ? queryDAO.executeForObjectList("batchExecutor.selectJobList", (Object)param) : queryDAO.executeForObjectList("batchExecutor.selectJobList", (Object)param, beginIndex, maxCount);
        }
        catch (Exception e) {
            throw new BatchException(LOGGER.getLogMessage("EAL025039", new Object[0]), e);
        }
        return result;
    }

    public static BatchJobData selectJob(String jobSequenceId, boolean forUpdate, QueryDAO queryDAO) {
        BatchJobData result;
        block3: {
            BatchJobManagementParam param = new BatchJobManagementParam();
            param.setJobSequenceId(jobSequenceId);
            param.setForUpdate(forUpdate);
            result = null;
            try {
                result = (BatchJobData)queryDAO.executeForObject("batchExecutor.selectJob", (Object)param, BatchJobData.class);
            }
            catch (Exception e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("EAL025040", (Throwable)e);
                }
                if (!(e instanceof DataAccessException)) break block3;
                throw (DataAccessException)((Object)e);
            }
        }
        return result;
    }

    public static boolean updateJobStatus(String jobSequenceId, String curAppStatus, String jobRetCount, String blogicAppStatus, QueryDAO queryDAO, UpdateDAO updateDAO) {
        BatchJobManagementUpdateParam param = new BatchJobManagementUpdateParam();
        param.setJobSequenceId(jobSequenceId);
        param.setBLogicAppStatus(blogicAppStatus);
        param.setCurAppStatus(curAppStatus);
        Timestamp updDateTime = JobUtil.getCurrentTime(queryDAO);
        param.setUpdDateTime(updDateTime);
        int count = -1;
        try {
            count = updateDAO.execute("batchExecutor.updateJobTable", (Object)param);
        }
        catch (Exception e) {
            LOGGER.error("EAL025041", (Throwable)e);
            if (e instanceof DataAccessException) {
                throw (DataAccessException)((Object)e);
            }
            return false;
        }
        if (count != 1) {
            LOGGER.error("EAL025042");
            return false;
        }
        return true;
    }

    @Deprecated
    public static Timestamp getCurrentTime(QueryDAO queryDAO) {
        Timestamp result;
        block2: {
            result = null;
            try {
                result = (Timestamp)queryDAO.executeForObject("batchExecutor.currentTimeReader", null, Timestamp.class);
            }
            catch (Exception e) {
                LOGGER.error("EAL025043", (Throwable)e);
                if (!(e instanceof DataAccessException)) break block2;
                throw (DataAccessException)((Object)e);
            }
        }
        return result;
    }

    @Deprecated
    public static Date getCurrentDate(QueryDAO queryDAO) {
        Date result = null;
        try {
            result = (Date)queryDAO.executeForObject("batchExecutor.currentDateReader", null, Date.class);
        }
        catch (Exception e) {
            LOGGER.error("EAL025043", (Throwable)e);
        }
        return result;
    }

    public static String getenv(String name) {
        String ret = System.getenv(name);
        if (ret == null) {
            return "";
        }
        return ret;
    }
}

