/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

import junit.framework.TestCase;

/**
 * 
 * StringUtil ubN{bNXeXgB<br>
 * 
 * (O)<br>
 * @EvpeBt@CɁAȉ̃L[ƒlɋLqĂ邱<br>
 * @@@Oo̓fBNg(log4j.file.dir)<br> 
 * @@@Ot@C(log4j.file.name)<br>
 *
 */
@SuppressWarnings("unused")
public class StringUtilTest extends TestCase {

    /**
     * t@COo͐̃fBNgvpeB擾L[lB
     */
    public static final String FILE_DIR = "log4j.file.dir";

    /**
     * t@COo͐̃t@CvpeB擾L[lB
     *
     */
    private static final String FILE_NAME = "log4j.file.name";

    /**
     * sOSŗpsR[h擾L[l
     * 
     */
    private static final String LINE_SEP = System.getProperty("line.separator");

    /**
     * t@COo͐̐΃pXB
     *
     */
    String LOG_FILE_NAME = PropertyUtil.getProperty(FILE_DIR) + "/"
            + PropertyUtil.getProperty(FILE_NAME);

    /**
     * Constructor for StringUtilTest.
     * @param arg0
     */
    public StringUtilTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     * @throws Exception O */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     * @throws Exception O */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * testIsWhitespace01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFpXy[X<br>
     * 
     * ҒlFtrue<br>
     * 
     * pXy[XLN^͂Atrue<br>
     * ԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testIsWhitespace01() throws Exception {
        // ͒l̐ݒ
        char input = ' ';

        // eXgsƌʊmF
        assertTrue(StringUtil.isWhitespace(input));
    }

    /**
     * testIsWhitespace02()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFp<br>
     * 
     * ҒlFfalse<br>
     * 
     * ppLN^͂Afalse<br>
     * ԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testIsWhitespace02() throws Exception {
        // ͒l̐ݒ
        char input = 'a';

        // eXgsƌʊmF
        assertFalse(StringUtil.isWhitespace(input));
    }

    /**
     * testIsWhitespace03()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lF0<br>
     * 
     * ҒlFfalse<br>
     * 
     * 0LN^ݒ肵Afalseԋp邱<br>
     * 
     * @throws Exception O */
    public void testIsWhitespace03() throws Exception {
        // ͒l̐ݒ
        //char input = '\u0000';
        char input = 0;

        // eXgsƌʊmF
        assertFalse(StringUtil.isWhitespace(input));
    }

    /**
     * testRtrim01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFɔpXy[X1镶<br>
     * 
     * ҒlFE̔pXy[X1̂ݏ<br>
     * 
     * EɃXy[X݂镶͂A<br>
     * EXy[X̂ݏĂ邱ƂmFB
     * 
     * @throws Exception O */
    public void testRtrim01() throws Exception {
        // ͒l̐ݒ
        String input = " TERASOLUNA ";

        // eXgs        
        String result = StringUtil.rtrim(input);

        // ʊmF
        assertEquals(" TERASOLUNA", result);
    }

    /**
     * testRtrim02()
     * 
     * (n)<br>
     * 
     * ϓ_FB<br>
     * 
     * ͒lFɔpXy[X镶<br>
     * 
     * ҒlFE̔pXy[Xׂď<br>
     * 
     * E[ɔpXy[X݂ƂA
     * AE[Xy[XĂ邱ƂmFB
     * 
     * 
     * @throws Exception O */
    public void testRtrim02() throws Exception {
        // ͒l̐ݒ
        String input = "   TERASOLUNA   ";

        // eXgs        
        String result = StringUtil.rtrim(input);

        // ʊmF
        assertEquals("   TERASOLUNA", result);
    }

    /**
     * testRtrim03()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFEɔpXy[XȂ<br>
     * 
     * ҒlF͂Ɠ<br>
     * 
     * E[ɃXy[XȂƂA͒lƓ<br>
     * ԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testRtrim03() throws Exception {
        // ͒l̐ݒ
        String input = " TERASOLUNA";

        // eXgs        
        String result = StringUtil.rtrim(input);

        // ʊmF
        assertEquals(" TERASOLUNA", result);
    }

    /**
     * testRtrim04()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * 
     * ҒlFnull<br>
     * 
     * null͒lɐݒ肳ꂽÂ܂null<br>
     * ԋp邱ƁB
     * 
     * @throws Exception O */
    public void testRtrim04() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgs        
        String result = StringUtil.rtrim(input);

        // ʊmF
        assertNull(result);
    }

    /**
     * testRtrim05()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lF""(󕶎)<br>
     * 
     * ҒlF""(󕶎)<br>
     * 
     * 󕶎͒lɐݒ肳ꂽÂ܂܋󕶎ԋp邱
     * 
     * @throws Exception O */
    public void testRtrim05() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgs        
        String result = StringUtil.rtrim(input);

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testLtrim01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFɔpXy[X1镶<br>
     * 
     * ҒlF̔pXy[X̂ݏꂽ<br>
     * 
     * EɃXy[X݂镶͂A<br>
     * Xy[X̂ݏĂ邱ƂmFB 
     * @throws Exception O */
    public void testLtrim01() throws Exception {
        // ͒l̐ݒ
        String input = " TERASOLUNA ";

        // eXgs        
        String result = StringUtil.ltrim(input);

        // ʊmF
        assertEquals("TERASOLUNA ", result);
    }

    /**
     * testLtrim02()
     * 
     * (n)<br>
     * 
     * ϓ_FB<br>
     * 
     * ͒lFɔpXy[X镶<br>
     * 
     * ҒlF̔pXy[Xׂďꂽ<br>
     * 
     * 񍶒[ɔpXy[X݂ƂA
     * A[Xy[XĂ邱ƂmFB
     * 
     * @throws Exception O */
    public void testLtrim02() throws Exception {
        // ͒l̐ݒ
        String input = "   TERASOLUNA   ";

        // eXgs        
        String result = StringUtil.ltrim(input);

        // ʊmF
        assertEquals("TERASOLUNA   ", result);
    }

    /**
     * testLtrim03()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFɔpXy[XȂ<br>
     * 
     * ҒlF͂Ɠ<br>
     * 
     * [ɃXy[XȂƂA͒lƓ<br>
     * ԋp邱ƂmFB
     * 
     * @throws Exception O */
    public void testLtrim03() throws Exception {
        // ͒l̐ݒ
        String input = "TERASOLUNA ";

        // eXgs        
        String result = StringUtil.ltrim(input);

        // ʊmF
        assertEquals("TERASOLUNA ", result);
    }

    /**
     * testLtrim04()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * 
     * ҒlFnull<br>
     * 
     * null͒lɐݒ肳ꂽÂ܂null<br>
     * ԋp邱ƁB
     *  
     * @throws Exception O */
    public void testLtrim04() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgs        
        String result = StringUtil.ltrim(input);

        // ʊmF
        assertNull(result);
    }

    /**
     * testLtrim05()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lF""(󕶎)<br>
     * 
     * ҒlF""(󕶎)<br>
     * 
     * 󕶎͒lɐݒ肳ꂽÂ܂܋󕶎ԋp邱
     * 
     * @throws Exception O */
    public void testLtrim05() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgs        
        String result = StringUtil.ltrim(input);

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testTrim01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFɔpXy[X1镶<br>
     * 
     * ҒlF̔pXy[Xꂽ<br>
     * 
     * ɔpXy[XP镶񂪓͂ꂽA<br>
     * Xy[Xꂽ񂪕ԋp邱ƁB
     * StringUtils.trim()̌ĂяomF̂߂ɁAPP[X݂̂ƂB
     * 
     * @throws Exception O */
    public void testTrim01() throws Exception {
        // ͒l̐ݒ
        String input = " TERASOLUNA ";

        // eXgs        
        String result = StringUtil.trim(input);

        // ʊmF
        assertEquals("TERASOLUNA", result);
    }

    /**
     * testIsZenHankakuSpace01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() c:"@"(SpXy[Xj<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * SpXy[XLN^͂Atrueԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenHankakuSpace01() throws Exception {
        // ͒l̐ݒ
        char input = '@';

        // eXgsƌʊmF
        assertTrue(StringUtil.isZenHankakuSpace(input));
    }

    /**
     * testIsZenHankakuSpace02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() c:"a"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * ppLN^͂Afalseԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenHankakuSpace02() throws Exception {
        // ͒l̐ݒ
        char input = 'a';

        // eXgsƌʊmF
        assertFalse(StringUtil.isZenHankakuSpace(input));
    }

    /**
     * testIsZenHankakuSpace03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() c:0<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * 0LN^ݒ肵Afalseԋp邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenHankakuSpace03() throws Exception {
        // ͒l̐ݒ
        char input = 0;

        // eXgsƌʊmF
        assertFalse(StringUtil.isZenHankakuSpace(input));
    }

    /**
     * testRtrimZ01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:" @ TERASOLUNA @ "<br>
     *         
     * <br>
     * ҒlF(߂l) String:" @ TERASOLUNA"<br>
     *         
     * <br>
     * EɃXy[X݂镶͂AEXy[X̂ݏĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRtrimZ01() throws Exception {
        // ͒l̐ݒ
        String input = " @ TERASOLUNA @ ";

        // eXgs        
        String result = StringUtil.rtrimZ(input);

        // ʊmF
        assertEquals(" @ TERASOLUNA", result);
    }

    /**
     * testRtrimZ02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:" @  @TERASOLUNA @ @ "<br>
     *         
     * <br>
     * ҒlF(߂l) String:" @  @TERASOLUNA"<br>
     *         
     * <br>
     * E[ɑSpXy[X݂ƂAAE[Xy[XĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRtrimZ02() throws Exception {
        // ͒l̐ݒ
        String input = " @  @TERASOLUNA @ @ ";

        // eXgs        
        String result = StringUtil.rtrimZ(input);

        // ʊmF
        assertEquals(" @  @TERASOLUNA", result);
    }

    /**
     * testRtrimZ03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:"@ TERASOLUNA"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"@ TERASOLUNA"<br>
     *         
     * <br>
     * E[ɃXy[XȂƂA͒lƓ񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRtrimZ03() throws Exception {
        // ͒l̐ݒ
        String input = "@ TERASOLUNA";

        // eXgs        
        String result = StringUtil.rtrimZ(input);

        // ʊmF
        assertEquals("@ TERASOLUNA", result);
    }

    /**
     * testRtrimZ04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * null͒lɐݒ肳ꂽÂ܂nullŕԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRtrimZ04() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgs        
        String result = StringUtil.rtrimZ(input);

        // ʊmF
        assertNull(result);
    }

    /**
     * testRtrimZ05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * 󕶎͒lɐݒ肳ꂽÂ܂܋󕶎ԋp邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testRtrimZ05() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgs        
        String result = StringUtil.rtrimZ(input);

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testLtrimZ01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:"@  TERASOLUNA @ "<br>
     *         
     * <br>
     * ҒlF(߂l) String:"TERASOLUNA @ "<br>
     *         
     * <br>
     * EɃXy[X݂镶͂AXy[X̂ݏĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLtrimZ01() throws Exception {
        // ͒l̐ݒ
        String input = "@  TERASOLUNA @ ";

        // eXgs        
        String result = StringUtil.ltrimZ(input);

        // ʊmF
        assertEquals("TERASOLUNA @ ", result);
    }

    /**
     * testLtrimZ02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:" @  @TERASOLUNA @ @ "<br>
     *         
     * <br>
     * ҒlF(߂l) String:"TERASOLUNA @ @ "<br>
     *         
     * <br>
     * 񍶒[ɑSpXy[X݂ƂAA[Xy[XĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLtrimZ02() throws Exception {
        // ͒l̐ݒ
        String input = " @  @TERASOLUNA @ @ ";

        // eXgs        
        String result = StringUtil.ltrimZ(input);

        // ʊmF
        assertEquals("TERASOLUNA @ @ ", result);
    }

    /**
     * testLtrimZ03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:"TERASOLUNA @"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"TERASOLUNA @"<br>
     *         
     * <br>
     * [ɃXy[XȂƂA͒lƓ񂪕ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLtrimZ03() throws Exception {
        // ͒l̐ݒ
        String input = "TERASOLUNA @";

        // eXgs        
        String result = StringUtil.ltrimZ(input);

        // ʊmF
        assertEquals("TERASOLUNA @", result);
    }

    /**
     * testLtrimZ04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:null<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * null͒lɐݒ肳ꂽÂ܂nullŕԋp邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLtrimZ04() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgs        
        String result = StringUtil.ltrimZ(input);

        // ʊmF
        assertNull(result);
    }

    /**
     * testLtrimZ05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:""<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * 󕶎͒lɐݒ肳ꂽÂ܂܋󕶎ԋp邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testLtrimZ05() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgs        
        String result = StringUtil.ltrimZ(input);

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testTrim01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() str:" @ TERASOLUNA @ "<br>
     *         
     * <br>
     * ҒlF(߂l) String:"TERASOLUNA"<br>
     *         
     * <br>
     * ɑSppXy[XPȏ゠镶񂪓͂ꂽAXy[Xꂽ񂪕ԋp邱ƁB<br>
     * StringUtil.rtrimZ()StringUtil.ltrimZ()̌ĂяomF̂߂ɁAPP[X݂̂ƂB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testTrimZ01() throws Exception {
        // ͒l̐ݒ
        String input = " @ TERASOLUNA @ ";

        // eXgs        
        String result = StringUtil.trimZ(input);

        // ʊmF
        assertEquals("TERASOLUNA", result);
    }

    /**
     * testToShortClassName01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFpbP[WC̃NX<br>
     * 
     * ҒlFpbP[WĈȂNX<br>
     * 
     * pbP[W{sIh{NXݒ肳ꂽA<br>
     * NXԋp邱
     * ClassUtils.getShortClassName()̌ĂяomF̂߂ɁAPP[X݂̂ƂB
     * 
     * @throws Exception O */
    public void testToShortClassName01() throws Exception {
        // ͒l̐ݒ
        String input = "jp.terasoluna.util.StringUtil";

        // eXgs
        String result = StringUtil.toShortClassName(input);

        // ʊmF
        assertEquals("StringUtil", result);
    }

    /**
     * testGetExtention01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFgq̃t@C<br>
     * 
     * ҒlFgq<br>
     * 
     * t@C{sIh{gqݒ肳ꂽA<br>
     * sIh{gqԋp邱ƁB
     * 
     * @throws Exception O */
    public void testGetExtention01() throws Exception {
        // ͒l̐ݒ
        String input = "sample.txt";

        // eXgs
        String result = StringUtil.getExtension(input);

        // ʊmF
        assertEquals(".txt", result);
    }

    /**
     * testGetExtention02()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFgq̂Ȃt@C<br>
     * 
     * ҒlF󕶎<br>
     * 
     * sIh{gq݂ȂꍇA<br>
     * ͒l̓t@Ĉ݂Ɖ߂A󕶎ԋp邱ƁB
     * 
     * @throws Exception O */
    public void testGetExtention02() throws Exception {
        // ͒l̐ݒ
        String input = "sample";

        // eXgs
        String result = StringUtil.getExtension(input);

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testGetExtention03()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFgq̃t@C(gqȊO".")<br>
     * 
     * ҒlFgq<br>
     * 
     * [̃sIh{gqԋp邱
     * 
     * @throws Exception O */
    public void testGetExtention03() throws Exception {
        // ͒l̐ݒ
        String input = "sample.txt.bak";

        // eXgs
        String result = StringUtil.getExtension(input);

        // ʊmF
        assertEquals(".bak", result);
    }

    /**
     * testGetExtention04()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * 
     * ҒlFnull<br>
     * 
     * nullŐݒ肵Anullԋp邱ƁB
     * 
     * @throws Exception O */
    public void testGetExtention04() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgs
        String result = StringUtil.getExtension(input);

        // ʊmF
        assertNull(result);
    }

    /**
     * testGetExtention05()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lF󕶎<br>
     * 
     * ҒlF󕶎<br>
     * 
     * 󕶎񂪐ݒ肳ꂽÂ܂܋󕶎ԋp邱ƁB
     * 
     * @throws Exception O */
    public void testGetExtention05() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgs
        String result = StringUtil.getExtension(input);

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testGetExtention06()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFɃsIht@C<br>
     * 
     * ҒlFsIĥ݂̕<br>
     * 
     * sIĥƂAsIĥݕԋp邱ƁB
     * 
     * @throws Exception O */
    public void testGetExtention06() throws Exception {
        // ͒l̐ݒ
        String input = "sample.txt.";

        // eXgs
        String result = StringUtil.getExtension(input);

        // ʊmF
        assertEquals(".", result);
    }

    /**
     * testToHexString01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lFvf1̃oCgz<br>
     * 
     * ҒlF͗vf16iϊ<br>
     * 
     * ͒l16i2ɕϊĂ邱ƁB
     * 
     * @throws Exception O */
    public void testToHexString01() throws Exception {
        // ͒l̐ݒ
        byte[] byteArray = { 0 };

        // eXgs
        String result = StringUtil.toHexString(byteArray, "-");

        // ʊmF
        assertEquals("00", result);
    }

    /**
     * testToHexString02()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFvf0̃oCgz<br>
     * 
     * ҒlF󕶎<br>
     * 
     * 󕶎񂪐ݒ肳ꂽA󕶎̂܂ܕԋp邱ƁB
     * 
     * @throws Exception O */
    public void testToHexString02() throws Exception {
        // ͒l̐ݒ
        byte[] byteArray = {};

        // eXgs
        String result = StringUtil.toHexString(byteArray, "-");

        // ʊmF
        assertEquals("", result);
    }

    /**
     * testToHexString03()
     * 
     * (n)<br>
     * 
     * ϓ_FB<br>
     * 
     * ͒lFvf3̃oCgz<br>
     * 
     * ҒlF͗vf16iϊAf~^Ō<br>
     * 
     * R̗vf16iɕϊAvfԂf~^ŋ؂ꂽ<br>
     * 񂪁Aԋp邱ƁB
     * 
     * @throws Exception O */
    public void testToHexString03() throws Exception {
        // ͒l̐ݒ
        byte[] byteArray = { 0, 10, 100 };

        // eXgs
        String result = StringUtil.toHexString(byteArray, "/");

        // ʊmF
        assertEquals("00/0A/64", result);
    }

    /**
     * testToHexString04()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFvf3̃oCgzAf~^󕶎<br>
     * 
     * ҒlF͗vf16iϊA<br>
     * 
     * f~^󕶎̎A͗vf16iϊÂ܂
     * Ă邱ƁB
     * 
     * @throws Exception O */
    public void testToHexString04() throws Exception {
        // ͒l̐ݒ
        byte[] byteArray = { 0, 10, 100 };

        // eXgs
        String result = StringUtil.toHexString(byteArray, "");

        // ʊmF
        assertEquals("000A64", result);
    }

    /**
     * testToHexString05()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFvf3̃oCgzAf~^null<br>
     * 
     * ҒlF͗vf16iϊA<br>
     * 
     * f~^null̎A͗vf16iϊÂ܂
     * Ă邱ƁB
     * 
     * @throws Exception O */
    public void testToHexString05() throws Exception {
        // ͒l̐ݒ
        byte[] byteArray = { 0, 10, 100 };

        // eXgs
        String result = StringUtil.toHexString(byteArray, null);

        // ʊmF
        assertEquals("000A64", result);
    }

    /**
     * testToHexString06()
     * 
     * (ُn)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFznullAf~^"/"<br>
     * 
     * ҒlFNullPointerException<br>
     * 
     * znull̎A<br>
     * NullPointerExcepti邱ƂmF
     * 
     * @throws Exception O */
    public void testToHexString06() throws Exception {
        // ͒l̐ݒ
        byte[] byteArray = null;

        try {
            // eXgs
            String result = StringUtil.toHexString(byteArray, "/");
            fail();
        } catch (NullPointerException e) {
            return;
        }

    }

    /**
     * testParseCSVString01()
     * 
     * (n)<br>
     * 
     * ϓ_FA<br>
     * 
     * ͒lF1P(J}Ȃ)<br>
     * 
     * ҒlF͕1̗vfƂ镶z<br>
     * 
     * zvf̂AꂸStringz̗vfƂāA
     * ̂܂ܐݒ肳Ă邱ƁB
     * 
     * @throws Exception O */
    public void testParseCSVString01() throws Exception {
        // ͒l̐ݒ
        String input = "abcde";

        // eXgs
        String[] result = StringUtil.parseCSV(input);

        // ʊmF
        // Ғl
        String[] hope = { "abcde" };
        assertEquals(hope.length, result.length);
        assertEquals(hope[0], result[0]);
    }

    /**
     * testParseCSVString02()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lFnull<br>
     * 
     * ҒlFvf0̕z<br>
     * 
     * ͒lnull̂ƂA0̕񂪕ԋp邱ƁB
     * 
     * @throws Exception O */
    public void testParseCSVString02() throws Exception {
        // ͒l̐ݒ
        String input = null;

        // eXgs
        String[] result = StringUtil.parseCSV(input);

        // ʊmF
        assertEquals(0, result.length);
    }

    /**
     * testParseCSVString03()
     * 
     * (n)<br>
     * 
     * ϓ_FB<br>
     * 
     * ͒lF5PJ}؂(󕶎擪ƖѓrɊ܂)<br>
     * 
     * ҒlFJ}Ԃ5̕vfƂ镶z<br>
     * 
     * String[]z񂪃J}ŋ؂Az񉻂Ă邱ƁB
     * 
     * @throws Exception O */
    public void testParseCSVString03() throws Exception {
        // ͒l̐ݒ
        String input = ",abcde,,,";

        // eXgs
        String[] result = StringUtil.parseCSV(input);

        // ʊmF
        // Ғl
        String[] hope = { "", "abcde", "", "", "" };
        assertEquals(hope.length, result.length);
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVString04()
     * 
     * (n)<br>
     * 
     * ϓ_FB<br>
     * 
     * ͒lF󕶎<br>
     * 
     * ҒlF̔z<br>
     * 
     * ͒l󕶎̂ƂA̔z񂪕ԋp邱ƂƁB
     * 
     * @throws Exception O */
    public void testParseCSVString04() throws Exception {
        // ͒l̐ݒ
        String input = "";

        // eXgs
        String[] result = StringUtil.parseCSV(input);

        // ʊmF
        // Ғl
        String[] hope = { "" };
        assertEquals(hope.length, result.length);
        assertEquals(hope[0], result[0]);
    }

    /**
     * testParseCSVStringString01()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕=""<br>
     * GXP[v="\\"
     * 
     * ҒlF̔z<br>
     * 
     * ͒l󕶎̂ƂAvf󕶎̕z񂪕ԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString01() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("", "\\");

        // ʊmF
        assertEquals(1, result.length);
        assertEquals("", result[0]);
    }

    /**
     * testParseCSVStringString02()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕=null<br>
     * GXP[v="\\"
     * 
     * ҒlF̔z<br>
     * 
     * ͒lnull̂ƂAvf0̋̔z񂪕ԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString02() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV(null, "\\");

        // ʊmF
        assertEquals(0, result.length);
    }

    /**
     * testParseCSVStringString03()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="a,b"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"a", "b"}<br>
     * 
     * GXP[vJ}̑Oɑ݂ȂꍇA
     * J}؂̔z񂪕ԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString03() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("a,b", "\\");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "a", "b" };
        for (int i = 0; i < result.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString04()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕=",a,b"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"", "a", "b"}<br>
     * 
     * ͕̐擪J}łƂAvf󕶎ł邱ƁB
     * J}؂̔z񂪕ԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString04() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV(",a,b", "\\");

        // ʊmF
        assertEquals(3, result.length);
        String[] hope = new String[] { "", "a", "b" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString05()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="a,b,"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"a", "b", ""}<br>
     * 
     * ͕̖J}łƂAŏIvf󕶎ł邱ƁB
     * J}؂̔z񂪕ԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString05() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("a,b,", "\\");

        // ʊmF
        assertEquals(3, result.length);
        String[] hope = new String[] { "a", "b", "" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString06()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="a\\,b,c"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"a,b", "c"}<br>
     * 
     * ͕̒ɃGXP[v{J}ƂA
     * ؂肪sȂȂƁB
     * ȊÕJ}͋؂邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString06() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("a\\,b,c", "\\");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "a,b", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString07()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="a\\b,c"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"ab", "c"}<br>
     * 
     * ͕̒ɃGXP[v{J}ȊO̕ƂA
     * ؂肪sȂꂸAԋpɃGXP[vĂȂƁB
     * @throws Exception O */
    public void testParseCSVStringString07() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("a\\b,c", "\\");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "ab", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString08()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="\\,ab,c"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{",ab", "c"}<br>
     * 
     * 擪GXP[v{J}łƂA
     * ԋp擪̗vf̑ꕶJ}ł邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString08() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("\\,ab,c", "\\");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { ",ab", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString09()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="ab,c\\,"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"ab", "c,"}<br>
     * 
     * I[GXP[v{J}łƂA
     * ԋpI[̗vf̍ŏIJ}ł邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString09() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("ab,c\\,", "\\");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "ab", "c," };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString10()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="ab,,,c"<br>
     * GXP[v="\\"
     * 
     * ҒlFString[]{"ab", "", "", "c"}<br>
     * 
     * J}Aœ͂ꂽAJ}؂萔
     * 󕶎vfԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString10() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("ab,,,c", "\\");

        // ʊmF
        assertEquals(4, result.length);
        String[] hope = new String[] { "ab", "", "", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString11()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="ab!,#,,c"<br>
     * GXP[v="#!"
     * 
     * ҒlFString[]{"ab,,", "c"}<br>
     * 
     * GXP[vƃJ}Aœ͂ꂽA
     * J}̂ݘAĔzvfɐݒ肳邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString11() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("ab!,#,,c", "#!");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "ab,,", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString12()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="ab#!@,c"<br>
     * GXP[v="!@#"
     * 
     * ҒlFString[]{"ab!@,", "c"}<br>
     * 
     * GXP[v񂪕Aē͂ꂽꍇ
     * <ol>
     *  <li>GXP[v̒̃GXP[vʏ핶Ƃ
     *      o͂邱ƁB</li>
     *  <li>ɑăGXP[v݂鎞A
     *      GXP[vƂčp邱ƁB</li>
     * </ol>
     * @throws Exception O */
    public void testParseCSVStringString12() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("ab#!@,c", "!@#");

        // ʊmF
        assertEquals(1, result.length);
        String[] hope = new String[] { "ab!,c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString13()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="ab,c"<br>
     * GXP[v=""
     * 
     * ҒlFString[]{"ab", "c"}<br>
     * 
     * GXP[v񂪋󕶎̎AGXP[vsȂꂸ
     * J}؂蕶񂪔zɕϊAԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString13() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("ab,c", "");

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "ab", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testParseCSVStringString14()
     * 
     * (n)<br>
     * 
     * ϓ_FC<br>
     * 
     * ͒lF͕="ab,c"<br>
     * GXP[v=null
     * 
     * ҒlFString[]{"ab", "c"}<br>
     * 
     * GXP[vnull̎AGXP[vsȂꂸ
     * J}؂蕶񂪔zɕϊAԋp邱ƁB
     * @throws Exception O */
    public void testParseCSVStringString14() throws Exception {
        // ͒l̐ݒ

        // eXgs
        String[] result = StringUtil.parseCSV("ab,c", null);

        // ʊmF
        assertEquals(2, result.length);
        String[] hope = new String[] { "ab", "c" };
        for (int i = 0; i < hope.length; i++) {
            assertEquals(hope[i], result[i]);
        }
    }

    /**
     * testDump01B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :String(vfP)<br>
     * Ғl :_vΏە<br>
     * 
     * F_vΏەɕϊĂ邱ƂmFB
     * @throws Exception O */
    public void testDump01() throws Exception {
        //͒l̐ݒ
        final String num = "1";
        final String area = "";

        Map<String, String> map = new LinkedHashMap<String, String>();
        map.put(num, area);

        //eXgs
        String result = StringUtil.dump(map);

        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("1=");
        sb.append(LINE_SEP);
        sb.append("}");

        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testDump02B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :String(vf)<br>
     * Ғl :_vΏە<br>
     * 
     * F_vΏەɕAϊĂ邱ƂmFB
     * @throws Exception O */
    public void testDump02() throws Exception {
        //͒l̐ݒ
        final String[] num = { "1", "2", "3" };
        final String[] area = { "", "s", "" };

        Map<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < num.length; i++) {
            map.put(num[i], area[i]);
        }
        //eXgs
        String result = StringUtil.dump(map);

        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("1=");
        sb.append(LINE_SEP);
        sb.append("2=s");
        sb.append(LINE_SEP);
        sb.append("3=");
        sb.append(LINE_SEP);
        sb.append("}");

        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testDump03B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :<br>
     * Ғl :_vΏە<br>
     * 
     * Fz_vΏەɕϊĂ邱ƂmFB
     * @throws Exception O */
    public void testDump03() throws Exception {
        //͒l̐ݒ
        Map map = new LinkedHashMap();

        //eXgs
        String result = StringUtil.dump(map);

        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("}");

        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testDump04B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :z񒆂null<br>
     * Ғl :nullƂŏo͂B<br>
     * 
     * FzvfnulloꂽꍇA<br>
     * "null"Ƃ񂪏o͂邱ƂmFB
     * @throws Exception O */
    public void testDump04() throws Exception {
        //͒l̐ݒ
        final String[] num = { "1", "2", "3" };
        final String[] area = { "", null, "" };

        Map<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < num.length; i++) {
            map.put(num[i], area[i]);
        }
        //eXgs
        String result = StringUtil.dump(map);

        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("1=");
        sb.append(LINE_SEP);
        sb.append("2=null");
        sb.append(LINE_SEP);
        sb.append("3=");
        sb.append(LINE_SEP);
        sb.append("}");

        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testDump05B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :L[null<br>
     * Ғl :"null"\邱<br>
     * 
     * FL[null̏ꍇA<br>
     * "null"\邱ƂmFB
     * @throws Exception O */
    public void testDump05() throws Exception {
        //͒l̐ݒ
        final String num = null;
        final String area = "";

        Map<String, String> map = new LinkedHashMap<String, String>();

        map.put(num, area);
        //eXgs
        String result = StringUtil.dump(map);
        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("null=");
        sb.append(LINE_SEP);
        sb.append("}");
        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testDump06B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :z(L[P)<br>
     * Ғl :z_vΏە<br>
     * 
     * Fz_vΏەɕϊĂ邱ƂmFB
     * @throws Exception O */
    public void testDump06() throws Exception {
        //͒l̐ݒ
        final String num = "1";
        final Vector<String> area = new Vector<String>();
        area.add(0, "");
        area.add(1, "");

        Map<String, Vector> map = new LinkedHashMap<String, Vector>();
        map.put(num, area);

        //eXgs
        String result = StringUtil.dump(map);

        //ʊmF
        assertEquals(LINE_SEP + "Map{" + LINE_SEP + "1=[, ]" + LINE_SEP
                + "}", result);
    }

    /**
     * testDump07B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :z(L[)<br>
     * Ғl :z_vΏە<br>
     * 
     * Fz_vΏەɕϊĂ邱ƂmFB
     * @throws Exception O */
    public void testDump07() throws Exception {
        //͒l̐ݒ
        final String num1 = "1";
        final String num2 = "2";
        Vector<String> area = new Vector<String>();
        Vector<String> tel = new Vector<String>();

        area.add(0, "");
        area.add(1, "");
        tel.add(0, "03");
        tel.add(1, "06");

        Map<String, Vector> map = new LinkedHashMap<String, Vector>();
        map.put(num1, area);
        map.put(num2, tel);

        //eXgs
        String result = StringUtil.dump(map);

        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("1=[, ]");
        sb.append(LINE_SEP);
        sb.append("2=[03, 06]");
        sb.append(LINE_SEP);
        sb.append("}");

        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testDump08B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒l :mapnull<br>
     * Ғl :null<br>
     * 
     * Fmapnull̏ꍇA<br>
     * nullԋp邱ƂmFB
     * @throws Exception O */
    public void testDump08() throws Exception {
        //͒l̐ݒ        
        Map map = null;

        //eXgs
        String result = StringUtil.dump(map);

        //ʊmF
        assertNull(result);
    }

    /**
     * testDump9B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :L[igzj<br>
     * Ғl :z_vΏە<br>
     * 
     * Fz_vΏەɕϊĂ邱ƂmFB
     * @throws Exception O */
    public void testDump9() throws Exception {
        //͒l̐ݒ
        final String num1 = "1";
        final String num2 = "2";
        Vector<String> area = new Vector<String>();
        String tel[] = { "03", "06" };

        area.add(0, "");
        area.add(1, "");

        Map<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(num1, area);
        map.put(num2, tel);

        //eXgs
        String result = StringUtil.dump(map);

        //
        StringBuffer sb = new StringBuffer();
        sb.append(LINE_SEP);
        sb.append("Map{");
        sb.append(LINE_SEP);
        sb.append("1=[, ]");
        sb.append(LINE_SEP);
        sb.append("2={03,06}");
        sb.append(LINE_SEP);
        sb.append("}");

        //ʊmF
        assertEquals(sb.toString(), result);
    }

    /**
     * testGetArraysStr01B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒l :Stringz<br>
     * Ғl :z_vΏە<br>
     * 
     * Fz_vΏەɕϊĂ邱ƂmFB
     * ArrayUtils.toString()̌ĂяomF̂߂ɁAPP[X݂̂ƂB
     * 
     * @throws Exception O */
    public void testGetArraysStr01() throws Exception {
        //͒l̐ݒ
        final String[] str = { "1", "2", "3", "4", "5" };

        //eXgs
        String result = StringUtil.getArraysStr(str);

        //ʊmF
        assertEquals("{1,2,3,4,5}", result);
    }

    /**
     * testHankakuToZenkaku01B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp(ꕶ)<br>
     * ҒlFSp
     * 
     * FpʉpꕶSpʉpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku01() throws Exception {
        //͒l̐ݒ
        String input = "A";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("`", result);
    }

    /**
     * testHankakuToZenkaku02B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp()<br>
     * ҒlFSp
     * 
     * FpʕASpʕɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku02() throws Exception {
        //͒l̐ݒ
        String input = "!A8";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("AJI`W", result);
    }

    /**
     * testHankakuToZenkaku03B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFpT(ꕶ)<br>
     * ҒlFSpT
     * 
     * FpTꕶSpTɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku03() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("T", result);
    }

    /**
     * testHankakuToZenkaku04B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFpJT^nE()<br>
     * ҒlFSpJT^nE
     * 
     * FpJT^nEASpJT^nEɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku04() throws Exception {
        //͒l̐ݒ
        String input = "ʳ";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("JT^nE", result);
    }

    /**
     * testHankakuToZenkaku05B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp_(ꕶ)<br>
     * ҒlFSp_K
     * 
     * Fp_ꕶSp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku05() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("K", result);
    }

    /**
     * testHankakuToZenkaku06B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp_޻޳()<br>
     * ҒlFSp_KU_o
     * 
     * Fp_ASp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku06() throws Exception {
        //͒l̐ݒ
        String input = "޻޳";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("KU_o", result);
    }

    /**
     * testHankakuToZenkaku07B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp_ߍs(ꕶ)<br>
     * ҒlFSp_ps
     * 
     * Fp_(ꕶ)Sp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku07() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("|", result);
    }

    /**
     * testHankakuToZenkaku08B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp_ߍs()<br>
     * ҒlFSp_ps
     * 
     * Fp_ASp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku08() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("psvy|", result);
    }

    /**
     * testHankakuToZenkaku09B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * FpSpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku09() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testHankakuToZenkaku10B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * FpSpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku10() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testHankakuToZenkaku11B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp"<br>
     * ҒlFSph
     * 
     * Fp_Sp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku11() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("\u30f7", result);
    }

    /**
     * testHankakuToZenkaku12B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp"<br>
     * ҒlFSph
     * 
     * Fp_Sp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku12() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("\u30fa", result);
    }

    /**
     * testHankakuToZenkaku13B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp̓rɂ鎞ASpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku13() throws Exception {
        //͒l̐ݒ
        String input = "A1";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("`P", result);
    }

    /**
     * testHankakuToZenkaku14B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp̓rɂ鎞ASpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku14() throws Exception {
        //͒l̐ݒ
        String input = "B8";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("aW", result);
    }

    /**
     * testHankakuToZenkaku15B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp_̓rɂ鎞ASp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku15() throws Exception {
        //͒l̐ݒ
        String input = "B8";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("a\u30f7W", result);
    }

    /**
     * testHankakuToZenkaku16B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp_̓rɂ鎞ASp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku16() throws Exception {
        //͒l̐ݒ
        String input = "B8";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("a\u30faW", result);
    }

    /**
     * testHankakuToZenkaku17B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp̖ɂ鎞ASpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku17() throws Exception {
        //͒l̐ݒ
        String input = "A";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("A`", result);
    }

    /**
     * testHankakuToZenkaku18B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp̖ɂ鎞ASpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku18() throws Exception {
        //͒l̐ݒ
        String input = "tB";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("a", result);
    }

    /**
     * testHankakuToZenkaku19B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp_̖ɂ鎞ASp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku19() throws Exception {
        //͒l̐ݒ
        String input = "B";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("Ta\u30f7", result);
    }

    /**
     * testHankakuToZenkaku20B<br>
     * 
     * injA<br>
     * ϓ_F<br>
     * <br>
     * ͒lFp<br>
     * ҒlFSp
     * 
     * Fp_̖ɂ鎞ASp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku20() throws Exception {
        //͒l̐ݒ
        String input = "B";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("Aa\u30fa", result);
    }

    /**
     * testHankakuToZenkaku21B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFpSp"<br>
     * ҒlFSp
     * 
     * F͒lɑSpƔp̂ݒ肵A<br>
     * SđSpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku21() throws Exception {
        //͒l̐ݒ
        String input = "TYރ\";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("TVY[\", result);
    }

    /**
     * testHankakuToZenkaku22B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFnull<br>
     * ҒlFnull
     * FuΏەnull̎Anull߂lƂI邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku22() throws Exception {
        //͒l̐ݒ
        String input = null;

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertNull(result);
    }

    /**
     * testHankakuToZenkaku23B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF󕶎<br>
     * ҒlF󕶎
     * 
     * FuΏە񂪋󕶎̎A󕶎߂lƂI邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku23() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testHankakuToZenkaku24B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFp_߷<br>
     * ҒlFSp_JKLK
     * 
     * Fp_Sp_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testHankakuToZenkaku24() throws Exception {
        //͒l̐ݒ
        String input = "߷";

        //eXgs
        String result = StringUtil.hankakuToZenkaku(input);

        //ʊmF
        assertEquals("JKLK", result);
    }

    /**
     * testZenkakuToHankaku01B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp<br>
     * ҒlFpiϊj<br>
     * 
     * FSppɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku01() throws Exception {
        //͒l̐ݒ
        String input = "`IA";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("A!", result);
    }

    /**
     * testZenkakuToHankaku02B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp<br>
     * ҒlFpiꕶϊj<br>
     * 
     * FSpɑ΂ĔpɈꕶϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku02() throws Exception {
        //͒l̐ݒ
        String input = "`";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("A", result);
    }

    /**
     * testZenkakuToHankaku02B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSpJT^n<br>
     * ҒlFpJT^nj<br>
     * 
     * FSpJT^npJT^nɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku03() throws Exception {
        //͒l̐ݒ
        String input = "JT^n";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testZenkakuToHankaku04B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp_<br>
     * ҒlFp_<br>
     * 
     * FSp_񕶎ɕĕ\邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku04() throws Exception {
        //͒l̐ݒ
        String input = "KU_";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("޻", result);
    }

    /**
     * testZenkakuToHankaku05B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp_<br>
     * ҒlFp_<br>
     * 
     * FSp_E_񕶎ɕĕ\邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku05() throws Exception {
        //͒l̐ݒ
        String input = "p|";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testZenkakuToHankaku06B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp<br>
     * ҒlFp<br>
     * 
     * FSppɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku06() throws Exception {
        //͒l̐ݒ
        String input = "`";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("A", result);
    }

    /**
     * testZenkakuToHankaku07B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp<br>
     * ҒlFp<br>
     * 
     * FSppɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku07() throws Exception {
        //͒l̐ݒ
        String input = "`";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("A", result);
    }

    /**
     * testZenkakuToHankaku08B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp_<br>
     * ҒlFp_<br>
     * 
     * FSp_p_܂ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku08() throws Exception {
        //͒l̐ݒ
        String input = "A\u30f7";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testZenkakuToHankaku09B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFSp_<br>
     * ҒlFp_<br>
     * 
     * FSp_p_ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku09() throws Exception {
        //͒l̐ݒ
        String input = "\u30fa";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("޳", result);
    }

    /**
     * testZenkakuToHankaku10B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFpESp<br>
     * ҒlFpɑSĕϊ邱<br>
     * 
     * FpESpSĔpɕϊ邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku10() throws Exception {
        //͒l̐ݒ
        String input = "T\u30faAs";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("޲A", result);
    }

    /**
     * testZenkakuToHankaku11B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF󕶎<br>
     * ҒlF󕶎<br>
     * 
     * FuΏە񂪋󕶎̎A󕶎߂lƂI邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku11() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testZenkakuToHankakuu12B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFnull<br>
     * ҒlFnull<br>
     * 
     * FuΏەnull̎Anull߂lƂI邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku12() throws Exception {
        //͒l̐ݒ
        String input = null;

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals(null, result);
    }

    /**
     * testZenkakuToHankakuu13B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFps\ȕ<br>
     * ҒlFSp<br>
     * 
     * Fps\ȕ񂪂̂܂ܑSpŏo͂邱ƂmFB
     * @throws Exception O */
    public void testZenkakuToHankaku13() throws Exception {
        //͒l̐ݒ
        String input = "͒l";

        //eXgs
        String result = StringUtil.zenkakuToHankaku(input);

        //ʊmF
        assertEquals("͒l", result);
    }

    /**
     * testFilter01B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFiHTMLɂ̂܂܏o͂Ɩ肪镶ꕔ܂ށj<br>
     * ҒlFHTML^<br>
     * 
     * F񕶎ȏ̕񒆁AꕔHTML^ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testFilter01() throws Exception {
        //͒l̐ݒ
        String input = "a & b";

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertEquals("a &amp; b", result);
    }

    /**
     * testFilter02B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFiHTMLɂ̂܂܏o͂Ɩ肪镶܂܂Ȃj<br>
     * ҒlF̂܂܏o͂<br>
     * 
     * FHTML^ɕϊ邱ƂȂ̂܂܏o͂邱ƂmFB
     * @throws Exception O */
    public void testFilter02() throws Exception {
        //͒l̐ݒ
        String input = "abc";

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertEquals("abc", result);
    }

    /**
     * testFilter03B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFHTMLɂ̂܂܏o͂Ɩ肪镶ij<br>
     * ҒlFHTML^<br>
     * 
     * FHTML^ɑSĂϊ邱ƂmFB
     * @throws Exception O */
    public void testFilter03() throws Exception {
        //͒l̐ݒ
        String input = "< & > \" '";

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertEquals("&lt; &amp; &gt; &quot; &#39;", result);
    }

    /**
     * testFilter04B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFHTMLɂ̂܂܏o͂Ɩ肪镶iꕶϊj<br>
     * ҒlFHTML^<br>
     * 
     * FHTML^Ɉꕶϊ邱ƂmFB
     * @throws Exception O */
    public void testFilter04() throws Exception {
        //͒l̐ݒ
        String input = "<";

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertEquals("&lt;", result);
    }

    /**
     * testFilter05B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFHTMLɂ̂܂܏o͂Ă̂Ȃiꕶϊj<br>
     * ҒlF̂܂܏o͂邱<br>
     * 
     * FHTML^ɕϊ邱ƂȂÂ܂܏o͂邱ƂmFB
     * @throws Exception O */
    public void testFilter05() throws Exception {
        //͒l̐ݒ
        String input = "A";

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertEquals("A", result);
    }

    /**
     * testFilter06B<br>
     * 
     * iُnj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFnull<br>
     * ҒlFnull<br>
     * 
     * FuΏەnull̂ƂAnullԋp邱ƂmFB<br>
     * @throws Exception O */
    public void testFilter06() throws Exception {
        //͒l̐ݒ
        String input = null;

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertNull(result);
    }

    /**
     * testFilter07B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF󕶎<br>
     * ҒlF󕶎<br>
     * 
     * FHTML^ɕϊ邱ƂȂA󕶎̂܂܏o͂邱ƂmFB
     * @throws Exception O */
    public void testFilter07() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.filter(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testToLikeCondition01B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lF<br>
     * ҒlFLIKEq̃p^[(ꕶϊj<br>
     * 
     * F񂪈ꕶLIKEq̃p^[ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition01() throws Exception {
        //͒l̐ݒ
        String input = "a%";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("a~%%", result);
    }

    /**
     * testToLikeCondition02B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFGXP[v<br>
     * ҒlFGXP[v<br>
     * 
     * FLIKEq̃p^[ŗpGXP[v<br>
     * GXP[vŃGXP[v邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition02() throws Exception {
        //͒l̐ݒ
        String input = "~";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("~~%", result);
    }

    /**
     * testToLikeCondition03B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lF<br>
     * ҒlFLIKEq̃p^[iϊj<br>
     * 
     * F񂪕LIKEq̃p^[ɕϊ邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition03() throws Exception {
        //͒l̐ݒ
        String input = "_a%";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("~_a~%%", result);
    }

    /**
     * testToLikeCondition04B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * <br>
     * ͒lFȊO̕<br>
     * ҒlF̂܂܏o͂邱<br>
     * 
     * FȊO͕̕ϊ邱ƂȂÂ܂܏o͂邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition04() throws Exception {
        //͒l̐ݒ
        String input = "aa";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("aa%", result);
    }

    /**
     * testToLikeCondition05B<br>
     * 
     * iُnj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFnullj<br>
     * ҒlFnull<br>
     * 
     * FuΏەnull̂ƂAnullԋp邱ƂmFB<br>
     * @throws Exception O */
    public void testToLikeCondition05() throws Exception {
        //͒l̐ݒ
        String input = null;

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertNull(result);
    }

    /**
     * testToLikeCondition06B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF󕶎<br>
     * ҒlF%<br>
     * 
     * FuΏە񂪋󕶎̂ƂA"%"o͂邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition06() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("%", result);
    }

    /**
     * testToLikeCondition07B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF<br>
     * ҒlF~%<br>
     * 
     * FuΏە""̂ƂA"~%"o͂邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition07() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("~%", result);
    }

    /**
     * testToLikeCondition08B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFQ<br>
     * ҒlF~Q%<br>
     * 
     * FuΏە"Q"̂ƂA"~Q%"o͂邱ƂmFB
     * @throws Exception O */
    public void testToLikeCondition08() throws Exception {
        //͒l̐ݒ
        String input = "Q";

        //eXgs
        String result = StringUtil.toLikeCondition(input);

        //ʊmF
        assertEquals("~Q%", result);
    }

    /**
     * testCapitalizeInitial01B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF"abc"<br>
     * ҒlF"Abc"<br>
     * 
     * Fꕶڂɑ啶ɕϊłꍇ
     * @throws Exception O */
    public void testCapitalizeInitial01() throws Exception {
        //͒l̐ݒ
        String input = "abc";

        //eXgs
        String result = StringUtil.capitalizeInitial(input);

        //ʊmF
        assertEquals("Abc", result);
    }

    /**
     * testCapitalizeInitial02B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF"Abc"<br>
     * ҒlF"Abc"<br>
     * 
     * Fꕶڂŏ啶̏ꍇ
     * @throws Exception O */
    public void testCapitalizeInitial02() throws Exception {
        //͒l̐ݒ
        String input = "Abc";

        //eXgs
        String result = StringUtil.capitalizeInitial(input);

        //ʊmF
        assertEquals("Abc", result);
    }

    /**
     * testCapitalizeInitial03B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF"123"<br>
     * ҒlF"123"<br>
     * 
     * Fꕶڂ啶ɕϊłȂ̏ꍇ
     * @throws Exception O */
    public void testCapitalizeInitial03() throws Exception {
        //͒l̐ݒ
        String input = "123";

        //eXgs
        String result = StringUtil.capitalizeInitial(input);

        //ʊmF
        assertEquals("123", result);
    }

    /**
     * testCapitalizeInitial04B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF""<br>
     * ҒlF""<br>
     * 
     * F󔒂̏ꍇ
     * @throws Exception O */
    public void testCapitalizeInitial04() throws Exception {
        //͒l̐ݒ
        String input = "";

        //eXgs
        String result = StringUtil.capitalizeInitial(input);

        //ʊmF
        assertEquals("", result);
    }

    /**
     * testCapitalizeInitial05B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lF<br>
     * ҒlFnull<br>
     * 
     * Fnull̏ꍇ
     * @throws Exception O */
    public void testCapitalizeInitial05() throws Exception {
        //͒l̐ݒ
        String input = null;

        //eXgs
        String result = StringUtil.capitalizeInitial(input);

        //ʊmF
        assertEquals(null, result);
    }

    /**
     * testGetByteLength01<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFvalue=null<br>
     * ҒlF0<br>
     * 
     * Fvaluenull̏ꍇ<br>
     * @throws Exception O */
    public void testGetByteLength01() throws Exception {
        // O
        String value = null;
        String encoding = null;

        // eXgs
        int i = StringUtil.getByteLength(value, encoding);

        // 
        assertEquals(0, i);
    }

    /**
     * testGetByteLength02<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFvalue=󕶎<br>
     * ҒlF0<br>
     * 
     * Fvalue󕶎̏ꍇ<br>
     * @throws Exception O */
    public void testGetByteLength02() throws Exception {
        // O
        String value = "";
        String encoding = null;

        // eXgs
        int i = StringUtil.getByteLength(value, encoding);

        // 
        assertEquals(0, i);
    }

    /**
     * testGetByteLength03<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFvalue="aaa", encoding=null<br>
     * ҒlF3<br>
     * 
     * Fencodingnull̏ꍇ<br>
     * @throws Exception O */
    public void testGetByteLength03() throws Exception {
        // O
        String value = "aaa";
        String encoding = null;

        // eXgs
        int i = StringUtil.getByteLength(value, encoding);

        // 
        assertEquals(3, i);
    }

    /**
     * testGetByteLength04<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFvalue="aaa", encoding=󕶎<br>
     * ҒlF3<br>
     * 
     * Fencoding󕶎̏ꍇ<br>
     * @throws Exception O */
    public void testGetByteLength04() throws Exception {
        // O
        String value = "aaa";
        String encoding = "";

        // eXgs
        int i = StringUtil.getByteLength(value, encoding);

        // 
        assertEquals(3, i);
    }

    /**
     * testGetByteLength05<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * <br>
     * ͒lFvalue="", encoding="UTF-8"<br>
     * ҒlF9<br>
     * 
     * FencodingGR[fBȌꍇ<br>
     * @throws Exception O */
    public void testGetByteLength05() throws Exception {
        // O
        String value = "";
        String encoding = "UTF-8";

        // eXgs
        int i = StringUtil.getByteLength(value, encoding);

        // 
        assertEquals(9, i);
    }

    /**
     * testGetByteLength06<br>
     * 
     * iُnj<br>
     * ϓ_FG<br>
     * <br>
     * ͒lFvalue="aaa", encoding="aaa"<br>
     * ҒlFOFUnsupportedEncodingException<br>
     * 
     * FencodingsȕGR[fBȌꍇ<br>
     * @throws Exception O */
    public void testGetByteLength06() throws Exception {
        // O
        String value = "aaa";
        String encoding = "aaa";

        // eXgs
        try {
            int i = StringUtil.getByteLength(value, encoding);
            fail();
        } catch (UnsupportedEncodingException e) {
            // 
            return;
        }
    }
}