/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans;

import jp.terasoluna.utlib.LogUTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * JavaBean̔zERNV^ɃANZXłNXB<br>
 * OF<br>
 * utoXPathv\bḧɂnull͓ȂB<br>
 * uextractIncrementIndex(String)v\bḧɂnull͓ȂB<br>
 * uextractIncrementIndex(String,int)v\bh̑Pɂnull͓ȂB<br>
 * uextractIncrementIndex(String,int)v\bh̑Qɂ1-1ȂB<br>
 * uextractIndexv\bḧɂnull͓ȂB<br>
 * uescapeMapPropertyv\bḧɂnull͓ȂB<br>
 * uextractMapPropertyNamev\bḧɂnull͓ȂB<br>
 * uextractMapPropertyKeyv\bḧɂnull͓ȂB<br>
 * uisMapPropertyv\bḧɂnull͓ȂB
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.JXPathIndexedBeanWrapperImpl
 */
public class JXPathIndexedBeanWrapperImplTest02 extends TestCase {


    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public JXPathIndexedBeanWrapperImplTest02(String name) {
        super(name);
    }

    /**
     * testToXPath01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() property:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFProperty name is null or blank.<br>
     *         (ԕω) O:OxFG[<br>
     *                    Property name is null or blank.<br>
     *         
     * <br>
     * y󕶎̃eXgz<br>
     * property󕶎̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = "";
        
        // eXg{
        try{
            test.toXPath(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Property name is null or blank.", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Property name is null or blank."));
            
        }
    }

    /**
     * testToXPath02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"."<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFProperty name is null or blank.<br>
     *         (ԕω) O:OxFG[<br>
     *                    Property name is null or blank.<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"."݂̂̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath02() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = ".";
        
        // eXg{
        try{
            test.toXPath(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Property name is null or blank.", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Property name is null or blank."));
            
        }
    }

    /**
     * testToXPath03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () isMapProperty:falseԂB<br>
     *         () extractAttributeName:property+"Attribute"ԂB<br>
     *         () extractIncrementIndex:"[3]"ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:/abcAttribute[3]<br>
     *         (ԕω) isMapProperty:"abc"nꂽƂmFB<br>
     *         (ԕω) extractAttributeName:\bh͈(property="abc")Ŗ߂lproperty+"Attribute"ƂB<br>
     *         (ԕω) extractIncrementIndex:"abc"nꂽƂmFB<br>
     *         
     * <br>
     * yJavaBean or PrimitivẽeXgz<br>
     * for1s̏ꍇB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath03() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = "abc";
        
        // OiX^ujݒ
        test.isMapPropertyResult = false;
        test.extractIncrementIndexResult = "[3]";
        
        // eXg{
        String result = test.toXPath(property);
        // 
        assertEquals("abc",test.isMapPropertyParam1);
        assertEquals("abc",test.extractIncrementIndexParam1);
        assertEquals("/abcAttribute[3]",result);
            
    }

    /**
     * testToXPath04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc.def.ghi"<br>
     *         () isMapProperty:falseԂB<br>
     *         () extractAttributeName:property+"Attribute"ԂB<br>
     *         () extractIncrementIndex:""ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:/abcAttribute/defAttribute/ghiAttribute<br>
     *         (ԕω) isMapProperty:"ghi"nꂽƂmFB<br>
     *         (ԕω) extractAttributeName:\bh͈(property="abc")Ŗ߂lproperty+"Attribute"ƂB<br>
     *         (ԕω) extractIncrementIndex:"ghi"nꂽƂmFB<br>
     *         
     * <br>
     * yJavaBean or PrimitivẽeXgz<br>
     * fors̏ꍇB<br>
     * iproperty"."܂ޕ̃p^[j
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath04() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = "abc.def.ghi";
        
        // OiX^ujݒ
        test.isMapPropertyResult = false;
        test.extractIncrementIndexResult = "";
        
        // eXg{
        String result = test.toXPath(property);
        
        // 
        assertEquals("ghi",test.isMapPropertyParam1);
        assertEquals("ghi",test.extractIncrementIndexParam1);
        assertEquals("/abcAttribute/defAttribute/ghiAttribute",result);
    }

    /**
     * testToXPath05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () isMapProperty:trueԂB<br>
     *         () escapeMapProperty:property+"[@name='key']"ԂB<br>
     *         () extractIncrementIndex:"[3]"ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:/abc[@name='key'][3]<br>
     *         (ԕω) isMapProperty:"abc"nꂽƂmFB<br>
     *         (ԕω) escapeMapProperty:\bh͈(property="abc")Ŗ߂lproperty+"[@name='key']"ƂB<br>
     *         (ԕω) extractIncrementIndex:"abc"nꂽƂmFB<br>
     *         
     * <br>
     * yMap̃eXgz<br>
     * for1s̏ꍇB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath05() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = "abc";
        
        // OiX^ujݒ
        test.isMapPropertyResult = true;
        test.extractIncrementIndexResult = "[3]";
        
        // eXg{
        String result = test.toXPath(property);
        
        // 
        assertEquals("abc",test.isMapPropertyParam1);
        assertEquals("abc",test.extractIncrementIndexParam1);
        assertEquals("/abc[@name='key'][3]",result);
    }

    /**
     * testToXPath06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc.def..ghi"<br>
     *         () isMapProperty:trueԂB<br>
     *         () escapeMapProperty:property+"[@name='key']"ԂB<br>
     *         () extractIncrementIndex:""ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:/abc[@name='key']/def[@name='key']/ghi[@name='key']<br>
     *         (ԕω) isMapProperty:"ghi"nꂽƂmFB<br>
     *         (ԕω) escapeMapProperty:\bh͈(property="abc")Ŗ߂lproperty+"[@name='key']"ƂB<br>
     *         (ԕω) extractIncrementIndex:"ghi"nꂽƂmFB<br>
     *         
     * <br>
     * yMap̃eXgz<br>
     * fors̏ꍇB<br>
     * iproperty".."܂ޕ̃p^[j
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath06() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = "abc.def..ghi";
        
        // OiX^ujݒ
        test.isMapPropertyResult = true;
        test.extractIncrementIndexResult = "";
        
        // eXg{
        String result = test.toXPath(property);
        
        // 
        assertEquals("ghi",test.isMapPropertyParam1);
        assertEquals("ghi",test.extractIncrementIndexParam1);
        assertEquals("/abc[@name='key']/def[@name='key']/ghi[@name='key']",
                result);
    }

    /**
     * testToXPath07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc.def..ghi"<br>
     *         () isMapProperty:falseԂB<br>
     *         () extractAttributeName:property+"Attribute"ԂB<br>
     *         () extractIncrementIndex:""ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:/abcAttribute/defAttribute/ghiAttribute<br>
     *         (ԕω) isMapProperty:"ghi"nꂽƂmFB<br>
     *         (ԕω) extractAttributeName:\bh͈(property="abc")Ŗ߂lproperty+"Attribute"ƂB<br>
     *         (ԕω) extractIncrementIndex:"ghi"nꂽƂmFB<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property".."i"."2Aj܂ޕ̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testToXPath07() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub03 test = 
            new JXPathIndexedBeanWrapperImplStub03(object);
        
        // ͒lݒ
        String property = "abc.def..ghi";
        
        // OiX^ujݒ
        test.isMapPropertyResult = false;
        test.extractIncrementIndexResult = "";
        
        // eXg{
        String result = test.toXPath(property);
        
        // 
        assertEquals("ghi",test.isMapPropertyParam1);
        assertEquals("ghi",test.extractIncrementIndexParam1);
        assertEquals("/abcAttribute/defAttribute/ghiAttribute",result);
    }

    /**
     * testExtractIncrementIndexString01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () extractIncremantIndex(String,int):uproperty+":"+incrementvԂB<br>
     *         
     * <br>
     * ҒlF(߂l) Object:"abc:1"<br>
     *         (ԕω) extractIncremantIndex(String,int):\bh͈(property="abc",increment=1)Ŗ߂lproperty+":"+incrementƂB<br>
     *         
     * <br>
     * yextractIncremantIndex(String,int)@@ĂяõeXgz
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIncrementIndexString01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub02 test = 
            new JXPathIndexedBeanWrapperImplStub02(object);
        
        // ͒lݒ
        String property = "abc";
        
        // eXg{
        String result = test.extractIncrementIndex(property);
        
        // 
        assertEquals("abc:1",result);
    }

    /**
     * testExtractIncremantIndexStringint01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () increment:1<br>
     *         () extractIndex:""ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         (ԕω) extractIndex:"abc"nꂽƂmFB<br>
     *         
     * <br>
     * ỹeXgz<br>
     * increment1<br>
     * extractIndex""Ԃp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIncremantIndexStringint01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒l
        String property = "abc";
        int increment = 1;
        
        // OiX^uj
        test.extractIndexResult = "";
        
        // eXg{
        String result = test.extractIncrementIndex(property,increment);
        
        // 
        assertEquals("abc",test.extractIndexParam1);
        assertEquals("",result);
    }

    /**
     * testExtractIncremantIndexStringint02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () increment:1<br>
     *         () extractIndex:"2"ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:"[3]"<br>
     *         (ԕω) extractIndex:"abc"nꂽƂmFB<br>
     *         
     * <br>
     * ỹeXgz<br>
     * increment1<br>
     * extractIndex"2"Ԃp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIncremantIndexStringint02() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒l
        String property = "abc";
        int increment = 1;
        
        // OiX^uj
        test.extractIndexResult = "2";
        
        // eXg{
        String result = test.extractIncrementIndex(property,increment);
        
        // 
        assertEquals("abc",test.extractIndexParam1);
        assertEquals("[3]",result);
    }

    /**
     * testExtractIncremantIndexStringint03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () increment:-1<br>
     *         () extractIndex:"2"ԂB<br>
     *         
     * <br>
     * ҒlF(߂l) String:"[1]"<br>
     *         (ԕω) extractIndex:"abc"nꂽƂmFB<br>
     *         
     * <br>
     * ỹeXgz<br>
     * increment-1<br>
     * extractIndex"2"Ԃp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIncremantIndexStringint03() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒l
        String property = "abc";
        int increment = -1;
        
        // OiX^uj
        test.extractIndexResult = "2";
        
        // eXg{
        String result = test.extractIncrementIndex(property,increment);
        
        // 
        assertEquals("abc",test.extractIndexParam1);
        assertEquals("[1]",result);
    }

    /**
     * testExtractIndex01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() property:""[󕶎]<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * y󕶎̃eXgz<br>
     * property󕶎̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "";
                
        // eXg{
        String result = test.extractIndex(property);
        
        // 
        assertEquals("",result);
    }

    /**
     * testExtractIndex02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"["܂"]"ĂȂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex02() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "abc";
                
        // eXg{
        String result = test.extractIndex(property);
        
        // 
        assertEquals("",result);
    }

    /**
     * testExtractIndex03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"["<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Index. Invalid property name. '['<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Index. Invalid property name. '['<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property"["̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex03() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "[";
        
        // eXg{
        try{
            test.extractIndex(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Index. Invalid property name. '['", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Index. Invalid property name. '['"));
            
        }
    }

    /**
     * testExtractIndex04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"]"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Index. Invalid property name. ']'<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Index. Invalid property name. ']'<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property"]"̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex04() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "]";
        
        // eXg{
        try{
            test.extractIndex(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Index. Invalid property name. ']'", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Index. Invalid property name. ']'"));
            
        }
    }

    /**
     * testExtractIndex05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"]["<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Index. Invalid property name. ']['<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Index. Invalid property name. ']['<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property"]["̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex05() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "][";
        
        // eXg{
        try{
            test.extractIndex(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Index. Invalid property name. ']['", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Index. Invalid property name. ']['"));
            
        }
    }

    /**
     * testExtractIndex06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"[]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"[]"̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex06() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "[]";
                
        // eXg{
        String result = test.extractIndex(property);
        
        // 
        assertEquals("",result);
    }

    /**
     * testExtractIndex07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"ab[c]d[3]"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"3"<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"[]"Ăp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractIndex07() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "ab[c]d[3]";
                
        // eXg{
        String result = test.extractIndex(property);
        
        // 
        assertEquals("3",result);
    }

    /**
     * testEscapeMapProperty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         () extractMapPropertyName:property+"Name"ԂB<br>
     *         () extractMapPropertyKey:property+"Key"<br>
     *         
     * <br>
     * ҒlF(߂l) String:abcName/abcKey<br>
     *         (ԕω) extractMapPropertyName:\bh͈(property="abc")Ŗ߂lproperty+"Name"ƂB<br>
     *         (ԕω) extractMapPropertyKey:\bh͈(property="abc")Ŗ߂lproperty+"Key"ƂB<br>
     *         
     * <br>
     * y\bȟĂяoƌʂ̐`̃eXgz
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testEscapeMapProperty01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = "abc";
        
        // eXg{
        String result = test.escapeMapProperty(property);
        
        // 
        assertEquals("abcName/abcKey",result);
    }

    /**
     * testExtractMapPropertyName01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() property:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map attribute. Invalid property name. ''<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map attribute. Invalid property name. ''<br>
     *         
     * <br>
     * y󕶎̃eXgz<br>
     * property󕶎̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyName01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "";
        
        // eXg{
        try{
            test.extractMapPropertyName(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals(
                    "Cannot get Map attribute. Invalid property name. ''", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "Cannot get Map attribute. Invalid property name. ''"));
            
        }
    }

    /**
     * testExtractMapPropertyName02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map attribute. Invalid property name. 'abc'<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map attribute. Invalid property name. 'abc'<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property"("܂")"ĂȂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyName02() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "abc";
        
        // eXg{
        try{
            test.extractMapPropertyName(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Map attribute. Invalid property name. 'abc'", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Map attribute. Invalid property name. 'abc'"));
            
        }
    }

    /**
     * testExtractMapPropertyName03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"("<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"("̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyName03() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒lݒ
        String property = "(";
        
        // eXg{
        String result = test.extractMapPropertyName(property);
        
        // 
        assertEquals("",result);
    }

    /**
     * testExtractMapPropertyName04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"ab()"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"ab"<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"()"̑OɂĂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyName04() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒lݒ
        String property = "ab()";
        
        // eXg{
        String result = test.extractMapPropertyName(property);
        
        // 
        assertEquals("ab",result);
    }

    /**
     * testExtractMapPropertyKey01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() property:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map key. Invalid property name. ''<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. ''<br>
     *         
     * <br>
     * y󕶎̃eXgz<br>
     * property󕶎̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "";
        
        // eXg{
        try{
            test.extractMapPropertyKey(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Map key. Invalid property name. ''", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Map key. Invalid property name. ''"));
            
        }
    }

    /**
     * testExtractMapPropertyKey02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map key. Invalid property name. 'abc'<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. 'abc'<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property"("܂")"ĂȂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey02() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "abc";
        
        // eXg{
        try{
            test.extractMapPropertyKey(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Map key. Invalid property name. 'abc'", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Map key. Invalid property name. 'abc'"));
            
        }
    }

    /**
     * testExtractMapPropertyKey03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"("<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map key. Invalid property name. '('<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. '('<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property"("̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey03() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = "(";
        
        // eXg{
        try{
            test.extractMapPropertyKey(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Map key. Invalid property name. '('", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Map key. Invalid property name. '('"));
            
        }
    }

    /**
     * testExtractMapPropertyKey04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:")"<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map key. Invalid property name. ')'<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. ')'<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property")"̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey04() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = ")";
        
        // eXg{
        try{
            test.extractMapPropertyKey(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Map key. Invalid property name. ')'", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Map key. Invalid property name. ')'"));
            
        }
    }

    /**
     * testExtractMapPropertyKey05()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:")("<br>
     *         
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    @bZ[WFCannot get Map key. Invalid property name. ')('<br>
     *         (ԕω) O:OxFG[<br>
     *                    Cannot get Map key. Invalid property name. ')('<br>
     *         
     * <br>
     * ys̃eXgz<br>
     * property")("̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey05() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒l
        String property = ")(";
        
        // eXg{
        try{
            test.extractMapPropertyKey(property);
            fail();
        }catch(IllegalArgumentException e){
            // 
            assertEquals("Cannot get Map key. Invalid property name. ')('", 
                        e.getMessage());
            assertTrue(LogUTUtil.checkError(
                            "Cannot get Map key. Invalid property name. ')('"));
            
        }
    }

    /**
     * testExtractMapPropertyKey06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"()"<br>
     *         
     * <br>
     * ҒlF(߂l) String:""<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"()"̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey06() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒lݒ
        String property = "()";
        
        // eXg{
        String result = test.extractMapPropertyKey(property);
        
        // 
        assertEquals("",result);
    }

    /**
     * testExtractMapPropertyKey07()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"ab(cd)e"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"cd"<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"("")"̑OɕĂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testExtractMapPropertyKey07() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImpl test = 
            new JXPathIndexedBeanWrapperImpl(object);
        
        // ͒lݒ
        String property = "ab(cd)e";
        
        // eXg{
        String result = test.extractMapPropertyKey(property);
        
        // 
        assertEquals("cd",result);
    }

    /**
     * testIsMapProperty01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() property:""i󕶎j<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * y󕶎̃eXgz<br>
     * property󕶎̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapProperty01() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = "";
        
        // eXg{
        boolean result = test.isMapProperty(property);
        
        // 
        assertFalse(result);
    }

    /**
     * testIsMapProperty02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"("܂")"ĂȂp^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapProperty02() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = "abc";
        
        // eXg{
        boolean result = test.isMapProperty(property);
        
        // 
        assertFalse(result);
    }

    /**
     * testIsMapProperty03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"("<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"("̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapProperty03() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = "(";
        
        // eXg{
        boolean result = test.isMapProperty(property);
        
        // 
        assertFalse(result);
    }

    /**
     * testIsMapProperty04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:")"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property")"̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapProperty04() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = ")";
        
        // eXg{
        boolean result = test.isMapProperty(property);
        
        // 
        assertFalse(result);
    }

    /**
     * testIsMapProperty05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:")("<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property")("̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapProperty05() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = ")(";
        
        // eXg{
        boolean result = test.isMapProperty(property);
        
        // 
        assertTrue(result);
    }

    /**
     * testIsMapProperty06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() property:"()"<br>
     *         
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         
     * <br>
     * ỹeXgz<br>
     * property"()"̃p^[̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testIsMapProperty06() throws Exception {
        // O
        Object object = new Object();
        JXPathIndexedBeanWrapperImplStub01 test = 
            new JXPathIndexedBeanWrapperImplStub01(object);
        
        // ͒lݒ
        String property = "()";
        
        // eXg{
        boolean result = test.isMapProperty(property);
        
        // 
        assertTrue(result);
    }

}
