/*
 * Copyright (c) 2014 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.oxm.parser;

import org.apache.xerces.impl.Constants;
import org.exolab.castor.util.DTDResolver;

import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.oxm.parser.DisallowDTDSecureSAXParser}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * org.apache.xerces.parsers.SAXParser̃ZLAȃTuNXB<br>
 * </p>
 * 
 * @see jp.terasoluna.fw.oxm.parser.DisallowDTDSecureSAXParser
 */
public class DisallowDTDSecureSAXParserTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DisallowDTDSecureSAXParserTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DisallowDTDSecureSAXParserTest(String name) {
        super(name);
    }

    /**
     * testSetEntityResolver01()
     * <br><br>
     * 
     * (n)
     * <br>
     * CX^XA
     * http://apache.org/xml/features/disallow-doctype-declFeaturetrueł邱ƂmFB
     * @throws Exception
     */
    public void testSetEntityResolver01() throws Exception {
        DisallowDTDSecureSAXParser parser = new DisallowDTDSecureSAXParser();

        assertTrue(parser.getFeature(Constants.XERCES_FEATURE_PREFIX + Constants.DISALLOW_DOCTYPE_DECL_FEATURE));
    }

    /**
     * testSetEntityResolver02()
     * <br><br>
     * 
     * (n)
     * <br>
     * CX^XAsetEntityResolvernullݒ肳ĂA
     * http://apache.org/xml/features/disallow-doctype-declFeaturetruê܂܂ł邱ƂmFB
     * @throws Exception
     */
    public void testSetEntityResolver02() throws Exception {
        DisallowDTDSecureSAXParser parser = new DisallowDTDSecureSAXParser();
        parser.setEntityResolver(null);

        assertTrue(parser.getFeature(Constants.XERCES_FEATURE_PREFIX + Constants.DISALLOW_DOCTYPE_DECL_FEATURE));
    }

    /**
     * testSetEntityResolver03()
     * <br><br>
     * 
     * (n)
     * <br>
     * CX^XAorg.exolab.castor.util.DTDResolverȊOEntityResolverݒ肳ĂA
     * http://apache.org/xml/features/disallow-doctype-declFeaturetruê܂܂ł邱ƂmFB
     * @throws Exception
     */
    public void testSetEntityResolver03() throws Exception {
        DisallowDTDSecureSAXParser parser = new DisallowDTDSecureSAXParser();
        parser.setEntityResolver(new DisallowDTDSecureSAXParserTest_EntityResolverStub01());

        assertTrue(parser.getFeature(Constants.XERCES_FEATURE_PREFIX + Constants.DISALLOW_DOCTYPE_DECL_FEATURE));
    }

    /**
     * testSetEntityResolver04()
     * <br><br>
     * 
     * (n)
     * <br>
     * CX^XAorg.exolab.castor.util.DTDResolverݒ肳ƁA
     * http://apache.org/xml/features/disallow-doctype-declFeaturefalseɂȂ邱ƂmFB
     * @throws Exception
     */
    public void testSetEntityResolver04() throws Exception {
        DisallowDTDSecureSAXParser parser = new DisallowDTDSecureSAXParser();
        parser.setEntityResolver(new DTDResolver());

        assertFalse(parser.getFeature(Constants.XERCES_FEATURE_PREFIX + Constants.DISALLOW_DOCTYPE_DECL_FEATURE));
    }

}
