/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib.spring.mock;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * UpdateDAÕbNAbvNXB
 * 
 * P̎UpdateDAO̎NXƂĐݒ肷B
 * UpdateDAÕ\bh̕ԋpliҒlj
 * \bhs鏇ԂupdateDAOResultsɓo^A
 * eXgΏۃNXUpdateDAOtB[hɐݒ肷B
 * eXgsɁAUpdateDAÕ\bhĂ΂x
 * updateDAOResultsɓo^ĂIuWFNgɕԋpB
 * ivoid̃\bh͏j
 *
 */
public class MockUpdateDAO implements UpdateDAO {
    
    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(MockUpdateDAO.class);
    
    /**
     * \bhs񃊃XgB
     * NX̃\bhsxɁAɊi[B
     */
    private List<DAOParams> updateDAOParams = new ArrayList<DAOParams>();
    
    /**
     * \bhs񃊃Xg擾B
     *
     * @return \bhs񃊃Xg
     */
    public List<DAOParams> getUpdateDAOParams() {
        return updateDAOParams;
    }
    
    /**
     * \bhԋplXgB
     * NX̃\bhsxɁAԋpli[B
     */
    private List<Object> updateDAOResults = new ArrayList<Object>();

    /**
     * \bhԋplXgɒǉB
     *
     * @param updateDAOResult \bhԋpl
     */
    public void addUpdateDAOResults(Integer updateDAOResult) {
        updateDAOResults.add(updateDAOResult);
    }

    /**
     * \bhԋplXgɒǉB
     *
     * @param updateDAOResult \bhԋpl
     */
    public void addUpdateDAOResults(int updateDAOResult) {
        updateDAOResults.add(Integer.valueOf(updateDAOResult));
    }

    /**
     * \bhԋplXgɒǉB
     *
     * @param exception X[OIuWFNg
     */
    public void addUpdateDAOResults(RuntimeException exception) {
        updateDAOResults.add(exception);
    }

    /**
     * updateDAOParamsɊi[A
     * updateDAOResults̈ԖڂɊi[ꂽlintƂĕԋpB
     * ԋplupdateDAOResults͍폜B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @return SQL̎sʌԋp
     */    
    public int execute(String sqlID, Object bindParams) {
        if (log.isDebugEnabled()) {
            log.debug("execute Start.");
        }

        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        
        // \bhi[
        params.setMethodName("execute");
        
        // \bhs񃊃XgɊi[
        updateDAOParams.add(params);
        
        return processExecute();
    }

    /**
     * \bhupdateDAOParamsɊi[B
     */
    public void startBatch() {

        // \bhi[
        DAOParams params = new DAOParams();
        params.setMethodName("startBatch");
        
        // \bhs񃊃XgɊi[
        updateDAOParams.add(params);
    }

    /**
     * updateDAOParamsɊi[B
     * 
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     * @deprecated addBatch̑{@link #executeBatch(List)}
     * gp邱
     */
    @SuppressWarnings("deprecation")
    @Deprecated
    public void addBatch(String sqlID, Object bindParams) {
        // i[
        DAOParams params = new DAOParams();
        params.setSqlID(sqlID);
        params.setBindParams(bindParams);
        
        // \bhi[
        params.setMethodName("addBatch");
        
        // \bhs񃊃XgɊi[
        updateDAOParams.add(params);
    }

    /**
     * \bhupdateDAOParamsɊi[A
     * updateDAOResults̈ԖڂɊi[ꂽlintƂĕԋpB
     * ԋplupdateDAOResults͍폜B
     * 
     * @return SQL̎s
     * @deprecated addBatch̑{@link #executeBatch(List)}
     * gp邱
     */
    @SuppressWarnings("deprecation")
    @Deprecated
    public int executeBatch() {

        // \bhi[
        DAOParams params = new DAOParams();
        params.setMethodName("executeBatch");
        
        // \bhs񃊃XgɊi[
        updateDAOParams.add(params);
        
        return processExecute();
    }


    /**
     * \bhupdateDAOParamsɁA
     * sΏSQL̃XgDAOParamsƂupdateDAOResultsXg
     * ǉB
     * updateDAOResults̈ԖڂɊi[ꂽlintƂĕԋpB
     * ԋplupdateDAOResults͍폜B
     * 
     * @return updateDAOResults̈ԖڂɊi[ꂽl
     */
    public int executeBatch(List<SqlHolder> sqlHolders) {
        if (sqlHolders != null) {
            for (SqlHolder sqlHolder : sqlHolders) {
                String sqlId = sqlHolder.getSqlID();
                Object param = sqlHolder.getBindParams();
                DAOParams params = new DAOParams();
                params.setMethodName("executeBatch");
                params.setSqlID(sqlId);
                params.setBindParams(param);
                updateDAOParams.add(params);
            }
        }
        return processExecute();
    }
    
    /**
     * updateDAOResults̈ԖڂɊi[ꂽlintƂĕԋpB
     * ԋplupdateDAOResults͍폜B
     * i[ꂽIuWFNgRuntimeExceptionIuWFNg̏ꍇ
     * ̗OX[B
     * ȊȌꍇ́AIllegalStateExceptionX[B
     * @return ߂lƂĊi[ꂽl
     */
    private int processExecute() {
        
        // ԋpl̎擾
        Object obj = updateDAOResults.get(0);
        
        // ԋpς݂ƂȂԋplXg폜
        updateDAOResults.remove(0);
        
        if (obj instanceof RuntimeException) {
            throw (RuntimeException)obj;
        } else if (obj instanceof Integer) {
            
            int row = ((Integer)obj).intValue();
            if (log.isDebugEnabled()) {
                log.debug("success count:" + row);
            }
            if (log.isDebugEnabled()) {
                log.debug("execute End.");
            }
            return row;
        } else {
            throw new IllegalStateException("results value is illegal.");
        }
    }
}