/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.io.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.io.impl.AbstractInputSource;
import jp.terasoluna.fw.ex.unit.util.DefaultLineSplitter;
import jp.terasoluna.fw.ex.unit.util.DefaultPopulator;
import jp.terasoluna.fw.ex.unit.util.LineSplitter;
import jp.terasoluna.fw.ex.unit.util.Populator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvSource<T>
extends AbstractInputSource<T> {
    private File input = null;
    private boolean hasHeader = true;
    private Class<T> clazz;
    private Populator<T> populator = new DefaultPopulator();
    private String[] mappedHeader;
    private String encoding = "MS932";
    private LineSplitter lineSplitter = new DefaultLineSplitter(",");

    public CsvSource(File input, Class<T> clazz) {
        this.input = input;
        this.clazz = clazz;
    }

    public CsvSource(String path, Class<T> clazz) throws UTRuntimeException {
        try {
            URL url = CsvSource.class.getClassLoader().getResource(path);
            this.input = url == null ? new File(path) : new File(URLDecoder.decode(url.getPath(), "UTF-8"));
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
        this.clazz = clazz;
    }

    protected T populate(String line) {
        Object[] vals = this.lineSplitter.split(line);
        T obj = this.populator.populate(this.clazz, this.mappedHeader, vals);
        return obj;
    }

    @Override
    public Iterator<T> getIterator() {
        Iterator itr = null;
        try {
            final BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.input), this.encoding));
            if (this.header == null) {
                this.setHeader(this.lineSplitter.split(reader.readLine()));
            } else if (this.hasHeader) {
                reader.readLine();
            }
            itr = new Iterator<T>(){
                private boolean readLine = true;
                private String line;
                private boolean closed = false;

                @Override
                public synchronized boolean hasNext() {
                    try {
                        if (this.readLine) {
                            this.line = reader.readLine();
                            this.readLine = false;
                        }
                        if (this.line == null && !this.closed) {
                            reader.close();
                            this.closed = true;
                        }
                    }
                    catch (IOException e) {
                        throw new UTRuntimeException(e);
                    }
                    return this.line != null;
                }

                @Override
                public synchronized T next() {
                    Object obj = null;
                    try {
                        if (this.readLine) {
                            this.line = reader.readLine();
                            this.readLine = false;
                        }
                        if (this.line == null) {
                            if (!this.closed) {
                                reader.close();
                                this.closed = true;
                            }
                            throw new NoSuchElementException();
                        }
                        obj = CsvSource.this.populate(this.line);
                    }
                    catch (NoSuchElementException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new UTRuntimeException(e);
                    }
                    this.readLine = true;
                    return obj;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
        return itr;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public void setPopulator(Populator<T> populate) {
        this.populator = populate;
    }

    public void setLineSplitter(LineSplitter lineSplitter) {
        this.lineSplitter = lineSplitter;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void setHeader(String[] header) {
        super.setHeader(header);
        if (this.headerMap == null) {
            this.mappedHeader = header;
        } else {
            this.mappedHeader = new String[header.length];
            int i = 0;
            while (i < header.length) {
                String h = (String)this.headerMap.get(header[i]);
                this.mappedHeader[i] = h != null ? h : header[i];
                ++i;
            }
        }
    }
}

