/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jp.terasoluna.fw.ex.unit.exception.ReflectionFailedException;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionUtils {
    public static <T> T newInstance(Class<T> clazz) {
        Assert.notNull(clazz);
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] argClasses, Object[] args) {
        Assert.notNull(clazz);
        try {
            Constructor<T> c = clazz.getDeclaredConstructor(argClasses);
            c.setAccessible(true);
            return c.newInstance(args);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static <T> T getField(Object obj, String name) {
        Assert.notNull((Object)obj);
        return ReflectionUtils.getField(obj, obj.getClass(), name);
    }

    public static <T> T getField(Object obj, Class<?> clazz, String name) {
        Assert.notNull(clazz);
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static <T> T getField(Class<?> clazz, String name) {
        Assert.notNull(clazz);
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return (T)field.get(null);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static void setField(Object obj, String name, Object value) {
        Assert.notNull((Object)obj);
        try {
            Field field = obj.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(obj, value);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static void setField(Class<?> clazz, String name, Object value) {
        Assert.notNull(clazz);
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            field.set(null, value);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Assert.notNull((Object)obj);
        try {
            Method method = obj.getClass().getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return (T)method.invoke(obj, args);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static <T> T invoke(Object obj, String methodName) {
        return ReflectionUtils.invoke(obj, methodName, new Class[0], new Object[0]);
    }

    public static <T> T invoke(Class<?> clazz, String methodName, Class<?>[] parameterTypes, Object[] args) {
        Assert.notNull(clazz);
        try {
            Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
            method.setAccessible(true);
            return (T)method.invoke(null, args);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static <T> T invoke(Class<?> clazz, String methodName) {
        Assert.notNull(clazz);
        try {
            Method method = clazz.getDeclaredMethod(methodName, new Class[0]);
            method.setAccessible(true);
            return (T)method.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionFailedException(e);
        }
    }

    public static String[] createFiledNames(Class<?> clazz) {
        Assert.notNull(clazz);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(clazz);
        PropertyDescriptor[] descs = beanWrapper.getPropertyDescriptors();
        String[] fieldNames = new String[descs.length - 1];
        int j = 0;
        for (int i = 0; i < descs.length; ++i) {
            String name = descs[i].getName();
            if ("class".equals(name)) continue;
            fieldNames[j++] = name;
        }
        return fieldNames;
    }

    public static Class<?>[] classes(Class<?> ... classes) {
        return classes;
    }

    public static Object[] args(Object ... args) {
        return args;
    }
}

