/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.web.struts.action;

import static org.junit.Assert.*;
import jp.terasoluna.fw.ex.exception.ValidationException;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ExceptionConfig;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ValidationExceptionHandlerTest {

    private ValidationExceptionHandler validationExceptionHandler;

    @Before
    public void setUp() throws Exception {
        validationExceptionHandler = new ValidationExceptionHandler();
    }

    @After
    public void tearDown() throws Exception {
        validationExceptionHandler = null;
    }

    @Test
    public final void testGetInputActionForward() {
        ValidationException validationException = new ValidationException(null);
        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMapping.class);
        ExceptionConfig ae = EasyMock.createMock(ExceptionConfig.class);
        ActionForward expectedActionForward = new ActionForward();
        EasyMock.expect(actionMappingMock.getInputForward()).andReturn(
                expectedActionForward);
        EasyMock.expect(actionMappingMock.getInputForward()).andReturn(
                expectedActionForward);
        EasyMock.replay(actionMappingMock);
        ActionForward actualActionForward = validationExceptionHandler
                .getActionForward(validationException, ae, actionMappingMock,
                        null);
        assertEquals(expectedActionForward, actualActionForward);
        EasyMock.verify(actionMappingMock);
    }

    @Test
    public final void testGetNullInputActionForward() {
        ValidationException validationException = new ValidationException(null);
        ActionMapping actionMappingMock = EasyMock
                .createMock(ActionMapping.class);
        EasyMock.expect(actionMappingMock.getInputForward()).andReturn(null);

        ExceptionConfig exceptionConfigMock = EasyMock
                .createMock(ExceptionConfig.class);
        String expectedPath = "expectedPath";
        EasyMock.expect(exceptionConfigMock.getPath()).andReturn(expectedPath)
                .times(2);

        EasyMock.replay(actionMappingMock, exceptionConfigMock);

        ActionForward actualActionForward = validationExceptionHandler
                .getActionForward(validationException, exceptionConfigMock,
                        actionMappingMock, null);
        assertEquals(expectedPath, actualActionForward.getPath());
        EasyMock.verify(exceptionConfigMock, exceptionConfigMock);
    }

    @Test
    public final void testNotValidationException() {
        Exception exception = new Exception();
        ExceptionConfig exceptionConfigMock = EasyMock
                .createMock(ExceptionConfig.class);
        String expectedPath = "expectedPath";
        EasyMock.expect(exceptionConfigMock.getPath()).andReturn(expectedPath)
                .times(2);
        EasyMock.replay(exceptionConfigMock);

        ActionForward actualActionForward = validationExceptionHandler
                .getActionForward(exception, exceptionConfigMock, null, null);
        assertEquals(expectedPath, actualActionForward.getPath());
        EasyMock.verify(exceptionConfigMock);
    }
}
