/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.fw.ex.unit.io.InputSource;
import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.JdbcTemplateUtils;

import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.jdbc.core.JdbcTemplate;

/**
 * ̓\[XIuWFNgDBɏo͂܂B <br>
 * RXgN^܂setterɂĈȉ̃p[^w肵܂B<br>
 * <table border=1>
 * <tr>
 * <th>p[^</th>
 * <th></th>
 * <th>ݒӏ</th>
 * <th>K{</th>
 * </tr>
 * <tr>
 * <td>jdbcTemplate</td>
 * <td>{@link JdbcTemplate}IuWFNgB{@link DataSource} IuWFNgݒ肳ĂKv܂B</td>
 * <td>RXgN^</td>
 * <td></td>
 * </tr>
 * <tr>
 * <td>tableName</td>
 * <td>o͐e[uB</td>
 * <td>RXgN^</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>clazz</td>
 * <td>o͑ΏۂƂȂBeañNXB̃NXo͐e[uɎgp܂B</td>
 * <td>RXgN^</td>
 * <td>&nbsp;</td>
 * </tr>
 * <tr>
 * <td>sql</td>
 * <td>
 * f[^}pSQLBftHgł̓e[uƃwb_񂩂玩ō쐬܂Bō쐬ꂽSQLł̓eXgłȂꍇ̂ݕύXĂB(
 * {@link #setSql(String)}Q)</td>
 * <td>setter</td>
 * <td>&nbsp;</td>
 * </tr>
 * </table>
 * 
 * <br>
 * ftHgł̓e[u{@link InputSource}nwb_񂩂INSERT쐬A{@link InputSource}
 * IuWFNg̒l𖄂ߍSQLs܂B<br>
 * yz<br>
 * e[uPersonAwb_{id, name, address}̏ꍇA<br>
 * INSERT INTO Person(id, name, address) VALUES(?, ?, ?)ƂINSERT쐬܂B<br>
 * ePersonIuWFNgidAnameAaddresslvyAhXe[gg̃oChp[^ƂĖߍ܂ASQLs܂B
 * 
 * <br>
 * gp{@link jp.terasoluna.fw.ex.unit.io.impl.CsvSource}QƁB
 * 
 */
public class DbTarget<T> implements OutputTarget<T> {
    protected final JdbcTemplate template;
    protected String sql;
    protected String[] header;
    protected String tableName;

    public DbTarget(JdbcTemplate template, String tableName) {
        this.template = template;
        this.tableName = tableName;
    }

    public DbTarget(JdbcTemplate template, Class<T> clazz) {
        this(template, clazz.getSimpleName());
    }

    public void write(T obj) {
        BeanWrapper beanWrapper = new BeanWrapperImpl(obj);
        List<Object> list = new ArrayList<Object>();

        for (String propertyName : header) {
            if (beanWrapper.isReadableProperty(propertyName)) {
                list.add(beanWrapper.getPropertyValue(propertyName));
            } else {
                list.add(null);
            }
        }
        JdbcTemplateUtils.update(template, sql,
                list.toArray(new Object[list.size()]));
    }

    public void writeHeader(String[] header) {
        this.header = header;
        if (getSql() == null) {
            this.sql = JdbcTemplateUtils.createInsertSql(tableName, header);
        }
    }

    public void close() {
        // ܂
    }

    /**
     * f[^}pSQLԋp܂B
     * 
     * @return f[^}pSQL
     */
    public String getSql() {
        return sql;
    }

    /**
     * f[^}pSQLݒ肵܂B
     * 
     * <pre>
     * SQL{@link #write(Object)}\bhsɁAsIuWFNg̃tB[hloChĎs܂B
     * oChp[^̏Ԃ{@link #writeHeader(String[])}œnwb_̏ԂɈv܂B
     * 
     * {\bhSQLݒ肵Ȃꍇ{@link #writeHeader(String[])}œnwb_ƃe[u玩
     * SQL쐬܂({@link JdbcTemplateUtils#createInsertSql(String, String[])}gp)B
     * wb_̏{@link #writeHeader(String[])}sɂĕς邽߁A
     * {\bhSQLݒ肷ꍇ͕Kwb_̏mFĂB
     * </pre>
     * 
     * @param sql
     *            f[^}pSQL
     */
    public void setSql(String sql) {
        this.sql = sql;
    }
}
