/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import junitx.util.PrivateAccessor;


/**
 * private\bhĂяo߂̃[eBeBNXB
 * 
 */
class PrivateAccessUtil {

    /**
     * private\bhistaticłȂ́jĂяoB<BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA
     * 𗘗pVvɋLqłB
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName,
            Class[] argTypes, Object[] args) throws Exception {
        
        // JUnit Addons̃\bhĂяoB
        Object val = null;
        try {
            val = PrivateAccessor.invoke(target, methodName, argTypes, args);
        } catch (Throwable t) {
            Exception e = (Exception) t;
            throw e;
        }
        return val;
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^0pjB
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName)
        throws Exception {

        return invokePrivate(target, methodName, 
            new Class[] {}, new Object[] {});
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^1pjB
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName,
            Class argType, Object arg) throws Exception {

        return invokePrivate(target, methodName,
            new Class[] { argType }, new Object[] { arg });
    }

    /**
     * private\bhistaticłȂ́jĂяoip[^2pjB
     * 
     * @param target ĂяoΏۂ̃IuWFNg
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Object target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
            throws Exception {

        return invokePrivate(target, methodName,
            new Class[] { argType1, argType2 }, new Object[] { arg1, arg2 });
    }


    /**
     * staticprivate\bhĂяoB
     * <BR><BR>
     * p[^0`2̃\bhɂ͐p̃\bhpӂĂ̂ŁA
     * 𗘗pVvɋLqłB
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argTypes ̌^̔z
     * @param args ̒l̔zB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName,
            Class[] argTypes, Object[] args) throws Exception {

        // JUnit Addons̃\bhĂяoB
        Object val = null;
        try {
            val = PrivateAccessor.invoke(target, methodName, argTypes, args);
        } catch (Throwable t) {
            Exception e = (Exception) t;
            throw e;
        }
        return val;
    }
    
    /**
     * staticprivate\bhĂяoip[^0pjB
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName)
        throws Exception {

        return invokePrivate(target, methodName, new Class[] {}, 
            new Object[] {});
    }

    /**
     * staticprivate\bhĂяoip[^1pjB
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType ̌^
     * @param arg ̒lB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName,
            Class argType, Object arg) throws Exception {

        return invokePrivate(target, methodName, new Class[] { argType },
            new Object[] { arg });
    }

    /**
     * staticprivate\bhĂяoip[^2pjB
     * 
     * @param target ĂяoΏۂ̃NX
     * @param methodName Ăяo\bh̖O
     * @param argType1 ̌^
     * @param argType2 ̌^
     * @param arg1 ̒lB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @param arg2 ̒lB
     * @return \bh̖߂lBĂяoŃ_ELXgKvB
     * int, boolean̊{f[^^́AInteger, Boolean
     * bp[NXɊi[Ēl߂B
     * @throws Exception
     */
    public static Object invokePrivate(Class target, String methodName,
            Class argType1, Class argType2, Object arg1, Object arg2)
            throws Exception {

        return invokePrivate(target, methodName, 
            new Class[] { argType1, argType2 }, new Object[] { arg1, arg2 });
    }

    /**
     * w肵IuWFNgprivatetB[h̒lԂB
     *
     * @param target Ώۂ̃IuWFNg
     * @param fieldName l擾privatetB[h̖O
     * @return privatetB[h̒l
     * @exception NoSuchFieldException
     */
    public static Object getField(Object target, String fieldName)
            throws NoSuchFieldException {
            
        // JUnit Addons̃\bhĂяoB
        return PrivateAccessor.getField(target, fieldName);
    }

    /**
     * w肵NXstaticprivatetB[h̒lԂB
     *
     * @param target Ώۂ̃NX
     * @param fieldName l擾privatetB[h̖O
     * @return privatetB[h̒l
     * @exception NoSuchFieldException
     */
    public static Object getField(Class target, String fieldName)
            throws NoSuchFieldException {

        // JUnit Addons̃\bhĂяoB
        return PrivateAccessor.getField(target, fieldName);
    }

    /**
     * w肵IuWFNgprivatetB[hɒlݒ肷B
     * 
     * @param target Ώۂ̃IuWFNg
     * @param fieldName lݒ肷privatetB[h̖O
     * @param value ݒ肷lB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @exception NoSuchFieldException
     */
    public static void setField(Object target, String fieldName, Object value)
            throws NoSuchFieldException {

        // JUnit Addons̃\bhĂяoB
        PrivateAccessor.setField(target, fieldName, value);
    }

    /**
     * w肵NXstaticprivatetB[hɒlݒ肷B
     * 
     * @param target Ώۂ̃NX
     * @param fieldName lݒ肷privatetB[h̖O
     * @param value ݒ肷lB
     * int,boolean̊{f[^^́AInteger, Booleañbp[NX
     * i[ĒlnKvB
     * @exception NoSuchFieldException
     */
    public static void setField(Class target, String fieldName, Object value)
            throws NoSuchFieldException {
            
        // JUnit Addons̃\bhĂяoB
        PrivateAccessor.setField(target, fieldName, value);
    }

    /**
     * privateȃRXgN^B
     */
    private PrivateAccessUtil() {
    }

}
