/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.io.impl;

import java.util.Collection;
import java.util.Iterator;

import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;

/**
 * {@link Collection}̓\[X쐬܂B
 * 
 */
public class CollectionSource<T> extends AbstractInputSource<T> {
    private Collection<T> collection;

    /**
     * RXgN^
     * 
     * <pre>
     * ̃NX{@link CollectionSource}쐬A{@link OutputTarget}ɏo͂ꍇA
     * {@link #setHeader(String[])}ɂăwb_ݒ肷邱ƁB
     * </pre>
     * 
     * @param collection
     *            ͌ƂȂRNV
     */
    public CollectionSource(Collection<T> collection) {
        super();
        this.collection = collection;
        if (!collection.isEmpty()) {
            T obj = collection.iterator().next();
            super.header = ReflectionUtils.createFiledNames(obj.getClass());
        }
    }

    /**
     * RXgN^
     * 
     * @param collection
     *            ͌ƂȂRNV
     * @param clazz
     *            sf[^}bsONX
     */
    public CollectionSource(Collection<T> collection, Class<T> clazz) {
        super();
        this.collection = collection;
        super.header = ReflectionUtils.createFiledNames(clazz);
    }

    public Iterator<T> getIterator() {
        return collection.iterator();
    }
}
