/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.unit.common;

/**
 * vpeB̃L[\񋓌^łB
 * 
 * <pre>
 * 񋓌^ɂAu_vu.vɒûvpeB̃L[ɂȂ܂B
 * 
 * AAA_BBB => aaa.bbb
 * 
 * ̗񋓌^ŊǗvpeB̃L[ɑ啶gpłȂƂɒӂĂB
 * </pre>
 * 
 * @author maki
 * 
 */
public enum PropertyKeys {
    /**
     * WEBAvP[VpX
     */
    WEBAPP_PATH,
    /**
     * WEB-INFpX
     */
    WEBINF_DIR,
    /**
     * META-INFpX
     */
    METAINF_DIR,
    /**
     *
     */
    CONTEXT_FILE,
    /**
     * AvP[VReLXg`t@CpX
     */
    APPLICATIONCONTEXT_FILE,
    /**
     * W[`t@CpX
     */
    MODULECONTEXT_FILE,
    /**
     * bNDAO`t@CpX
     */
    MOCKDAOBEANS_FILE,
    /**
     * BLogicResult̐\
     */
    SUCCESS_STRING,
    /**
     * BLogicResult̎s\
     */
    FAILURE_STRING;

    /**
     * vpeB̃L[
     */
    private final String key;

    private PropertyKeys() {
        key = name().toLowerCase().replace("_", ".");
    }

    /**
     * vpeB̃L[`ŕԋp܂B
     * 
     * @return vpeB̃L[
     */
    public String getKey() {
        return key;
    }
}
