/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;

import jp.terasoluna.fw.exception.SystemException;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.DownloadFile} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * t@C_E[hf[^Ƃ邽߂̃NXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.DownloadFile
 */
public class DownloadFileTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DownloadFileTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DownloadFileTest(String name) {
        super(name);
    }

    /**
     * testDownloadFileFile01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() File:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.no.download.content"<br>
     *                    bvOF<br>
     *                    IllegalArgumentException<br>
     *         
     * <br>
     * filenull̏ꍇAOX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileFile01() throws Exception {
        // O

        // eXg{
        try {
            @SuppressWarnings("unused")
            DownloadFile downloadFile = new DownloadFile(null);
            fail("SystemException܂ł");
        } catch (SystemException e) {
            // 
            assertEquals("errors.no.download.content", e.getErrorCode());
            assertEquals(IllegalArgumentException.class, 
                    e.getCause().getClass());
        }
    }

    /**
     * testDownloadFileFile02()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() File:File()<br>
     *         
     * <br>
     * ҒlF(ԕω) name:File#getName̒l<br>
     *         (ԕω) file:File<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * name, contentType, charsetɃftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileFile02() throws Exception {
        // O
        File file = new File("");

        // eXg{
        DownloadFile downloadFile = new DownloadFile(file);
        
        // 
        assertEquals(file.getName(), downloadFile.name);
        assertEquals(file, downloadFile.file);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE, downloadFile.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, downloadFile.charset);
    }

    /**
     * testDownloadFileStringFile01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *         () file:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F<br>
     *                    "errors.no.download.content"<br>
     *                    bvOF<br>
     *                    IllegalArgumentException<br>
     *         
     * <br>
     * byteArraynull̏ꍇAOX[邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileStringFile01() throws Exception {
        // O

        // eXg{
        try {
            @SuppressWarnings("unused")
            DownloadFile downloadFile = new DownloadFile(null, null);
            fail("SystemException܂łB");
        } catch (SystemException e) {
            // 
            assertEquals("errors.no.download.content", e.getErrorCode());
            assertEquals(IllegalArgumentException.class, 
                    e.getCause().getClass());
        }

    }

    /**
     * testDownloadFileStringFile02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:null<br>
     *         () file:File#createTempFile<br>
     *         
     * <br>
     * ҒlF(ԕω) name:File#getName̒l<br>
     *         (ԕω) file:File<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * contentType, charsetɃftHglݒ肳邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileStringFile02() throws Exception {
        // O
        File file = File.createTempFile("abc", "def");

        // eXg{
        DownloadFile downloadFile = new DownloadFile(null, file);

        // 
        assertEquals(file.getName(), downloadFile.name);
        assertEquals(file, downloadFile.file);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE, 
                downloadFile.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, 
                downloadFile.charset);
    }

    /**
     * testDownloadFileStringFile03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"  "i󔒁j<br>
     *         () file:File#createTempFile<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"  "i󔒁j<br>
     *         (ԕω) file:File<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ󔒂̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileStringFile03() throws Exception {
        // O
        File file = File.createTempFile("abc", "def");

        // eXg{
        DownloadFile downloadFile = new DownloadFile("  ", file);

        // 
        assertEquals("  ", downloadFile.name);
        assertEquals(file, downloadFile.file);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE, 
                downloadFile.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, 
                downloadFile.charset);
    }

    /**
     * testDownloadFileStringFile04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""i󕶎j<br>
     *         () file:File#createTempFile<br>
     *         
     * <br>
     * ҒlF(ԕω) name:File#getName̒l<br>
     *         (ԕω) file:File<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ󕶎̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileStringFile04() throws Exception {
        // O
        File file = File.createTempFile("abc", "def");

        // eXg{
        DownloadFile downloadFile = new DownloadFile("", file);

        // 
        assertEquals(file.getName(), downloadFile.name);
        assertEquals(file, downloadFile.file);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE, 
                downloadFile.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, 
                downloadFile.charset);
    }

    /**
     * testDownloadFileStringFile05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () file:File#createTempFile<br>
     *         
     * <br>
     * ҒlF(ԕω) name:"abc"<br>
     *         (ԕω) file:File<br>
     *         (ԕω) contentType:DEFAULT_CONTENT_TYPEݒ肳Ă邱<br>
     *         (ԕω) charset:DEFAULT_CHARSETݒ肳Ă邱<br>
     *         
     * <br>
     * ϐ̏ꍇÂ܂ܐݒ肳邱ƂmFeXg
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDownloadFileStringFile05() throws Exception {
        // O
        File file = File.createTempFile("abc", "def");

        // eXg{
        DownloadFile downloadFile = new DownloadFile("abc", file);

        // 
        assertEquals("abc", downloadFile.name);
        assertEquals(file, downloadFile.file);
        assertEquals(AbstractDownloadObject.DEFAULT_CONTENT_TYPE, 
                downloadFile.contentType);
        assertEquals(AbstractDownloadObject.DEFAULT_CHARSET, 
                downloadFile.charset);
    }

    /**
     * testGetLengthOfData01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() file:File<br>
     *                (TCY10ł邱)<br>
     *         
     * <br>
     * ҒlF(߂l) int:10<br>
     *         
     * <br>
     * filẽTCYԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetLengthOfData01() throws Exception {
        // O
        // TCY10̃t@C쐬
        File file = File.createTempFile("abc", "def");
        FileOutputStream outputStream = new FileOutputStream(file);
        outputStream.write(new byte[10]);
        outputStream.close();
        
        DownloadFile downloadFile = new DownloadFile("abc", file);

        // eXg{
        int size = downloadFile.getLengthOfData();

        // 
        assertEquals(file.length(), size);
    }

    /**
     * testGetStreamInternal01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() file:File#createTempFile<br>
     *         
     * <br>
     * ҒlF(߂l) InputStream:FileInputStream<br>
     *         
     * <br>
     * filebvFileInputStreamԋp邱ƂmFeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetStreamInternal01() throws Exception {
        // O
        // TCY5̃t@C쐬
        File file = File.createTempFile("abc", "def");
        FileOutputStream outputStream = new FileOutputStream(file);
        outputStream.write(new byte[5]);
        outputStream.close();
        
        DownloadFile downloadFile = new DownloadFile("abc", file);

        // eXg{
        InputStream stream = downloadFile.getStreamInternal();

        // 
        // FileInputStreamԋpĂ邩mF
        assertNotNull(stream);
        assertEquals(FileInputStream.class, stream.getClass());
        // filebvĂ邩ǂmF
        assertFalse(stream.read() == -1);
        assertFalse(stream.read() == -1);
        assertFalse(stream.read() == -1);
        assertFalse(stream.read() == -1);
        assertFalse(stream.read() == -1);
        assertTrue(stream.read() == -1);
    }

}
