/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

import org.apache.struts.util.MessageResources;

/**
 * {@link jp.terasoluna.fw.web.struts.action.DBMessageResourcesFactory} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * DBMessageResources𐶐t@NgNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.DBMessageResourcesFactory
 */
public class DBMessageResourcesFactoryTest extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageResourcesFactoryTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBMessageResourcesFactoryTest(String name) {
        super(name);
    }

    /**
     * testCreateResources01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() config:"DBMessageResourcesFactory_MessageResources01"<br>
     *                ĩt@Cj<br>
     *         () system.properties̊֘AvpeB:messages.dao="aaaaa"<br>
     *                messages.sql=SELECT KEY, VALUE FROM MESSAGES<br>
     *         () DBMessageResourcesdbMessages:null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.resources.init"<br>
     *                    bvOFClassLoadException<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    ""aaaaa" cannot loaded."<br>
     *                    O<br>
     *                    ClassLoadException<br>
     *         
     * <br>
     * VXeݒvpeBt@Cisystem.propertiesjɁA݂Ȃdaomessages.daoƂL[Œ`ĂꍇAG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources01() throws Exception {
        // O
        DBMessageResourcesFactory factory 
            = new DBMessageResourcesFactory();
        addProperty("messages.dao", "aaaaa");
        addProperty("messages.sql", "SELECT KEY, VALUE FROM MESSAGES");
        UTUtil.setPrivateField(DBMessageResources.class, "dbMessages", null);
        
        // eXg{
        try {
            factory.createResources(
                    "DBMessageResourcesFactory_MessageResources01");
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.db.message.resources.init", e.getErrorCode());
            assertEquals(ClassLoadException.class.getName(),
                         e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("\"aaaaa\" cannot loaded.",
                                            e.getCause()));
            
        }
    }

    /**
     * testCreateResources02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() config:"DBMessageResourcesFactory_MessageResources01"<br>
     *                ĩt@Cj<br>
     *         () system.properties̊֘AvpeB:messages.daoL[ƂvpeB݂Ȃ<br>
     *                messages.sqlL[ƂvpeB݂Ȃ<br>
     *         () DBMessageResourcesdbMessages:null<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory: ߂l𐶐DBMessageResourcesFactoryCX^Xg<br>
     *                  config: "DBMessageResourcesFactory_MessageResources01"<br>
     *                  returnNull: super.returnNull<br>
     *         
     * <br>
     * DBMessageResourcesĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources02() throws Exception {
        // O
        DBMessageResourcesFactory factory 
            = new DBMessageResourcesFactory();
        deleteProperty("messages.dao");
        deleteProperty("messages.sql");
        UTUtil.setPrivateField(DBMessageResources.class, "dbMessages", null);
        
        // eXg{
        MessageResources resources 
            = factory.createResources(
                "DBMessageResourcesFactory_MessageResources01");
       
        // 
        assertEquals(DBMessageResources.class.getName(),
                     resources.getClass().getName());
        assertSame(factory,
                   UTUtil.getPrivateField(resources, "factory"));
        assertEquals("DBMessageResourcesFactory_MessageResources01",
                     UTUtil.getPrivateField(resources, "config"));
        assertEquals(UTUtil.getPrivateField(factory, "returnNull"),
                     UTUtil.getPrivateField(resources, "returnNull"));
    }

    /**
     * testCreateResources03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:""<br>
     *         () DBMessageResourcesdbMessages:null<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory: ߂l𐶐DBMessageResourcesFactoryCX^Xg<br>
     *                  config: ""<br>
     *                  returnNull: super.returnNull<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "" is illegal."<br>
     *         
     * <br>
     * bZ[W\[X`t@Cɋ󕶎w肵ꍇAG[Oo͂ADBMessageResources邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources03() throws Exception {
        // O
        DBMessageResourcesFactory factory 
            = new DBMessageResourcesFactory();
        deleteProperty("messages.dao");
        deleteProperty("messages.sql");
        UTUtil.setPrivateField(DBMessageResources.class, "dbMessages", null);
        
        // eXg{
        MessageResources resources 
            = factory.createResources(
                "");
       
        // 
        assertTrue(resources instanceof DBMessageResources);
        assertSame(factory,
                   UTUtil.getPrivateField(resources, "factory"));
        assertEquals("",
                     UTUtil.getPrivateField(resources, "config"));
        assertEquals(UTUtil.getPrivateField(factory, "returnNull"),
                     UTUtil.getPrivateField(resources, "returnNull"));
        assertTrue((LogUTUtil.checkError("Message resources file \"\" is illegal.")));
    }

    /**
     * testCreateResources04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() config:null<br>
     *         () DBMessageResourcesdbMessages:null<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageResources:factory: ߂l𐶐DBMessageResourcesFactoryCX^Xg<br>
     *                  config: null<br>
     *                  returnNull: super.returnNull<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "Message resources file "null" is illegal."<br>
     *         
     * <br>
     * bZ[W\[X`t@Cnullw肵ꍇAG[Oo͂ADBMessageResources邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateResources04() throws Exception {
        // O
        DBMessageResourcesFactory factory 
            = new DBMessageResourcesFactory();
        deleteProperty("messages.dao");
        deleteProperty("messages.sql");
        UTUtil.setPrivateField(DBMessageResources.class, "dbMessages", null);
        
        // eXg{
        MessageResources resources 
            = factory.createResources(
                null);
       
        // 
        assertTrue(resources instanceof DBMessageResources);
        assertSame(factory,
                   UTUtil.getPrivateField(resources, "factory"));
        assertNull(UTUtil.getPrivateField(resources, "config"));
        assertEquals(UTUtil.getPrivateField(factory, "returnNull"),
                     UTUtil.getPrivateField(resources, "returnNull"));
        assertTrue(LogUTUtil.checkError("Message resources file \"null\" is illegal."));
    }

}
