/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

import com.mockrunner.mock.jdbc.MockResultSet;

/**
 * {@link jp.terasoluna.fw.web.struts.action.DBMessageBeanMappingSqlQuery} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * DB擾sDBMessageBeanCX^XɋlߑւĕԂ\bh
 * MappingSqlQueryNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.DBMessageBeanMappingSqlQuery
 */
public class DBMessageBeanMappingSqlQueryTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageBeanMappingSqlQueryTest.class);
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBMessageBeanMappingSqlQueryTest(String name) {
        super(name);
    }

    /**
     * testMapRow01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() rs:|"test01"|"eXgbZ[WOP"|<br>
     *                ƂeResultSet<br>
     *         () rowNum:1<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageBean:key->"test01"<br>
     *                  value->"eXgbZ[WOP"<br>
     *         (ԕω) createDBMessageBean:ɑOrsݒ肵ČĂяo<br>
     *         
     * <br>
     * createDBMessageBean\bhĂяoĂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testMapRow01() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);
        
        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("test01");
        rs.addColumn(list1);

        List<String> list2 = new ArrayList<String>();
        list2.add("eXgbZ[WOP");
        rs.addColumn(list2);
        
        rs.first();
        
        // eXg{
        DBMessageBean actual = query.mapRow(rs, 1);

        // 
        assertEquals("test01", actual.getKey());
        assertEquals("eXgbZ[WOP", actual.getValue());
    }


    /**
     * testCreateDBMessageBean01()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() rs:J0ResultSet<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.bean.mapping.sql.query"<br>
     *                    bvOFnull<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "SQL for DB message returns 0 column(s) result set."<br>
     *         
     * <br>
     * ResultSet̃J0̏ꍇAG[Oo͂A
     * OX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateDBMessageBean01() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);
        
        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");        
        rs.first();

        // eXg{
        try {
            query.createDBMessageBean(rs);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.db.message.bean.mapping.sql.query",
                e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "SQL for DB message returns 0 column(s) result set."));
        }
    }

    /**
     * testCreateDBMessageBean02()
     * <br><br>
     * 
     *  (n) or (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() rs:|"test01"|<br>
     *                ƂeResultSet<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.bean.mapping.sql.query"<br>
     *                    bvOFnull<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "SQL for DB message returns 1 column(s) result set.."<br>
     *         
     * <br>
     * ResultSet̃J1̏ꍇAG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateDBMessageBean02() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("test01");
        rs.addColumn(list1);
        
        rs.first();

        // eXg{
        try {
            query.createDBMessageBean(rs);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.db.message.bean.mapping.sql.query",
                e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "SQL for DB message returns 1 column(s) result set."));
        }
    }

    /**
     * testCreateDBMessageBean03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() rs:|"test01"|"eXgbZ[WOP"|<br>
     *                ƂeResultSet<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageBean:key->"test01"<br>
     *                  value->"eXgbZ[WOP"<br>
     *         
     * <br>
     * J2̂ƂAkey, valueƂɐɐݒ肳ꂽDBMessageBeanԂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateDBMessageBean03() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);
        
        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("test01");
        rs.addColumn(list1);

        List<String> list2 = new ArrayList<String>();
        list2.add("eXgbZ[WOP");
        rs.addColumn(list2);
        
        rs.first();

        // eXg{
        DBMessageBean actual = query.createDBMessageBean(rs);
        
        // 
        assertEquals("test01", 
                     UTUtil.getPrivateField(actual, "key"));
        assertEquals("eXgbZ[WOP",
                     UTUtil.getPrivateField(actual, "value"));
    }

    /**
     * testCreateDBMessageBean04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() rs:|"test01"|"eXgbZ[WOP"|"ja"|<br>
     *                ƂeResultSet<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    G[R[hF"errors.db.message.bean.mapping.sql.query"<br>
     *                    bvOFnull<br>
     *         (ԕω) O:yG[Oz<br>
     *                    bZ[W<br>
     *                    "SQL for DB message returns 3 column(s) result set."<br>
     *         
     * <br>
     * ResultSet̃J3̏ꍇAG[Oo͂AOX[邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateDBMessageBean04() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("test01");
        rs.addColumn(list1);

        List<String> list2 = new ArrayList<String>();
        list2.add("eXgbZ[WOP");
        rs.addColumn(list2);
        
        List<String> list3 = new ArrayList<String>();
        list3.add("ja");
        rs.addColumn(list3);
        
        rs.first();

        // eXg{
        try {
            query.createDBMessageBean(rs);
            fail();
        } catch (SystemException e) {
            // 
            assertEquals("errors.db.message.bean.mapping.sql.query",
                e.getErrorCode());
            assertTrue(LogUTUtil.checkError(
                "SQL for DB message returns 3 column(s) result set."));
        }
    }

    /**
     * testCreateDBMessageBean05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() rs:|null|null|<br>
     *                ƂeResultSet<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageBean:key->""<br>
     *                  value->""<br>
     *         (ԕω) O:yxOz<br>
     *                    bZ[W<br>
     *                    "DBMessage resource keys contain null or empty."<br>
     *         
     * <br>
     * ResultSet̑JnullŁAJnull̏ꍇA
     * xOo͂Akey, valueƂɋ󕶎̐ݒ肳ꂽ
     * DBMessageBeanԂ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateDBMessageBean05() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        
        List<String> list1 = new ArrayList<String>();
        list1.add(null);
        rs.addColumn(list1);

        List<String> list2 = new ArrayList<String>();
        list2.add(null);
        rs.addColumn(list2);
        
        rs.first();

        // eXg{
        DBMessageBean actual = query.createDBMessageBean(rs);
        
        // 
        assertEquals("", 
            UTUtil.getPrivateField(actual, "key"));
        assertEquals("",
            UTUtil.getPrivateField(actual, "value"));
        assertTrue(LogUTUtil.checkWarn(
            "DBMessage resource keys contain null or empty."));
    }

    /**
     * testCreateDBMessageBean06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() rs:|""|""|<br>
     *                ƂeResultSet<br>
     *         
     * <br>
     * ҒlF(߂l) DBMessageBean:key->""<br>
     *                  value->""<br>
     *         (ԕω) O:yxOz<br>
     *                    bZ[W<br>
     *                    "DBMessage resource keys contain null or empty."<br>
     *         
     * <br>
     * ResultSet̑J󕶎ŁAJ󕶎̏ꍇA
     * xOo͂Akey, valueƂɋ󕶎̐ݒ肳ꂽDBMessageBean
     * Ԃ邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testCreateDBMessageBean06() throws Exception {
        // O
        DataSource ds = null;
        String sql = null;
        DBMessageBeanMappingSqlQuery query 
            = new DBMessageBeanMappingSqlQuery(ds, sql);

        // [ResultSet̐ݒ
        MockResultSet rs = new MockResultSet("testid");
        
        List<String> list1 = new ArrayList<String>();
        list1.add("");
        rs.addColumn(list1);

        List<String> list2 = new ArrayList<String>();
        list2.add("");
        rs.addColumn(list2);
        
        rs.first();

        // eXg{
        DBMessageBean actual = query.createDBMessageBean(rs);
        
        // 
        assertEquals("", 
            UTUtil.getPrivateField(actual, "key"));
        assertEquals("",
            UTUtil.getPrivateField(actual, "value"));
        assertTrue(LogUTUtil.checkWarn(
            "DBMessage resource keys contain null or empty."));
    }

}
