/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * _E[heێ钊ۃNXB
 */
public abstract class AbstractDownloadObject implements Serializable {

    /**
     * ftHg̃GR[fBO(<code>UTF-8</code>)
     */
    public static final String DEFAULT_CHARSET = "UTF-8";

    /**
     * ftHg̃Reg^Cv(<code>application/octetstream</code>)
     */
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";

    /**
     * _E[he݂Ȃꍇ̃G[R[hB
     */
    public static final String NO_DOWNLOAD_CONTENT_ERROR =
        "errors.no.download.content";

    /**
     * Reg^CvB
     */
    protected String contentType = null;

    /**
     * _E[hB
     */
    protected String name = null;

    /**
     * GR[fBOB
     */
    protected String charset = null;

    /**
     * ǉwb_ێ}bvB
     */
    protected Map<String, List<String>> additionalHeaders =
        new HashMap<String, List<String>>();

    /**
     * RXgN^B
     *
     * @param name _E[hB
     * @param contentType Reg^CvB
     * @param charset GR[fBOB
     */
    public AbstractDownloadObject(String name,
            String contentType, String charset) {
        this.name = name;
        setContentType(contentType);
        setCharset(charset);
    }

    /**
     * GR[fBO擾B
     *
     * @return GR[fBOB
     */
    public String getCharset() {
        return charset;
    }

    /**
     * GR[fBOݒ肷B
     *
     * @param charset GR[fBOB
     */
    public void setCharset(String charset) {
        this.charset = charset;
        if (this.charset == null) {
            this.charset = DEFAULT_CHARSET;
        }
    }

    /**
     * Reg^Cv擾B
     *
     * @return Reg^CvB
     */
    public String getContentType() {
        return contentType;
    }

    /**
     * Reg^Cvݒ肷B
     *
     * @param contentType Reg^CvB
     */
    public void setContentType(String contentType) {
        this.contentType = contentType;
        if (this.contentType == null) {
            setContentType(DEFAULT_CONTENT_TYPE);
        }
    }

    /**
     * _E[h擾B
     *
     * @return _E[hB
     */
    public String getName() {
        return name;
    }

    /**
     * _E[hݒ肷B
     *
     * @param name _E[hB
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * _E[hẽXg[擾B
     *
     * @return Xg[B
     */
    public InputStream getStream() throws IOException {
        InputStream stream = getStreamInternal();
        if (!(stream instanceof BufferedInputStream)) {
            stream = new BufferedInputStream(stream);
        }
        return stream;
    }

    /**
     * ǉ̃X|Xwb_ݒ肷B
     *
     * @param name wb_B
     * @param value wb_̒lB
     */
    public void addHeader(String name, String value) {
        List<String> headerValues = additionalHeaders.get(name);
        if (headerValues == null) {
            headerValues = new ArrayList<String>();
            additionalHeaders.put(name, headerValues);
        }
        headerValues.add(value);
    }

    /**
     * ǉ̃X|Xwb_擾B
     *
     * @return ǉ̃X|Xwb_B
     */
    public Map<String, List<String>> getAdditionalHeaders() {
        return additionalHeaders;
    }

    /**
     * _E[hẽXg[IɎ擾B
     *
     * @return Xg[B
     */
    protected abstract InputStream getStreamInternal() throws IOException;

    /**
     * _E[hTCY擾B
     *
     * @return _E[hTCYB
     */
    public abstract int getLengthOfData();
}
