/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;

import java.util.Enumeration;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

import jp.terasoluna.fw.util.HashUtil;
import jp.terasoluna.fw.util.StringUtil;

/**
 * RequestɊւ郆[eBeBNXB
 *
 */
public class RequestUtil {

    /**
     * {@link #getPathInfo}\bhϏAccessControlPathResolverB
     */
    private static AccessControlPathResolver accessControlPathResolver = new DefaultAccessControlPathResolver();

    /**
     * {@link #getPathInfo}\bhϏAccessControlPathResolverݒ肷B
     * ̃\bh́AAvP[VNDIReiĂяoƂOƂĂB
     * ̃\bhŐݒ肳ꂽAccessControlPathResolveŕAXbhԂŋL邽߁A
     * NGXgɂ̃\bhsĂ͂ȂȂB
     * @param accessControlPathResolver
     */
    public void setAccessControlPathResolver(AccessControlPathResolver accessControlPathResolver) {
        RequestUtil.accessControlPathResolver = accessControlPathResolver;
    }

    /**
     * AccessControlPathResolverɈϏA
     * <code>ServletRequest</code> NXCX^XA
     * ANZXp̃pX擾B
     * T[oURLfR[hÕpXKvȏꍇ́A
     * {@link #getPathInfoFromURI(ServletRequest)}gp邱ƁB
     * A{@link #getPathInfoFromURI(ServletRequest)}̖߂l̓ANZXɂ͕sł邽߁A
     * ANZXp̃pX擾ꍇ́A
     * {\bh({@link #getPathInfo(ServletRequest)})gp邱ƁB<br>
     * <br>
     * ϏAccessControlPathResolveŕAftHgł{@link DefaultAccessControlPathResolver}gp邪A
     * ȉ̂悤bean`邱ƂŁAʓrpӂAccessControlPathResolverNXɍւ邱ƂłB
     * <pre>
     * {@code
     * <bean class="jp.terasoluna.fw.web.RequestUtil">
     *   <property name="accessControlPathResolver" ref="accessControlPathResolver"/>
     * </bean>
     * <bean id="accessControlPathResolver" class="(ʓrpӂAccessControlPathResolverNXFQCN)"/>
     * }
     * </pre>
     * @param request
     * ANZXp̃pX̎ZoƂȂ <code>ServletRequest</code> NXCX^XB
     * @return ANZXp̃pXBrequestnullnꂽꍇnull(ϏAccessControlPathResolverŎ)B
     * @see AccessControlPathResolver
     * @see DefaultAccessControlPathResolver
     */
    public static String getPathInfo(ServletRequest request) {
        return accessControlPathResolver.resolveAccessControlPath(request);
    }

    /**
     * <code>ServletRequest</code> NXCX^XA
     * ReLXgpXȍ~URI<code>pathInfo</code> 擾B
     * ȂAłpathInfoƂ͒ʏ̊gpXƂ͈قȂ邱Ƃɒӂ邱ƁB
     * ܂Ã\bh̖߂ĺAANZXɂ͕sł邽߁A
     * ANZXp̃pX擾ꍇ́A
     * {@link #getPathInfo(ServletRequest)}gp邱ƁB
     *
     * @param request
     * <code>pathInfo</code> ̎ZoƂȂ <code>ServletRequest</code> NXCX^XB
     * @return
     * ReLXg܂܂ȂAXbVn܂pXBrequestnullnꂽꍇ
     * nullBReLXgȍ~̎w肪ꍇ󕶎B
     */
    public static String getPathInfoFromURI(ServletRequest request) {
        if (request == null) {
            return null;
        }
        // pathInfo̎擾
        return ((HttpServletRequest) request).getRequestURI().replaceFirst(
            ((HttpServletRequest) request).getContextPath(), "");
    }

    /**
     * T[ubgReLXg擾܂
     * @param request NGXg
     * @return T[ubgReLXgBrequestnullnꂽꍇ
     * nullB
     */
    public static ServletContext getServletContext(HttpServletRequest request) {
        if (request == null) {
            return null;
        }
        //ServletContext擾
        return request.getSession(true).getServletContext();
    }

    /**
     * ʋƖɈڂǂpX`FbNsA肷B
     *
     * @param request NGXg
     * @return ʋƖɈڂĂ<code>true</code>B
     * requestnullnꂽꍇtrueB
     */
    public static boolean isChanged(ServletRequest request) {

        if (request == null) {
            return true;
        }

        //pathInfo̎擾
        String pathInfo = getPathInfo(request);

        //pathInfo̎擾
        String prevPathInfo = (String) request.getAttribute("PREV_PATH_INFO");
        //pXnull̏ꍇ
        if (prevPathInfo == null
            || pathInfo == null
            || !toCompareStr(prevPathInfo).equals(toCompareStr(pathInfo))) {
            return true;
        }

        return false;
    }

    /**
     * w肳ꂽpX񂩂ƖReLXgpX擾B
     *
     * @param str pX
     * @return ƖReLXgpX
     */
    private static String toCompareStr(String str) {
        try {
            int beginIndex = str.indexOf('/') + 1;
            int endIndex = str.indexOf('/', beginIndex);
            return str.substring(beginIndex, endIndex);
        } catch (IndexOutOfBoundsException e) {
            return str;
        }
    }

    /**
     * HTTPZbVID̃nbVl擾B
     *
     * @param req HTTPNGXg
     * @return nbVlBrequestnullnꂽꍇ
     * nullB
     */
    public static String getSessionHash(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        byte[] hash = HashUtil.hashSHA1(req.getSession(true).getId());
        return StringUtil.toHexString(hash, "");
    }

    /**
     * NGXgp[^ƃNGXg_vB
     *
     * @param req HTTPNGXg
     * @return _v
     */
    public static String dumpRequest(HttpServletRequest req) {
        return dumpRequestParameters(req) + " , " + dumpRequestAttributes(req);
    }

    /**
     * NGXg_vB
     *
     * @param req HTTPNGXg
     * @return _vBrequestnullnꂽꍇ
     * nullB
     */
    public static String dumpRequestAttributes(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" RequestAttributes {");
        Enumeration enumeration = req.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String key = (String) enumeration.nextElement();
            Object value = req.getAttribute(key);
            builder.append(key);
            builder.append(" = ");
            builder.append(value);
            if (enumeration.hasMoreElements()) {
                builder.append(" , ");
            }
        }
        builder.append("}");
        return builder.toString();
    }


    /**
     * NGXgp[^_vB
     *
     * @param req HTTPNGXg
     * @return _vBrequestnullnꂽꍇ
     * nullB
     */
    public static String dumpRequestParameters(HttpServletRequest req) {
        if (req == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(" RequestParameters {");
        Enumeration enumeration = req.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String) enumeration.nextElement();
            String[] values = req.getParameterValues(key);
            for (int i = 0; i < values.length; i++) {
                    builder.append(key);
                    builder.append("[");
                    builder.append(i);
                    builder.append("] = ");
                    builder.append(values[i]);
                    if (i < values.length - 1) {
                        builder.append(" , ");
                    }
            }
            if (enumeration.hasMoreElements()) {
                builder.append(" , ");
            }
        }
        builder.append("}");
        return builder.toString();
    }

    /**
     * urlɈkeỹp[^tĂꍇ͍폜ĕԋpB
     * F폜OFtest.do?no=2&r=8331352040140757427&no=1
     * @@폜Ftest.do?no=2&no=1
     * 
     * @param url 폜sURL
     * @param key 폜Ώۂ̃L[ƂȂ镶
     * @return 폜URL
     */
    public static String deleteUrlParam(String url, String key) {

        //url,keyNULL܂͋󔒂̏ꍇurl̂܂ܕԋpB
        if (url == null || "".equals(url) || key == null || "".equals(key)) {
            return url;
        }

        //HŎn܂CfbNX擾B
        int start = url.indexOf("?");

        //ԋppStringBuilderB
        StringBuilder returnUrl = new StringBuilder(url);

        //p[^݂ꍇ́AsB
        if (start >= 0) {

            //p[^ȍ~̕擾
            String tmp = url.substring(start + 1);

            //p[^ȊO̕ԋppStringBuilderɊi[B
            returnUrl = new  StringBuilder(url.substring(0, start));

            //p[^zɕϊ
            String[] params = tmp.split("&");

            //p[^𔻒肵āA
            //w肳ꂽL[̃p[^ȊOԋppStringBuilderɊi[B
            for (int i = 0; i < params.length; i++) {
                String param = params[i];

                //_ID̊mF
                if (!param.startsWith(key + "=")) {

                    //ŏɕtꍇ́HtB
                    //p[^̏ꍇ&tB
                    if (returnUrl.indexOf("?") < 0
                            && !returnUrl.toString().endsWith("?")) {
                        returnUrl.append("?");
                    } else if (!returnUrl.toString().endsWith("&")) {
                        returnUrl.append("&");
                    }

                    //ԋppStringBuilderɊi[B
                    returnUrl.append(param);
                }
            }
        }

        //폜URLԋpB
        return returnUrl.toString();
    }

}
