/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import jp.terasoluna.fw.web.struts.plugins.ResetterPlugInEx;
import jp.terasoluna.fw.web.struts.reset.Resetter;
import jp.terasoluna.utlib.MockServletContext;
import jp.terasoluna.utlib.UTUtil;

import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.easymock.classextension.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ResetterPlugInExTest2 {
    private ResetterPlugInEx testedPlugin;

    private ActionServlet servlet;

    private ModuleConfig config;

    @Before
    public void setUp() throws Exception {
        testedPlugin = new ResetterPlugInEx();
        // W[RtBO
        config = new ModuleConfigImpl();
    }

    @After
    public void tearDown() throws Exception {
        testedPlugin = null;
        servlet = null;
        config = null;
    }

    /**
     * initResetter
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_FresetterݒȂ
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testInitResetter1() throws ServletException {
        ServletContext context = new MockServletContext();
        servlet = org.easymock.classextension.EasyMock.createMockBuilder(
                ActionServlet.class).withConstructor().addMockedMethod(
                "getServletContext").createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context)
                .times(2);
        EasyMock.replay(servlet);

        // eXg
        testedPlugin.initResetter(servlet, config);

        assertTrue(servlet.getServletContext().getAttribute(
                "RESETTER" + config.getPrefix()) instanceof jp.terasoluna.fw.web.struts.reset.Resetter);
        EasyMock.verify(servlet);
    }

    /**
     * initResetter
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_Fresetterݒ肠
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testInitResetter2() throws ServletException {
        ServletContext context = new MockServletContext();
        servlet = org.easymock.classextension.EasyMock.createMockBuilder(
                ActionServlet.class).withConstructor().addMockedMethod(
                "getServletContext").createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context)
                .times(2);
        EasyMock.replay(servlet);
        testedPlugin.setResetter(ResetterImplMock.class.getName());

        // eXg
        testedPlugin.initResetter(servlet, config);

        assertTrue(servlet.getServletContext().getAttribute(
                "RESETTER" + config.getPrefix()) instanceof Resetter);
        EasyMock.verify(servlet);
    }

    /**
     * initResetter
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test()
    public void testInitResetter3() throws ServletException {
        ServletContext context = new MockServletContext();
        servlet = org.easymock.classextension.EasyMock.createMockBuilder(
                ActionServlet.class).withConstructor().addMockedMethod(
                "getServletContext").createMock();
        EasyMock.expect(servlet.getServletContext()).andReturn(context)
                .times(2);
        EasyMock.replay(servlet);
        testedPlugin.setResetter(ResetterImplMock.class.getName());

        // eXg
        testedPlugin.initResetter(servlet, config);

        System.out.println(servlet.getServletContext().getAttribute(
                "RESETTER" + config.getPrefix()));
        EasyMock.verify(servlet);
    }

    /**
     * initResources
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testInitResources() throws ServletException {
        // TODO not yet!
    }

    /**
     * setPublicIdentifier
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testGetPublicIdentifier() {
        String expected = "ecpexted_publicIdentifier";

        // eXg
        testedPlugin.setPublicIdentifier(expected);

        assertEquals(expected, testedPlugin.getPublicIdentifier());

    }

    /**
     * setPublicIdentifier
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testSetPublicIdentifier() {
        String expected = "ecpexted_publicIdentifier";

        // eXg
        testedPlugin.setPublicIdentifier(expected);

        assertEquals(expected, testedPlugin.getPublicIdentifier());
    }

    /**
     * getDtdUrl
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testGetDtdUrl() {
        String expected = "DtdUrl";

        testedPlugin.setDtdUrl(expected);

        // eXg
        assertEquals(expected, testedPlugin.getDtdUrl());
    }

    /**
     * setDtdUrl
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testSetDtdUrl() {
        String expected = "DtdUrl";

        // eXg
        testedPlugin.setDtdUrl(expected);

        assertEquals(expected, testedPlugin.getDtdUrl());
    }

    /**
     * setResetter
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testSetResetter() throws Throwable {
        String expected = "jp.terasoluna.fw.web.struts.reset.ResetterImpl";

        // eXg
        testedPlugin.setResetter(expected);

        Object actual = UTUtil.getPrivateField(testedPlugin, "resetter");
        assertEquals(expected, actual);
    }

    /**
     * setResources
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testSetResources() throws Throwable {
        String expected = "";

        // eXg
        testedPlugin.setResources(expected);

        Object actual = UTUtil.getPrivateField(testedPlugin, "resourcesPath");
        assertEquals(expected, actual);
    }

    /**
     * setDigesterRules
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * </p>
     * <p>
     * ҒlF<br>
     * </p>
     * @throws ServletException
     */
    @Test
    public void testSetDigesterRules() throws Throwable {
        String expected = "";

        // eXg
        testedPlugin.setDigesterRules(expected);

        Object actual = UTUtil.getPrivateField(testedPlugin, "digesterRules");
        assertEquals(expected, actual);
    }
}
