/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ResolverActionMappingTest {

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testIsSaveToken001() {
        ResolverActionMapping ram = new ResolverActionMapping();

        ram.setSaveToken(true);

        assertTrue(ram.isSaveToken());
    }

    @Test
    public void testIsSaveToken002() {
        ResolverActionMapping ram = new ResolverActionMapping();

        ram.setSaveToken(false);

        assertFalse(ram.isSaveToken());
    }

    @Test
    public void testIsTokenCheck001() {
        ResolverActionMapping ram = new ResolverActionMapping();

        ram.setTokenCheck(true);

        assertTrue(ram.isTokenCheck());
    }

    @Test
    public void testIsTokenCheck002() {
        ResolverActionMapping ram = new ResolverActionMapping();

        ram.setTokenCheck(false);

        assertFalse(ram.isTokenCheck());
    }

    @Test
    public void testGetSaveMessageScope001() {
        ResolverActionMapping ram = new ResolverActionMapping();

        String saveMessageScope = null;

        ram.setSaveMessageScope(saveMessageScope);

        assertNull(ram.getSaveMessageScope());
    }

    @Test
    public void testGetSaveMessageScope002() {
        ResolverActionMapping ram = new ResolverActionMapping();

        String saveMessageScope = "hoge";

        ram.setSaveMessageScope(saveMessageScope);

        assertNotNull(ram.getSaveMessageScope());
        assertEquals(saveMessageScope, ram.getSaveMessageScope());
    }

    @Test
    public void testGetEvent001() {
        ResolverActionMapping ram = new ResolverActionMapping();

        String event = null;

        ram.setEvent(event);

        assertNull(ram.getEvent());
    }

    @Test
    public void testGetEvent002() {
        ResolverActionMapping ram = new ResolverActionMapping();

        String event = "hoge";

        ram.setEvent(event);

        assertNotNull(ram.getEvent());
        assertEquals(event, ram.getEvent());
    }

}
