/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import static org.junit.Assert.*;
import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;
import jp.terasoluna.utlib.UTUtil;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.web.context.WebApplicationContext;

public class AbstractActionResolverTest {

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * supports\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : null</li>
     * <li>pathPattern : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : false</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSupports001() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        String actionName = null;
        String pathPattern = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        boolean result = resolver.supports(beanName, mapping, servlet, wac);

        // 
        assertFalse(result);
    }

    /**
     * supports\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>actionName : "hoge"</li>
     * <li>pathPattern : "/.*SCR"</li>
     * <li>beanName : "/hogehogeSCR"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : false</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSupports002() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        String actionName = "hoge";
        String pathPattern = "/.*SCR";
        String beanName = "/hogehogeSCR";
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // p[^ݒ
        resolver.setActionName(actionName);
        resolver.setPathPattern(pathPattern);

        // eXg
        boolean result = resolver.supports(beanName, mapping, servlet, wac);

        // 
        assertTrue(result);
    }

    /**
     * callConfigurationReflector\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>key : null</li>
     * <li>action : null</li>
     * <li>beanName : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>expected : IllegalArgumentException.class</li>
     * </p>
     * @throws Exception
     */
    @Test(expected = IllegalArgumentException.class)
    public void testCallConfigurationReflector001() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        Object key = null;
        Action action = null;
        String beanName = null;
        ActionMapping mapping = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // eXg
        resolver.callConfigurationReflector(key, action, beanName, mapping,
                servlet, wac);
        fail();
    }

    /**
     * callConfigurationReflector\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>key : null</li>
     * <li>action : new ForwardAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping()</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ConfigurationReflector.class) : new
     * GeneralConfigurationReflector() )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>ForwardActionsaveTokentB[htrueł邱</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testCallConfigurationReflector002() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        Object key = null;
        ForwardAction action = new ForwardAction();
        String beanName = null;
        ActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        GeneralConfigurationReflector configRef = new GeneralConfigurationReflector();
        wac.addBeansOfTypeMap("hoge", configRef);

        // eXg
        resolver.callConfigurationReflector(key, action, beanName, mapping,
                servlet, wac);

        // 
        Object saveToken = UTUtil.getPrivateField(action, "saveToken");
        assertNotNull(saveToken);
        assertEquals(Boolean.class, saveToken.getClass());
        assertTrue(((Boolean) saveToken).booleanValue());
    }

    /**
     * callConfigurationReflector\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>key : null</li>
     * <li>action : new ForwardAction()</li>
     * <li>beanName : null</li>
     * <li>mapping : new ResolverActionMapping(saveToken : false)</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ConfigurationReflector.class) : new
     * GeneralConfigurationReflector() )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>ForwardActionsaveTokentB[hfalseł邱</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testCallConfigurationReflector003() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        Object key = null;
        ForwardAction action = new ForwardAction();
        String beanName = null;
        ResolverActionMapping mapping = new ResolverActionMapping();
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        GeneralConfigurationReflector configRef = new GeneralConfigurationReflector();
        wac.addBeansOfTypeMap("hoge", configRef);
        mapping.setSaveToken(false);

        // eXg
        resolver.callConfigurationReflector(key, action, beanName, mapping,
                servlet, wac);

        // 
        Object saveToken = UTUtil.getPrivateField(action, "saveToken");
        assertNotNull(saveToken);
        assertEquals(Boolean.class, saveToken.getClass());
        assertFalse(((Boolean) saveToken).booleanValue());
    }

    /**
     * setPathPatterns\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>pathPattern : { "hoge" }</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>pathPatternstB[hl : pathPatterns</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetPathPatterns() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        String[] pathPattern = { "hoge" };

        // eXg
        resolver.setPathPatterns(pathPattern);

        // 
        Object pathPatterns = UTUtil.getPrivateField(resolver, "pathPatterns");
        assertNotNull(pathPatterns);
        assertEquals(pathPattern, pathPatterns);
    }

    /**
     * setOrder\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>order : 5</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>getOrder : order</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testSetOrder() throws Exception {
        AbstractActionResolver resolver = new GeneralActionResolver();

        // p[^
        int order = 5;

        // eXg
        resolver.setOrder(order);

        // 
        int resultOrder = resolver.getOrder();
        assertNotNull(resultOrder);
        assertEquals(order, resultOrder);
    }

}
