/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.core.OrderComparator;
import org.springframework.web.context.WebApplicationContext;

/**
 * DefaultProcessActionFormHandler
 * <p>
 * processActionFormgۂɗpB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 */
public class DefaultProcessActionFormHandler implements
                                            ProcessActionFormHandler {

    /** ProcessActionFormXg */
    protected List<ProcessActionForm> processActionFormList = null;

    /*
     * (non-Javadoc)
     * @see
     * jp.terasoluna.fw.web.struts.action.handler.ProcessActionFormHandler#processActionForm(javax.servlet.http.HttpServletRequest
     * , javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping, org.apache.struts.config.ModuleConfig,
     * org.apache.struts.action.ActionServlet, org.springframework.web.context.WebApplicationContext)
     */
    @SuppressWarnings("unchecked")
    public ActionForm processActionForm(HttpServletRequest req,
            HttpServletResponse res, ActionMapping mapping,
            ModuleConfig moduleConfig, ActionServlet servlet,
            WebApplicationContext wac) {

        ActionForm actionForm = null;

        if (this.processActionFormList == null && wac != null) {
            // ReiProcessActionFormQꊇ擾
            Map<?, ?> processActionFormMap = BeanFactoryUtils
                    .beansOfTypeIncludingAncestors(wac, ProcessActionForm.class);

            if (!processActionFormMap.isEmpty()) {
                this.processActionFormList = new ArrayList<ProcessActionForm>(
                        (Collection<? extends ProcessActionForm>) processActionFormMap
                                .values());
                Collections.sort(this.processActionFormList,
                        new OrderComparator());
            }

        }

        // ProcessActionFormQ𓪂Ȃ߂
        if (this.processActionFormList != null) {
            for (ProcessActionForm processActionForm : this.processActionFormList) {
                if (processActionForm.supports(req, res, mapping, servlet, wac)) {
                    // ProcessActionForm processActionForm() \bhs
                    actionForm = processActionForm.processActionForm(req, res,
                            mapping, servlet, wac);
                    if (actionForm != null) {
                        break;
                    }
                }
            }
        }

        return actionForm;
    }

}
