/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import static org.junit.Assert.*;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.util.PropertyAccessException;
import jp.terasoluna.utlib.UTUtil;

import org.junit.Test;

public class BLogicMapperExTest {

    /**
     * BLogicMapperExRXgN^
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * FȂ<br>
     * </p>
     * <p>
     * ҒlF<br>
     * OȂ<br>
     * </p>
     */
    @Test
    public final void testBLogicMapperEx() {
        try {
            new BLogicMapperEx();
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * BLogicMapperExRXgN^
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * F"aaa"<br>
     * </p>
     * <p>
     * ҒlF<br>
     * OȂ<br>
     * </p>
     */
    @Test
    public final void testBLogicMapperExString() {
        String resources = "aaa";
        try {
            new BLogicMapperEx(resources);
        } catch (Exception e) {
            fail();
        }
    }

    /**
     * getValueFromRequest\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1F"propName"<br>
     * 2FhttpServletRequestMock : getAttributenew Object()ԋp<br>
     * 3Fnull<br>
     * </p>
     * <p>
     * ҒlF<br>
     * return : new Object()<br>
     * </p>
     */
    @Test
    public final void testGetValueFromRequestAttribute() {
        final Object expected = new Object();
        HttpServletRequest httpServletRequestMock = new HttpServletRequestAdapter() {
            @Override
            public Object getAttribute(String name) {
                return expected;
            }
        };
        BLogicMapper bLogicMapper = new BLogicMapperEx();

        // eXg
        Object actual = bLogicMapper.getValueFromRequest("propName",
                httpServletRequestMock, null);

        // 
        assertEquals(expected, actual);
    }

    /**
     * getValueFromRequest\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1F"propName"<br>
     * 2FhttpServletRequestMock : ftHg<br>
     * 3Fnull<br>
     * </p>
     * <p>
     * ҒlF<br>
     * return : null<br>
     * </p>
     */
    @Test
    public final void testGetValueFromRequestNullParameterValues() {
        HttpServletRequest httpServletRequestMock = new HttpServletRequestAdapter();
        BLogicMapper bLogicMapper = new BLogicMapperEx();

        // eXg
        Object actual = bLogicMapper.getValueFromRequest("propName",
                httpServletRequestMock, null);

        // 
        assertNull(actual);
    }

    /**
     * getValueFromRequest\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1F"propName"<br>
     * 2FhttpServletRequestMock : getParameterValues new String[] { "aaa" } ԋp<br>
     * 3Fnull<br>
     * </p>
     * <p>
     * ҒlF<br>
     * return : "aaa"<br>
     * </p>
     */
    @Test
    public final void testGetValueFromRequestParameterValue() {
        final String[] parameterValues = new String[] { "aaa" };
        HttpServletRequest httpServletRequestMock = new HttpServletRequestAdapter() {
            @Override
            public String[] getParameterValues(String arg0) {
                return parameterValues;
            }
        };
        BLogicMapper bLogicMapper = new BLogicMapperEx();

        // eXg
        Object actual = bLogicMapper.getValueFromRequest("propName",
                httpServletRequestMock, null);

        // 
        assertEquals("aaa", actual);
    }

    /**
     * getValueFromRequest\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1F"propName"<br>
     * 2FhttpServletRequestMock : getParameterValues new String[] { "aaa", "bbb" } ԋp<br>
     * 3Fnull<br>
     * </p>
     * <p>
     * ҒlF<br>
     * return : new String[] { "aaa", "bbb" }<br>
     * </p>
     */
    @Test
    public final void testGetValueFromRequestParameterValues() {
        final String[] parameterValues = new String[] { "aaa", "bbb" };
        HttpServletRequest httpServletRequestMock = new HttpServletRequestAdapter() {
            @Override
            public String[] getParameterValues(String arg0) {
                return parameterValues;
            }
        };
        BLogicMapper bLogicMapper = new BLogicMapperEx();

        // eXg
        Object actual = bLogicMapper.getValueFromRequest("propName",
                httpServletRequestMock, null);

        // 
        assertEquals(parameterValues, actual);
    }

    /**
     * setValueToForm\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1Fnew Object()<br>
     * 2F"propName"<br>
     * 3Fnull<br>
     * 4Fnull<br>
     * </p>
     * <p>
     * ҒlF<br>
     * NullPointerException邱<br>
     * </p>
     * @throws PropertyAccessException
     */
    @Test(expected = NullPointerException.class)
    public final void testSetValueToForm() throws PropertyAccessException {
        BLogicMapper bLogicMapper = new BLogicMapperEx();
        Object value = new Object();

        // eXg
        bLogicMapper.setValueToForm(value, "propName", null, null);
    }

    /**
     * setValueToForm\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1Fnull<br>
     * 2F"propName"<br>
     * 3Fnull<br>
     * 4Fnull<br>
     * nullIsNotSet : "true"<br>
     * </p>
     * <p>
     * ҒlF<br>
     * OȂ<br>
     * </p>
     * @throws PropertyAccessException
     */
    @Test
    public final void testSetValueToFormWithNullValue()
                                                       throws PropertyAccessException {
        BLogicMapper bLogicMapper = new BLogicMapperEx();
        try {
            UTUtil.setPrivateField(bLogicMapper, "nullIsNotSet", true);
        } catch (NoSuchFieldException e) {
            fail();
        }

        // eXg
        bLogicMapper.setValueToForm(null, "propName", null, null);
    }

    /**
     * setValueToRequest\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1Fnew Object()<br>
     * 2F"propName"<br>
     * 3Fnull<br>
     * 4Fnull<br>
     * </p>
     * <p>
     * ҒlF<br>
     * OȂ<br>
     * </p>
     * @throws PropertyAccessException
     */
    @Test(expected = NullPointerException.class)
    public final void testSetValueToRequest() throws PropertyAccessException {
        BLogicMapper bLogicMapper = new BLogicMapperEx();
        Object value = new Object();

        // eXg
        bLogicMapper.setValueToRequest(value, "propName", null, null);
    }

    /**
     * setValueToRequest\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * 1Fnull<br>
     * 2F"propName"<br>
     * 3Fnull<br>
     * 4Fnull<br>
     * nullIsNotSet : "true"<br>
     * </p>
     * <p>
     * ҒlF<br>
     * OȂ<br>
     * </p>
     * @throws PropertyAccessException
     */
    @Test
    public final void testSetValueToRequestWithNullValue()
                                                          throws PropertyAccessException {
        BLogicMapper bLogicMapper = new BLogicMapperEx();
        try {
            UTUtil.setPrivateField(bLogicMapper, "nullIsNotSet", true);
        } catch (NoSuchFieldException e) {
            fail();
        }

        // eXg
        bLogicMapper.setValueToRequest(null, "propName", null, null);
    }

    private static class HttpServletRequestAdapter implements
                                                  HttpServletRequest {

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getAuthType()
         */
        public String getAuthType() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getContextPath()
         */
        public String getContextPath() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getCookies()
         */
        public Cookie[] getCookies() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getDateHeader(java.lang.String)
         */
        public long getDateHeader(String arg0) {

            return 0;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getHeader(java.lang.String)
         */
        public String getHeader(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getHeaderNames()
         */
        @SuppressWarnings("unchecked")
        public Enumeration getHeaderNames() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getHeaders(java.lang.String)
         */
        @SuppressWarnings("unchecked")
        public Enumeration getHeaders(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getIntHeader(java.lang.String)
         */
        public int getIntHeader(String arg0) {

            return 0;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getMethod()
         */
        public String getMethod() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getPathInfo()
         */
        public String getPathInfo() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getPathTranslated()
         */
        public String getPathTranslated() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getQueryString()
         */
        public String getQueryString() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getRemoteUser()
         */
        public String getRemoteUser() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getRequestedSessionId()
         */
        public String getRequestedSessionId() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getRequestURI()
         */
        public String getRequestURI() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getRequestURL()
         */
        public StringBuffer getRequestURL() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getServletPath()
         */
        public String getServletPath() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getSession()
         */
        public HttpSession getSession() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getSession(boolean)
         */
        public HttpSession getSession(boolean arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#getUserPrincipal()
         */
        public Principal getUserPrincipal() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdFromCookie ()
         */
        public boolean isRequestedSessionIdFromCookie() {

            return false;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdFromUrl()
         */
        public boolean isRequestedSessionIdFromUrl() {

            return false;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdFromURL()
         */
        public boolean isRequestedSessionIdFromURL() {

            return false;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#isRequestedSessionIdValid()
         */
        public boolean isRequestedSessionIdValid() {

            return false;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.http.HttpServletRequest#isUserInRole(java.lang.String)
         */
        public boolean isUserInRole(String arg0) {

            return false;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getAttribute(java.lang.String)
         */
        public Object getAttribute(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getAttributeNames()
         */
        @SuppressWarnings("unchecked")
        public Enumeration getAttributeNames() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getCharacterEncoding()
         */
        public String getCharacterEncoding() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getContentLength()
         */
        public int getContentLength() {

            return 0;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getContentType()
         */
        public String getContentType() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getInputStream()
         */
        public ServletInputStream getInputStream() throws IOException {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getLocalAddr()
         */
        public String getLocalAddr() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getLocale()
         */
        public Locale getLocale() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getLocales()
         */
        @SuppressWarnings("unchecked")
        public Enumeration getLocales() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getLocalName()
         */
        public String getLocalName() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getLocalPort()
         */
        public int getLocalPort() {

            return 0;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getParameter(java.lang.String)
         */
        public String getParameter(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getParameterMap()
         */
        @SuppressWarnings("unchecked")
        public Map getParameterMap() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getParameterNames()
         */
        @SuppressWarnings("unchecked")
        public Enumeration getParameterNames() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getParameterValues(java.lang.String)
         */
        public String[] getParameterValues(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getProtocol()
         */
        public String getProtocol() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getReader()
         */
        public BufferedReader getReader() throws IOException {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getRealPath(java.lang.String)
         */
        public String getRealPath(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getRemoteAddr()
         */
        public String getRemoteAddr() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getRemoteHost()
         */
        public String getRemoteHost() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getRemotePort()
         */
        public int getRemotePort() {

            return 0;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getRequestDispatcher(java.lang.String)
         */
        public RequestDispatcher getRequestDispatcher(String arg0) {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getScheme()
         */
        public String getScheme() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getServerName()
         */
        public String getServerName() {

            return null;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#getServerPort()
         */
        public int getServerPort() {

            return 0;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#isSecure()
         */
        public boolean isSecure() {

            return false;
        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#removeAttribute(java.lang.String)
         */
        public void removeAttribute(String arg0) {

        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#setAttribute(java.lang.String, java.lang.Object)
         */
        public void setAttribute(String arg0, Object arg1) {

        }

        /*
         * (non-Javadoc)
         * @see javax.servlet.ServletRequest#setCharacterEncoding(java.lang.String)
         */
        public void setCharacterEncoding(String arg0)
                                                     throws UnsupportedEncodingException {

        }
    }
}
