/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.thin;

import static org.junit.Assert.*;

import java.lang.reflect.Constructor;

import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicIOUtil;
import jp.terasoluna.fw.service.thin.BLogicProperty;

import org.junit.Test;

public class BLogicIOUtilTest {

    /**
     * createBLogicIOForBLogicParams\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : null
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().isEmpty() : true<br>
     * getBLogicResults().isEmpty() : true<br>
     * getInputBeanName() : null<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicParamsWithNullInputBeanClass() {
        BLogicIO bLogicIO = BLogicIOUtil.createBLogicIOForBLogicParams(null);
        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertTrue(bLogicIO.getBLogicResults().isEmpty());
        assertNull(bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * createBLogicIOForBLogicParams\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : ChildBean.class
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().size() : 12<br>
     * getBLogicResults().isEmpty() : true<br>
     * getInputBeanName() : jp.terasoluna.fw.service.thin.ChildBean<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicParamsWithInputBeanClass001() {
        BLogicIO bLogicIO = BLogicIOUtil
                .createBLogicIOForBLogicParams(ChildBean.class);

        assertEquals(12, bLogicIO.getBLogicParams().size());

        BLogicProperty parentField = bLogicIO.getBLogicParams().get(0);
        assertEquals("form", parentField.getSource());
        assertEquals("form", parentField.getDest());
        assertEquals("parentField", parentField.getBLogicProperty());
        assertEquals("parentField", parentField.getProperty());

        BLogicProperty parentFieldOverridenWithChildField = bLogicIO
                .getBLogicParams().get(1);
        assertEquals("request", parentFieldOverridenWithChildField.getSource());
        assertEquals("request", parentFieldOverridenWithChildField.getDest());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getBLogicProperty());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getProperty());

        BLogicProperty bLogicIOField = bLogicIO.getBLogicParams().get(2);
        assertEquals("form", bLogicIOField.getSource());
        assertEquals("form", bLogicIOField.getDest());
        assertEquals("bLogicIOField", bLogicIOField.getBLogicProperty());
        assertEquals("bLogicIOField", bLogicIOField.getProperty());

        BLogicProperty bLogicIOFormField = bLogicIO.getBLogicParams().get(3);
        assertEquals("form", bLogicIOFormField.getSource());
        assertEquals("form", bLogicIOFormField.getDest());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getBLogicProperty());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getProperty());

        BLogicProperty bLogicIORequestField = bLogicIO.getBLogicParams().get(4);
        assertEquals("request", bLogicIORequestField.getSource());
        assertEquals("request", bLogicIORequestField.getDest());
        assertEquals("bLogicIORequestField", bLogicIORequestField
                .getBLogicProperty());
        assertEquals("bLogicIORequestField", bLogicIORequestField.getProperty());

        BLogicProperty bLogicIOSessionField = bLogicIO.getBLogicParams().get(5);
        assertEquals("session", bLogicIOSessionField.getSource());
        assertEquals("session", bLogicIOSessionField.getDest());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField
                .getBLogicProperty());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField.getProperty());

        BLogicProperty bLogicIOApplicationField = bLogicIO.getBLogicParams()
                .get(6);
        assertEquals("application", bLogicIOApplicationField.getSource());
        assertEquals("application", bLogicIOApplicationField.getDest());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getBLogicProperty());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getProperty());

        BLogicProperty bLogicIOFieldWithProperty = bLogicIO.getBLogicParams()
                .get(7);
        assertEquals("form", bLogicIOFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFieldWithProperty.getDest());
        assertEquals("bLogicIOFieldWithProperty", bLogicIOFieldWithProperty
                .getBLogicProperty());
        assertEquals("property", bLogicIOFieldWithProperty.getProperty());

        BLogicProperty bLogicIOFormFieldWithProperty = bLogicIO
                .getBLogicParams().get(8);
        assertEquals("form", bLogicIOFormFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFormFieldWithProperty.getDest());
        assertEquals("bLogicIOFormFieldWithProperty",
                bLogicIOFormFieldWithProperty.getBLogicProperty());
        assertEquals("formProperty", bLogicIOFormFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIORequestFieldWithProperty = bLogicIO
                .getBLogicParams().get(9);
        assertEquals("request", bLogicIORequestFieldWithProperty.getSource());
        assertEquals("request", bLogicIORequestFieldWithProperty.getDest());
        assertEquals("bLogicIORequestFieldWithProperty",
                bLogicIORequestFieldWithProperty.getBLogicProperty());
        assertEquals("requestAttributeName", bLogicIORequestFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOSessionFieldWithProperty = bLogicIO
                .getBLogicParams().get(10);
        assertEquals("session", bLogicIOSessionFieldWithProperty.getSource());
        assertEquals("session", bLogicIOSessionFieldWithProperty.getDest());
        assertEquals("bLogicIOSessionFieldWithProperty",
                bLogicIOSessionFieldWithProperty.getBLogicProperty());
        assertEquals("sessionAttributeName", bLogicIOSessionFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOApplicationFieldWithProperty = bLogicIO
                .getBLogicParams().get(11);
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getSource());
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getDest());
        assertEquals("bLogicIOApplicationFieldWithProperty",
                bLogicIOApplicationFieldWithProperty.getBLogicProperty());
        assertEquals("applicationAttributeName",
                bLogicIOApplicationFieldWithProperty.getProperty());

        assertTrue(bLogicIO.getBLogicResults().isEmpty());
        assertEquals("jp.terasoluna.fw.service.thin.ChildBean", bLogicIO
                .getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * createBLogicIOForBLogicParams\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : ChildParamBean.class
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().size() : 12<br>
     * getBLogicResults().isEmpty() : true<br>
     * getInputBeanName() : jp.terasoluna.fw.service.thin.ChildParamBean<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicParamsWithInputBeanClass002() {
        BLogicIO bLogicIO = BLogicIOUtil
                .createBLogicIOForBLogicParams(ChildParamBean.class);

        assertEquals(12, bLogicIO.getBLogicParams().size());

        BLogicProperty parentField = bLogicIO.getBLogicParams().get(0);
        assertEquals("form", parentField.getSource());
        assertEquals("form", parentField.getDest());
        assertEquals("parentField", parentField.getBLogicProperty());
        assertEquals("parentField", parentField.getProperty());

        BLogicProperty parentFieldOverridenWithChildField = bLogicIO
                .getBLogicParams().get(1);
        assertEquals("request", parentFieldOverridenWithChildField.getSource());
        assertEquals("request", parentFieldOverridenWithChildField.getDest());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getBLogicProperty());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getProperty());

        BLogicProperty bLogicIOField = bLogicIO.getBLogicParams().get(2);
        assertEquals("form", bLogicIOField.getSource());
        assertEquals("form", bLogicIOField.getDest());
        assertEquals("bLogicIOField", bLogicIOField.getBLogicProperty());
        assertEquals("bLogicIOField", bLogicIOField.getProperty());

        BLogicProperty bLogicIOFormField = bLogicIO.getBLogicParams().get(3);
        assertEquals("form", bLogicIOFormField.getSource());
        assertEquals("form", bLogicIOFormField.getDest());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getBLogicProperty());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getProperty());

        BLogicProperty bLogicIORequestField = bLogicIO.getBLogicParams().get(4);
        assertEquals("request", bLogicIORequestField.getSource());
        assertEquals("request", bLogicIORequestField.getDest());
        assertEquals("bLogicIORequestField", bLogicIORequestField
                .getBLogicProperty());
        assertEquals("bLogicIORequestField", bLogicIORequestField.getProperty());

        BLogicProperty bLogicIOSessionField = bLogicIO.getBLogicParams().get(5);
        assertEquals("session", bLogicIOSessionField.getSource());
        assertEquals("session", bLogicIOSessionField.getDest());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField
                .getBLogicProperty());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField.getProperty());

        BLogicProperty bLogicIOApplicationField = bLogicIO.getBLogicParams()
                .get(6);
        assertEquals("application", bLogicIOApplicationField.getSource());
        assertEquals("application", bLogicIOApplicationField.getDest());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getBLogicProperty());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getProperty());

        BLogicProperty bLogicIOFieldWithProperty = bLogicIO.getBLogicParams()
                .get(7);
        assertEquals("form", bLogicIOFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFieldWithProperty.getDest());
        assertEquals("bLogicIOFieldWithProperty", bLogicIOFieldWithProperty
                .getBLogicProperty());
        assertEquals("property", bLogicIOFieldWithProperty.getProperty());

        BLogicProperty bLogicIOFormFieldWithProperty = bLogicIO
                .getBLogicParams().get(8);
        assertEquals("form", bLogicIOFormFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFormFieldWithProperty.getDest());
        assertEquals("bLogicIOFormFieldWithProperty",
                bLogicIOFormFieldWithProperty.getBLogicProperty());
        assertEquals("formProperty", bLogicIOFormFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIORequestFieldWithProperty = bLogicIO
                .getBLogicParams().get(9);
        assertEquals("request", bLogicIORequestFieldWithProperty.getSource());
        assertEquals("request", bLogicIORequestFieldWithProperty.getDest());
        assertEquals("bLogicIORequestFieldWithProperty",
                bLogicIORequestFieldWithProperty.getBLogicProperty());
        assertEquals("requestAttributeName", bLogicIORequestFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOSessionFieldWithProperty = bLogicIO
                .getBLogicParams().get(10);
        assertEquals("session", bLogicIOSessionFieldWithProperty.getSource());
        assertEquals("session", bLogicIOSessionFieldWithProperty.getDest());
        assertEquals("bLogicIOSessionFieldWithProperty",
                bLogicIOSessionFieldWithProperty.getBLogicProperty());
        assertEquals("sessionAttributeName", bLogicIOSessionFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOApplicationFieldWithProperty = bLogicIO
                .getBLogicParams().get(11);
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getSource());
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getDest());
        assertEquals("bLogicIOApplicationFieldWithProperty",
                bLogicIOApplicationFieldWithProperty.getBLogicProperty());
        assertEquals("applicationAttributeName",
                bLogicIOApplicationFieldWithProperty.getProperty());

        assertTrue(bLogicIO.getBLogicResults().isEmpty());
        assertEquals("jp.terasoluna.fw.service.thin.ChildParamBean",
                bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * createBLogicIOForBLogicParams\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : ChildResultBean.class
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().isEmpty() : true<br>
     * getBLogicResults().isEmpty() : true<br>
     * getInputBeanName() : "jp.terasoluna.fw.service.thin.ChildResultBean"<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicParamsWithInputBeanClass003() {
        BLogicIO bLogicIO = BLogicIOUtil
                .createBLogicIOForBLogicParams(ChildResultBean.class);

        assertEquals(0, bLogicIO.getBLogicParams().size());
        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertTrue(bLogicIO.getBLogicResults().isEmpty());
        assertNotNull(bLogicIO.getInputBeanName());
        assertEquals("jp.terasoluna.fw.service.thin.ChildResultBean",
                bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());

    }

    /**
     * createBLogicIOForBLogicResult\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : null
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().isEmpty() : true<br>
     * getBLogicResults().isEmpty() : true<br>
     * getInputBeanName() : null<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicResultWithNullResultObject() {
        BLogicIO bLogicIO = BLogicIOUtil.createBLogicIOForBLogicResult(null);
        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertTrue(bLogicIO.getBLogicResults().isEmpty());
        assertNull(bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * createBLogicIOForBLogicResult\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : new ChildBean().getClass()
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().isEmpty() : true<br>
     * getBLogicResults().size() : 12<br>
     * getInputBeanName() : null<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicResultWithResultObject001() {
        Object resultObject = new ChildBean();
        BLogicIO bLogicIO = BLogicIOUtil
                .createBLogicIOForBLogicResult(resultObject.getClass());

        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertEquals(12, bLogicIO.getBLogicResults().size());

        BLogicProperty parentField = bLogicIO.getBLogicResults().get(0);
        assertEquals("form", parentField.getSource());
        assertEquals("form", parentField.getDest());
        assertEquals("parentField", parentField.getBLogicProperty());
        assertEquals("parentField", parentField.getProperty());

        BLogicProperty parentFieldOverridenWithChildField = bLogicIO
                .getBLogicResults().get(1);
        assertEquals("request", parentFieldOverridenWithChildField.getSource());
        assertEquals("request", parentFieldOverridenWithChildField.getDest());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getBLogicProperty());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getProperty());

        BLogicProperty bLogicIOField = bLogicIO.getBLogicResults().get(2);
        assertEquals("form", bLogicIOField.getSource());
        assertEquals("form", bLogicIOField.getDest());
        assertEquals("bLogicIOField", bLogicIOField.getBLogicProperty());
        assertEquals("bLogicIOField", bLogicIOField.getProperty());

        BLogicProperty bLogicIOFormField = bLogicIO.getBLogicResults().get(3);
        assertEquals("form", bLogicIOFormField.getSource());
        assertEquals("form", bLogicIOFormField.getDest());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getBLogicProperty());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getProperty());

        BLogicProperty bLogicIORequestField = bLogicIO.getBLogicResults()
                .get(4);
        assertEquals("request", bLogicIORequestField.getSource());
        assertEquals("request", bLogicIORequestField.getDest());
        assertEquals("bLogicIORequestField", bLogicIORequestField
                .getBLogicProperty());
        assertEquals("bLogicIORequestField", bLogicIORequestField.getProperty());

        BLogicProperty bLogicIOSessionField = bLogicIO.getBLogicResults()
                .get(5);
        assertEquals("session", bLogicIOSessionField.getSource());
        assertEquals("session", bLogicIOSessionField.getDest());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField
                .getBLogicProperty());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField.getProperty());

        BLogicProperty bLogicIOApplicationField = bLogicIO.getBLogicResults()
                .get(6);
        assertEquals("application", bLogicIOApplicationField.getSource());
        assertEquals("application", bLogicIOApplicationField.getDest());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getBLogicProperty());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getProperty());

        BLogicProperty bLogicIOFieldWithProperty = bLogicIO.getBLogicResults()
                .get(7);
        assertEquals("form", bLogicIOFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFieldWithProperty.getDest());
        assertEquals("bLogicIOFieldWithProperty", bLogicIOFieldWithProperty
                .getBLogicProperty());
        assertEquals("property", bLogicIOFieldWithProperty.getProperty());

        BLogicProperty bLogicIOFormFieldWithProperty = bLogicIO
                .getBLogicResults().get(8);
        assertEquals("form", bLogicIOFormFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFormFieldWithProperty.getDest());
        assertEquals("bLogicIOFormFieldWithProperty",
                bLogicIOFormFieldWithProperty.getBLogicProperty());
        assertEquals("formProperty", bLogicIOFormFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIORequestFieldWithProperty = bLogicIO
                .getBLogicResults().get(9);
        assertEquals("request", bLogicIORequestFieldWithProperty.getSource());
        assertEquals("request", bLogicIORequestFieldWithProperty.getDest());
        assertEquals("bLogicIORequestFieldWithProperty",
                bLogicIORequestFieldWithProperty.getBLogicProperty());
        assertEquals("requestAttributeName", bLogicIORequestFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOSessionFieldWithProperty = bLogicIO
                .getBLogicResults().get(10);
        assertEquals("session", bLogicIOSessionFieldWithProperty.getSource());
        assertEquals("session", bLogicIOSessionFieldWithProperty.getDest());
        assertEquals("bLogicIOSessionFieldWithProperty",
                bLogicIOSessionFieldWithProperty.getBLogicProperty());
        assertEquals("sessionAttributeName", bLogicIOSessionFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOApplicationFieldWithProperty = bLogicIO
                .getBLogicResults().get(11);
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getSource());
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getDest());
        assertEquals("bLogicIOApplicationFieldWithProperty",
                bLogicIOApplicationFieldWithProperty.getBLogicProperty());
        assertEquals("applicationAttributeName",
                bLogicIOApplicationFieldWithProperty.getProperty());

        assertNull(bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * createBLogicIOForBLogicResult\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : new ChildResultBean().getClass()
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().isEmpty() : true<br>
     * getBLogicResults().size() : 12<br>
     * getInputBeanName() : null<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicResultWithResultObject002() {
        Object resultObject = new ChildResultBean();
        BLogicIO bLogicIO = BLogicIOUtil
                .createBLogicIOForBLogicResult(resultObject.getClass());

        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertEquals(12, bLogicIO.getBLogicResults().size());

        BLogicProperty parentField = bLogicIO.getBLogicResults().get(0);
        assertEquals("form", parentField.getSource());
        assertEquals("form", parentField.getDest());
        assertEquals("parentField", parentField.getBLogicProperty());
        assertEquals("parentField", parentField.getProperty());

        BLogicProperty parentFieldOverridenWithChildField = bLogicIO
                .getBLogicResults().get(1);
        assertEquals("request", parentFieldOverridenWithChildField.getSource());
        assertEquals("request", parentFieldOverridenWithChildField.getDest());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getBLogicProperty());
        assertEquals("parentFieldOverridenWithChildField",
                parentFieldOverridenWithChildField.getProperty());

        BLogicProperty bLogicIOField = bLogicIO.getBLogicResults().get(2);
        assertEquals("form", bLogicIOField.getSource());
        assertEquals("form", bLogicIOField.getDest());
        assertEquals("bLogicIOField", bLogicIOField.getBLogicProperty());
        assertEquals("bLogicIOField", bLogicIOField.getProperty());

        BLogicProperty bLogicIOFormField = bLogicIO.getBLogicResults().get(3);
        assertEquals("form", bLogicIOFormField.getSource());
        assertEquals("form", bLogicIOFormField.getDest());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getBLogicProperty());
        assertEquals("bLogicIOFormField", bLogicIOFormField.getProperty());

        BLogicProperty bLogicIORequestField = bLogicIO.getBLogicResults()
                .get(4);
        assertEquals("request", bLogicIORequestField.getSource());
        assertEquals("request", bLogicIORequestField.getDest());
        assertEquals("bLogicIORequestField", bLogicIORequestField
                .getBLogicProperty());
        assertEquals("bLogicIORequestField", bLogicIORequestField.getProperty());

        BLogicProperty bLogicIOSessionField = bLogicIO.getBLogicResults()
                .get(5);
        assertEquals("session", bLogicIOSessionField.getSource());
        assertEquals("session", bLogicIOSessionField.getDest());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField
                .getBLogicProperty());
        assertEquals("bLogicIOSessionField", bLogicIOSessionField.getProperty());

        BLogicProperty bLogicIOApplicationField = bLogicIO.getBLogicResults()
                .get(6);
        assertEquals("application", bLogicIOApplicationField.getSource());
        assertEquals("application", bLogicIOApplicationField.getDest());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getBLogicProperty());
        assertEquals("bLogicIOApplicationField", bLogicIOApplicationField
                .getProperty());

        BLogicProperty bLogicIOFieldWithProperty = bLogicIO.getBLogicResults()
                .get(7);
        assertEquals("form", bLogicIOFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFieldWithProperty.getDest());
        assertEquals("bLogicIOFieldWithProperty", bLogicIOFieldWithProperty
                .getBLogicProperty());
        assertEquals("property", bLogicIOFieldWithProperty.getProperty());

        BLogicProperty bLogicIOFormFieldWithProperty = bLogicIO
                .getBLogicResults().get(8);
        assertEquals("form", bLogicIOFormFieldWithProperty.getSource());
        assertEquals("form", bLogicIOFormFieldWithProperty.getDest());
        assertEquals("bLogicIOFormFieldWithProperty",
                bLogicIOFormFieldWithProperty.getBLogicProperty());
        assertEquals("formProperty", bLogicIOFormFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIORequestFieldWithProperty = bLogicIO
                .getBLogicResults().get(9);
        assertEquals("request", bLogicIORequestFieldWithProperty.getSource());
        assertEquals("request", bLogicIORequestFieldWithProperty.getDest());
        assertEquals("bLogicIORequestFieldWithProperty",
                bLogicIORequestFieldWithProperty.getBLogicProperty());
        assertEquals("requestAttributeName", bLogicIORequestFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOSessionFieldWithProperty = bLogicIO
                .getBLogicResults().get(10);
        assertEquals("session", bLogicIOSessionFieldWithProperty.getSource());
        assertEquals("session", bLogicIOSessionFieldWithProperty.getDest());
        assertEquals("bLogicIOSessionFieldWithProperty",
                bLogicIOSessionFieldWithProperty.getBLogicProperty());
        assertEquals("sessionAttributeName", bLogicIOSessionFieldWithProperty
                .getProperty());

        BLogicProperty bLogicIOApplicationFieldWithProperty = bLogicIO
                .getBLogicResults().get(11);
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getSource());
        assertEquals("application", bLogicIOApplicationFieldWithProperty
                .getDest());
        assertEquals("bLogicIOApplicationFieldWithProperty",
                bLogicIOApplicationFieldWithProperty.getBLogicProperty());
        assertEquals("applicationAttributeName",
                bLogicIOApplicationFieldWithProperty.getProperty());

        assertNull(bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * createBLogicIOForBLogicResult\bh
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : new ChildParamBean().getClass()
     * </p>
     * <p>
     * ҒlF<br>
     * return : not null<br>
     * getBLogicParams().isEmpty() : true<br>
     * getBLogicResults().isEmpty() : true<br>
     * getInputBeanName() : null<br>
     * getPath() : null<br>
     * </p>
     */
    @Test
    public final void testCreateBLogicIOForBLogicResultWithResultObject003() {
        Object resultObject = new ChildParamBean();
        BLogicIO bLogicIO = BLogicIOUtil
                .createBLogicIOForBLogicResult(resultObject.getClass());

        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertEquals(0, bLogicIO.getBLogicResults().size());
        assertTrue(bLogicIO.getBLogicParams().isEmpty());
        assertTrue(bLogicIO.getBLogicResults().isEmpty());
        assertNull(bLogicIO.getInputBeanName());
        assertNull(bLogicIO.getPath());
    }

    /**
     * BLogicIOUtilRXgN^
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * () : Ȃ
     * </p>
     * <p>
     * ҒlF<br>
     * OȂ<br>
     * </p>
     */
    @Test
    public void testBLogicIOUtil() throws Exception {
        Constructor<BLogicIOUtil> con = null;
        try {
            con = BLogicIOUtil.class.getDeclaredConstructor();
            con.setAccessible(true);
            con.newInstance();
        } catch (Exception e) {
            fail();
        }
    }
}
