/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.resolver;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.util.GenericBeanFactoryAccessorEx;
import jp.terasoluna.fw.web.struts.action.annotation.ActionComponent;
import jp.terasoluna.fw.web.struts.action.annotation.BLogicComponent;
import jp.terasoluna.fw.web.struts.actions.AnnotationBLogicAction;
import jp.terasoluna.fw.web.struts.actions.BLogicAction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.struts.ContextLoaderPlugIn;

/**
 * BLogicActionResolver
 * <p>
 * {@link BLogic}{@link BLogicAction}тANV]oB
 * </p>
 * <p>
 * ftHgł "defaultBlogicAction" ƂO{@link BLogicAction}擾B<br>
 * {@link BLogicAction}Bean`̃XR[v prototype Œ`ĂƁB
 * </p>
 * <p>
 * W[sꍇ́A{@link ContextLoaderListener} ǂݍ܂Bean`t@CiapplicationContext.xmlȂǁjɂ͒`A<br>
 * {@link ContextLoaderPlugIn} ǂݍ܂Bean`t@CimoduleContext.xmlȂǁjɃW[Ƃɒ`邱ƁB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.DelegatingRequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.action.handler.DefaultDelegateActionHandler
 * @see jp.terasoluna.fw.web.struts.action.resolver.ActionResolver
 * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver
 */
public class BLogicActionResolver extends AbstractActionResolver
                                                                implements
                                                                InitializingBean,
                                                                ApplicationContextAware {

    /**
     * OB
     */
    private static Log log = LogFactory.getLog(BLogicActionResolver.class);

    /** {@link BLogicAction}LbV */
    protected ConcurrentHashMap<BLogic<?>, Action> blogicActionMap = new ConcurrentHashMap<BLogic<?>, Action>();

    /** {@link Action}LbV */
    protected ConcurrentHashMap<Object, Action> otherActionMap = new ConcurrentHashMap<Object, Action>();

    /** ANVpX-Bean}bv */
    protected Map<String, String> actionPathMap = new ConcurrentHashMap<String, String>();

    /** {@link WebApplicationContext} */
    protected WebApplicationContext webApplicationContext = null;

    /*
     * (non-Javadoc)
     * @see org.springframework.beans.factory.InitializingBean#afterPropertiesSet()
     */
    public void afterPropertiesSet() throws Exception {
        // {@link BLogicComponent},{@link ActionComponent}Bean}bv
        Map<String, Object> componentMap = new ConcurrentHashMap<String, Object>();

        if (this.webApplicationContext != null) {
            // Ώۂ̃R|[lgR|[lg}bvɒǉ
            addTargetComponent(componentMap, this.webApplicationContext);

            Set<?> alsEs = componentMap.entrySet();
            for (Object alsObj : alsEs) {
                Map.Entry<?, ?> elsMe = (Map.Entry<?, ?>) alsObj;
                Object elsObj = elsMe.getValue();

                // ^[QbgIuWFNgANVpXz擾ĕԋp
                String[] pathAry = getActionPathArray(elsObj);

                if (pathAry != null) {
                    for (String path : pathAry) {
                        if (path != null) {
                            if (!this.actionPathMap.containsKey(path)) {
                                Object keyObj = elsMe.getKey();
                                if (keyObj instanceof String) {
                                    this.actionPathMap.put(path,
                                            (String) keyObj);
                                }
                            } else {
                                if (log.isWarnEnabled()) {
                                    StringBuilder sb = new StringBuilder();
                                    sb.append("The action path ");
                                    sb.append("duplication.");
                                    sb.append(" path:[");
                                    sb.append(path);
                                    sb.append("]");
                                    sb.append(" bean1:[");
                                    sb.append(this.actionPathMap.get(path));
                                    sb.append("]");
                                    sb.append(" bean2:[");
                                    sb.append(elsMe.getKey());
                                    sb.append("]");
                                    log.warn(sb.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /**
     * Ώۂ̃R|[lgR|[lg}bvɒǉ
     * @param cpMap R|[lg}bv
     * @param wac {@link WebApplicationContext}
     */
    protected void addTargetComponent(Map<String, Object> cpMap,
            WebApplicationContext wac) {
        GenericBeanFactoryAccessorEx gbfa = new GenericBeanFactoryAccessorEx(
                wac);

        // Bean}bvRei擾
        Map<String, Object> bcMap = gbfa
                .getBeansWithAnnotation(BLogicComponent.class);
        Map<String, Object> acMap = gbfa
                .getBeansWithAnnotation(ActionComponent.class);

        cpMap.putAll(bcMap);
        cpMap.putAll(acMap);
    }

    /**
     * ^[QbgIuWFNgANVpXz擾ĕԋp
     * @param obj Object ^[QbgIuWFNg
     * @return String[] ANVpXz
     */
    protected String[] getActionPathArray(Object obj) {
        String[] pathAry = null;

        // AOPĂꍇɃ^[QbgNX擾
        Class<? extends Object> targetClass = getTargetClass(obj);

        if (obj instanceof BLogic) {
            pathAry = getBLogicComponentPath(targetClass);
        } else if (obj instanceof Action) {
            pathAry = getActionComponentPath(targetClass);
        }
        return pathAry;
    }

    /**
     * ^[QbgNXBLogicComponentAme[V擾ANVpXzԋp
     * @param targetClass ^[QbgNX
     * @return String[] ANVpXz
     */
    protected String[] getBLogicComponentPath(
            Class<? extends Object> targetClass) {

        // BLogicComponentAme[VNX擾
        BLogicComponent blc = targetClass.getAnnotation(BLogicComponent.class);

        // pXXg擾
        String[] pathArray = null;
        if (blc != null) {
            pathArray = blc.path();
        }

        if (pathArray != null && pathArray.length > 0) {
            if (pathArray[0] != null) {
                // Xg̐擪pX̂ݕԋp
                return new String[] { pathArray[0] };
            }
        }
        return null;
    }

    /**
     * ^[QbgNXActionComponentAme[V擾ANVpXzԋp
     * @param targetClass ^[QbgNX
     * @return String[] ANVpXz
     */
    protected String[] getActionComponentPath(
            Class<? extends Object> targetClass) {
        // gp
        return null;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#isBeanExist(java.lang.String,
     * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected boolean isBeanExist(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {
        if (wac == null) {
            return false;
        }
        // BLogicActionBeanɑΉBean݂邱ƂmF
        if (!wac.containsBean(actionName)) {
            if (log.isWarnEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Action bean not found.");
                sb.append(" actionName:[");
                sb.append(actionName);
                sb.append("]");
                log.warn(sb.toString());
            }
            return false;
        }
        return true;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#getActionCacheKey(java.lang.String,
     * org.apache.struts.action.ActionMapping, org.apache.struts.action.ActionServlet,
     * org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected Object getActionCacheKey(String beanName, ActionMapping mapping,
            ActionServlet servlet, WebApplicationContext wac) {
        Object key = null;

        // ANVpXɑΉBean݂ȂƂmF
        if (!wac.containsBean(beanName)) {
            // Ame[Vɕt^ꂽANVpXɊYBeañGg[擾
            String convertBeanName = getAnnotationBeanEntry(beanName, wac);
            if (convertBeanName != null) {
                key = wac.getBean(convertBeanName);
            }

            // ΉrWlXWbNEANVȂꍇnullŕԂ
            if (key == null) {
                if (log.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("BLogic or Action not found.");
                    sb.append(" beanName:[");
                    sb.append(beanName);
                    sb.append("]");
                    log.warn(sb.toString());
                }
                return null;
            }
        } else {
            // BLogic/ActionRei擾
            key = wac.getBean(beanName);
        }

        return key;
    }

    /**
     * Ame[Vɕt^ꂽANVpXۂBeanԋp.
     * @param actionPath String ANVpX
     * @param wac WebApplicationContext
     * @return Bean
     */
    protected String getAnnotationBeanEntry(String actionPath,
            WebApplicationContext wac) {
        return this.actionPathMap.get(actionPath);
    }

    /**
     * IuWFNg̃NX^擾
     * @param targetObject Ώۂ̃IuWFNg
     * @return Ώۂ̃IuWFNg̃NX^
     */
    @SuppressWarnings("unchecked")
    protected Class<? extends Object> getTargetClass(Object targetObject) {
        Class<? extends Object> targetClass = null;

        if (targetObject != null) {
            if (AopUtils.isAopProxy(targetObject)) {
                targetClass = AopUtils.getTargetClass(targetObject);
            } else {
                targetClass = targetObject.getClass();
            }
        }

        return targetClass;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#getActionCache(java.lang.Object)
     */
    @Override
    protected Action getActionCache(Object cacheKey) {
        if (cacheKey instanceof BLogic) {
            return this.blogicActionMap.get((BLogic<?>) cacheKey);
        } else if (cacheKey != null) {
            return this.otherActionMap.get(cacheKey);
        }
        return null;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#putActionCache(java.lang.Object,
     * org.apache.struts.action.Action)
     */
    @Override
    protected void putActionCache(Object cacheKey, Action action) {
        if (cacheKey instanceof BLogic) {
            this.blogicActionMap.put((BLogic<?>) cacheKey, action);
        } else {
            this.otherActionMap.put(cacheKey, action);
        }
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#extensionProcess(java.lang.Object,
     * org.apache.struts.action.Action, java.lang.String, org.apache.struts.action.ActionMapping,
     * org.apache.struts.action.ActionServlet, org.springframework.web.context.WebApplicationContext)
     */
    @SuppressWarnings("unchecked")
    @Override
    protected Action extensionProcess(Object key, Action action,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac) {
        Action resultAction = action;

        if (action instanceof BLogicAction
                || action instanceof AnnotationBLogicAction
                || key instanceof Action) {

            if (key instanceof BLogic && action != null) {
                BLogic blogic = (BLogic) key;
                if (action instanceof BLogicAction) {
                    BLogicAction<?> blogicAction = (BLogicAction<?>) action;

                    // BLogicݒ
                    blogicAction.setBusinessLogic((BLogic) blogic);
                } else if (action instanceof AnnotationBLogicAction) {
                    AnnotationBLogicAction<?> blogicAction = (AnnotationBLogicAction<?>) action;

                    // BLogicݒ
                    blogicAction.setBusinessLogic((BLogic) blogic);
                }
            } else if (key instanceof Action && action == null) {
                // L[ActionƂĕԋp
                resultAction = (Action) key;
            } else {
                // rWlXWbNA邢̓ANVȂꍇnullŕԂ
                if (log.isWarnEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("The business logic or ");
                    sb.append("the action is not found. ");
                    sb.append(" beanName:[");
                    sb.append(beanName);
                    sb.append("]");
                    sb.append(" actionName:[");
                    sb.append(actionName);
                    sb.append("]");
                    log.warn(sb.toString());
                }
                return null;
            }
        }

        return resultAction;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.resolver.AbstractActionResolver#isCacheEnabled(java.lang.Object,
     * org.apache.struts.action.Action, java.lang.String, org.apache.struts.action.ActionMapping,
     * org.apache.struts.action.ActionServlet, org.springframework.web.context.WebApplicationContext)
     */
    @Override
    protected boolean isCacheEnabled(Object key, Action resultAction,
            String beanName, ActionMapping mapping, ActionServlet servlet,
            WebApplicationContext wac) {

        if (wac.containsBean(beanName)) {
            // singleton̂Ƃ̂݃LbV
            return wac.isSingleton(beanName);
        }

        // Ame[Vɕt^ꂽANVpXT
        String annotationPath = getAnnotationBeanEntry(beanName, wac);
        if (annotationPath != null) {
            if (wac.containsBean(annotationPath)) {
                // singleton̂Ƃ̂݃LbV
                return wac.isSingleton(annotationPath);
            }
        }

        return false;
    }

    /*
     * (non-Javadoc)
     * @see
     * org.springframework.context.ApplicationContextAware#setApplicationContext(org.springframework.context.ApplicationContext)
     */
    public void setApplicationContext(ApplicationContext applicationContext)
                                                                            throws BeansException {
        if (applicationContext instanceof WebApplicationContext) {
            this.webApplicationContext = (WebApplicationContext) applicationContext;
        }
    }
}
