/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.connector;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.connector.InteractionImplementor;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import java.util.HashMap;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.cci.InteractionSpec;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;

public class MappedRecordInteraction
implements InteractionImplementor {
    private boolean enabled;
    private Map expectedRequest;
    private Map responseData;
    private Class responseClass;
    private Record responseRecord;

    public MappedRecordInteraction() {
        this(null, null, MockMappedRecord.class);
    }

    public MappedRecordInteraction(Map map) {
        this(null, map, MockMappedRecord.class);
    }

    public MappedRecordInteraction(Map map, Map map2) {
        this(map, map2, MockMappedRecord.class);
    }

    public MappedRecordInteraction(Map map, Class clazz) {
        this(null, map, clazz);
    }

    public MappedRecordInteraction(Map map, Map map2, Class clazz) {
        this.setExpectedRequest(map);
        this.setResponse(map2, clazz);
        this.enabled = true;
    }

    public MappedRecordInteraction(Map map, Record record) {
        this.setExpectedRequest(map);
        this.setResponse(record);
        this.enabled = true;
    }

    public MappedRecordInteraction(Record record) {
        this(null, record);
    }

    public void enable() {
        this.enabled = true;
    }

    public void disable() {
        this.enabled = false;
    }

    public void setExpectedRequest(Map map) {
        this.expectedRequest = null == map ? null : new HashMap(map);
    }

    public void setResponse(Map map) {
        this.setResponse(map, MockMappedRecord.class);
    }

    public void setResponse(Map map, Class clazz) {
        if (!this.isResponseClassAcceptable(clazz)) {
            throw new IllegalArgumentException("responseClass must implement " + MappedRecord.class.getName());
        }
        this.responseData = null == map ? null : new HashMap(map);
        this.responseClass = clazz;
    }

    public void setResponse(Record record) {
        this.responseRecord = record;
    }

    public boolean canHandle(InteractionSpec interactionSpec, Record record, Record record2) {
        if (!this.enabled) {
            return false;
        }
        if (!this.isResponseAcceptable(record2)) {
            return false;
        }
        return this.doesRequestMatch(record);
    }

    private boolean doesRequestMatch(Record record) {
        if (null == this.expectedRequest) {
            return true;
        }
        if (null == record) {
            return false;
        }
        if (record instanceof MappedRecord) {
            try {
                MappedRecord mappedRecord = (MappedRecord)record;
                if (mappedRecord.size() != this.expectedRequest.size()) {
                    return false;
                }
                for (Object e : mappedRecord.keySet()) {
                    Object v;
                    Object object = mappedRecord.get(e);
                    if (this.areObjectsEquals(object, v = this.expectedRequest.get(e))) continue;
                    return false;
                }
                return true;
            }
            catch (Exception exception) {
                throw new NestedApplicationException(exception);
            }
        }
        return false;
    }

    private boolean areObjectsEquals(Object object, Object object2) {
        if (null == object && null == object2) {
            return true;
        }
        if (null == object) {
            return false;
        }
        return object.equals(object2);
    }

    private boolean isResponseAcceptable(Record record) {
        return null == record || record instanceof MappedRecord;
    }

    private boolean isResponseClassAcceptable(Class clazz) {
        return null == clazz || MappedRecord.class.isAssignableFrom(clazz);
    }

    public Record execute(InteractionSpec interactionSpec, Record record) throws ResourceException {
        if (!this.canHandle(interactionSpec, record, null)) {
            return null;
        }
        if (null != this.responseRecord) {
            return this.responseRecord;
        }
        MockMappedRecord mockMappedRecord = null;
        try {
            mockMappedRecord = null == this.responseClass ? new MockMappedRecord() : (MappedRecord)this.responseClass.newInstance();
            if (null != this.responseData) {
                mockMappedRecord.putAll(this.responseData);
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException("execute() failed");
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        return mockMappedRecord;
    }

    public boolean execute(InteractionSpec interactionSpec, Record record, Record record2) throws ResourceException {
        if (!this.canHandle(interactionSpec, record, record2)) {
            return false;
        }
        try {
            if (null != this.responseData && null != record2) {
                ((MappedRecord)record2).clear();
                ((MappedRecord)record2).putAll(this.responseData);
            }
        }
        catch (Exception exception) {
            ResourceException resourceException = new ResourceException("execute() failed");
            resourceException.setLinkedException(exception);
            throw resourceException;
        }
        return true;
    }
}

