/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.unit.io.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.terasoluna.fw.ex.unit.exception.UTRuntimeException;
import jp.terasoluna.fw.ex.unit.io.OutputTarget;
import jp.terasoluna.fw.ex.unit.util.DefaultLineJoiner;
import jp.terasoluna.fw.ex.unit.util.LineJoiner;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CsvTarget<T>
implements OutputTarget<T> {
    private PrintWriter writer;
    private String[] header;
    private String dateFormat = "yyyy-MM-dd HH:mm:ss";
    private SimpleDateFormat format = new SimpleDateFormat(this.dateFormat);
    private LineJoiner lineJoiner = new DefaultLineJoiner(",");

    public CsvTarget(String path) throws UTRuntimeException {
        this(path, "MS932");
    }

    public CsvTarget(String path, String encoding) throws UTRuntimeException {
        try {
            this.writer = new PrintWriter(new File(path), encoding);
        }
        catch (IOException e) {
            throw new UTRuntimeException(e);
        }
    }

    @Override
    public void writeHeader(String[] header) {
        this.header = header;
        this.writer.println(this.lineJoiner.join(header));
    }

    @Override
    public void write(T obj) {
        Assert.notNull((Object)this.header);
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(obj);
        try {
            ArrayList<String> lineData = new ArrayList<String>();
            for (int i = 0; i < this.header.length; ++i) {
                String propertyName = this.header[i];
                if (beanWrapper.isReadableProperty(propertyName)) {
                    Object o = beanWrapper.getPropertyValue(propertyName);
                    if (o instanceof Date) {
                        lineData.add(this.format.format((Date)o));
                        continue;
                    }
                    if (o == null) {
                        lineData.add("");
                        continue;
                    }
                    lineData.add(String.valueOf(o));
                    continue;
                }
                lineData.add("");
            }
            String[] line = lineData.toArray(new String[lineData.size()]);
            this.writer.println(this.lineJoiner.join(line));
            this.writer.flush();
        }
        catch (Exception e) {
            throw new UTRuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.format = new SimpleDateFormat(dateFormat);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public LineJoiner getLineJoiner() {
        return this.lineJoiner;
    }

    public void setLineJoiner(LineJoiner lineJoiner) {
        this.lineJoiner = lineJoiner;
    }
}

