/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.DbObjectBase;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class DropDatabase
extends DefineCommand {
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }

    public int update() throws SQLException {
        if (this.dropAllObjects) {
            this.dropAllObjects();
        }
        if (this.deleteFiles) {
            this.session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }

    private void dropAllObjects() throws SQLException {
        String string;
        DbObject dbObject;
        int n;
        this.session.getUser().checkAdmin();
        this.session.commit(true);
        Database database = this.session.getDatabase();
        ObjectArray objectArray = database.getAllSchemas();
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (Schema)objectArray.get(n);
            if (!((Schema)dbObject).canDrop()) continue;
            database.removeDatabaseObject(this.session, dbObject);
        }
        objectArray = database.getAllSchemaObjects(0);
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (Table)objectArray.get(n);
            if (((DbObjectBase)dbObject).getName() == null || !"VIEW".equals(((Table)dbObject).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)dbObject);
        }
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (Table)objectArray.get(n);
            if (((DbObjectBase)dbObject).getName() == null || !"TABLE LINK".equals(((Table)dbObject).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)dbObject);
        }
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (Table)objectArray.get(n);
            if (((DbObjectBase)dbObject).getName() == null || !"TABLE".equals(((Table)dbObject).getTableType())) continue;
            database.removeSchemaObject(this.session, (SchemaObject)dbObject);
        }
        this.session.findLocalTempTable(null);
        objectArray = database.getAllSchemaObjects(3);
        objectArray.addAll(database.getAllSchemaObjects(5));
        objectArray.addAll(database.getAllSchemaObjects(4));
        objectArray.addAll(database.getAllSchemaObjects(11));
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (SchemaObject)objectArray.get(n);
            database.removeSchemaObject(this.session, (SchemaObject)dbObject);
        }
        objectArray = database.getAllUsers();
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (User)objectArray.get(n);
            if (dbObject == this.session.getUser()) continue;
            database.removeDatabaseObject(this.session, dbObject);
        }
        objectArray = database.getAllRoles();
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (Role)objectArray.get(n);
            string = ((Role)dbObject).getCreateSQL();
            if (string == null) continue;
            database.removeDatabaseObject(this.session, dbObject);
        }
        objectArray = database.getAllRights();
        objectArray.addAll(database.getAllFunctionAliases());
        objectArray.addAll(database.getAllAggregates());
        objectArray.addAll(database.getAllUserDataTypes());
        for (n = 0; n < objectArray.size(); ++n) {
            dbObject = (DbObject)objectArray.get(n);
            string = dbObject.getCreateSQL();
            if (string == null) continue;
            database.removeDatabaseObject(this.session, dbObject);
        }
    }

    public void setDropAllObjects(boolean bl) {
        this.dropAllObjects = bl;
    }

    public void setDeleteFiles(boolean bl) {
        this.deleteFiles = bl;
    }
}

