/*
 * Copyright (c) 2016 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.formex.web.action;

import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

import jp.terasoluna.fw.web.struts.actions.ActionEx;
import jp.terasoluna.thin.functionsample.formex.bean.MultipartRequestHandler;

/**
 * Struts̐Ǝ㐫(CVE-2016-1181)΍̃`FbNpANVNX(DynaActionFormp)
 * @version 2016/07/19
 */
public class MrhDynaAction extends ActionEx {

    /**
     * LOGGER
     */
    private Log log = LogFactory.getLog(MrhDynaAction.class);

    /**
     * DynaActionForm̏OɏƂƂɁAʕ\̂߂ɃNGXgXR[v֊i[B
     * @see jp.terasoluna.fw.web.struts.actions.ActionEx#doExecute(org.apache.struts.action.ActionMapping,
     *      org.apache.struts.action.ActionForm, javax.servlet.http.HttpServletRequest, javax.servlet.http.HttpServletResponse)
     * @param mapping ActionMapping
     * @param form DynaValidatorActionFormEx(DynaActionForm)
     * @param req HttpServletRequest
     * @param res HttpServletResponse
     * @return ActionForward
     * @throws Exception O
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping, ActionForm form, HttpServletRequest req, HttpServletResponse res)
                                                                                                                           throws Exception {
        // OActionForm̓eo͂Asvȃp[^XLbvĂȂƂmFł悤ɂB
        // form check: p[^=p[^l
        DynaActionForm mrhDynaForm = (DynaActionForm) form;
        String strMrhTextLower = ((MultipartRequestHandler)mrhDynaForm.get("multipartRequestHandler")).getTextLower();
        String strMrhTextUpper = ((MultipartRequestHandler)mrhDynaForm.get("MultipartRequestHandler")).getTextUpper();

        if (strMrhTextLower != null) {
            log.info("multipartRequestHandler.textLower=" + strMrhTextLower);
        }
        if (strMrhTextUpper != null) {
            log.info("MultipartRequestHandler.textUpper=" + strMrhTextUpper);
        }

        log.info("form check: userId=" + Arrays.toString((String[]) mrhDynaForm.get("userId")));

        // ʕ\pActionForm̓eNGXgXR[vɊi[
        Map<String, String> resultMap = new TreeMap<String, String>();

        if (strMrhTextLower != null) {
            resultMap.put("multipartRequestHandler.textLower", strMrhTextLower);
        }
        if (strMrhTextUpper != null) {
            resultMap.put("MultipartRequestHandler.textUpper", strMrhTextUpper);
        }

        resultMap.put("form-type", "DynaActionForm");
        String[] userIds = (String[]) mrhDynaForm.get("userId");
        if (userIds.length == 0) {
            // '[]'Əo͂̂
            resultMap.put("userId", "");
        } else {
            resultMap.put("userId", Arrays.toString((String[]) mrhDynaForm.get("userId")));
        }
        req.setAttribute("resultMap", resultMap);

        // ʑJ
        return mapping.findForward("success");
    }

}
