/*
 * Copyright (c) 2016 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

/**
 * AccessControlPathResolver̃ftHgNXB
 * <p>
 * ̃NX{@link #resolveAccessControlPath(ServletRequest)}\bhԋp̂́A
 * <ul>
 * <li>RequestURI̐擪ContextPath(ʂu/v󕶎ɂȂꍇ̂)</li>
 * <li>ServletPath</li>
 * <li>ServletPath + PathInfo(PathInfou/vŎn܂ꍇ̂)</li>
 * </ul>
 * ̂ꂩłB
 * ڍׂȎdlђӓ_́A{@link #resolveAccessControlPath(ServletRequest)} QƂ̂ƁB
 * </p>
 * @see AccessControlPathResolver
 */
public class DefaultAccessControlPathResolver implements
                                             AccessControlPathResolver {

    /**
     * ANZXp̃pXAԋpB
     * <ul>
     * <li>PathInfo"/"Ŏn܂ꍇ́AServletPathPathInfoAĕԂB</li>
     * <li>PathInfo"/"Ŏn܂Ȃꍇ(PathInfonull̏ꍇ܂)́AServletPatĥ݂ԂB</li>
     * <li>ARequestURI̐擪ContextPathʂAu/v܂͋󕶎ƂȂꍇA
     * ServletPathPathInfoɂ炸Aꂼ(u/v󕶎)ԂB</li>
     * </ul>
     * ServletPathƂnullꂽꍇA󕶎ƓƂB<br>
     * requestnullnꂽꍇnullԋpB<br>
     * <br>
     * 1F<br>
     * APT[oɂẮApX׍HɕʂɃReLXg[gɃANZXĂA<br>
     * ̃\bh̖߂lu/v󕶎ȊO̕(web.xmlŐݒ肵welcome-file̐擪Ɂu/vǉpX)ɂȂ肤B<br>
     * (RequestURI-ContextPathŉZĂAServletPath+PathInfoŉZĂAu/v󕶎ɂȂȂAPT[o݂B)<br>
     * āAReLXg[gɑ΂ăANZXȂꍇ́A<br>
     * {ԉ^pŎgp\APT[ogpAʂɃReLXg[gփANZXꍇ<br>
     * ̃\bhԂpXmFÃpXɃANZXȂ悤ݒ肠邢͎KvB<br>
     * ʂɃReLXg[gփANZXۂURLF<br>
     * <ul>
     * <li>http://host:port/contextRoot</li>
     * <li>http://host:port/contextRoot/</li>
     * <li>http://host:port/contextRoot/;jsessionid=xxx<br>
     * (CookiegpłȂNCAgɑ΂A
     * ReLXg[gւ̃NƂāu/contextRoot/;jsessionid=xxxv̌`̃pXo͂Ăꍇ)</li>
     * </ul>
     * <br>
     * 2F<br>
     * APT[oɂẮApX׍H邱ƂŁA<br>
     * ̃\bh̖߂lAʂɃReLXg[gɃANZXƂƓɂȂȂŁA<br>
     * ReLXg[gւ̃ANZX\łB<br>
     * (̃\bh̖߂lAu/vA󕶎Awelcome-file̐擪Ɂu/vǉpX̂ɂȂȂĂA
     * welcome-file̐擪Ɂu/vǉpXsꍇB)<br>
     * āAReLXg[gɑ΂ăANZXꍇ́A<br>
     * eAPT[oɍœKAʂ̎NXpӂȂ΂ȂȂB<br>
     * (ʂ́AReLXg[g͒NłANZXł悤ɂ邽߁A<br>
     * ReLXg[gɑ΂ăANZX邱Ƃ͂ȂB)<br>
     * <br>
     * 3F<br>
     * PathInfogpServletAŎgpĂNXAPathInfô܂܎gpA<br>
     * PathInfo̐K̕ҏWsĉ߂Ăꍇ̂悤ɁA<br>
     * 1̃\[XɃANZX邽߂PathInfoʂ葶݂ꍇA<br>
     * ̎ԋppXł́AANZX䂪mɍsȂꍇB<br>
     * (Ⴆ΁A/PathInfo1łȂ/PathInfo2/PathInfo1ƓłServlet߂ꍇA<br>
     *  /ServletPath/PathInfo1ANZXĂA/ServletPath/PathInfo2ƂȂB)<br>
     * ̂悤ȃP[XŃANZX䂵ꍇ́A<br>
     * ServletPath̍ۂɂServletƓWbNPathInfo߂悤A<br>
     * {\bhI[o[Ch邩A<br>
     * 1̃\[XɃANZX邽߂PathInfoʂ葶݂Ȃ悤<br>
     * ServletKvB<br>
     * (Ⴆ΁APathInfo𐳋KăANZXNX𗘗pƂɂ́A<br>
     * KOPathInfo̒lقȂĂΕsPathInfoƔf铙B)<br>
     * @param request ANZXp̃pX̎ZoƂȂ <code>ServletRequest</code> NXCX^XB
     * @return ANZXp̃pXBrequestnullnꂽꍇnullB
     * @see AccessControlPathResolver#resolveAccessControlPath(javax.servlet.ServletRequest)
     */
    public String resolveAccessControlPath(ServletRequest request) {
        if (request == null) {
            return null;
        }

        // RequestURI̐擪ContextPathʂAu/v܂͋󕶎ƂȂꍇA
        // ꂼ(u/v󕶎)ԂB
        // TERASOLUNA Server FW̃o[W2.0.6.1܂ł̃pX̉Z@ŁA
        // ZLeB̖肪]n̂Ȃ̃pXɂẮA
        // 2.0.6.1܂ł̉Z@𓥏PB
        HttpServletRequest req = (HttpServletRequest) request;
        String contextPath = req.getContextPath();
        String requestURI = req.getRequestURI();

        // RequestURI=/xxx, ContextPath=/xxx
        // RequestURI-ContextPath=>󕶎
        if (requestURI.equals(contextPath)) {
            return "";
        }

        // RequestURI=/xxx/, ContextPath=/xxx
        // RequestURI-ContextPath=>"/"
        if (requestURI.length() == contextPath.length() + 1
                && requestURI.startsWith(contextPath)
                && requestURI.charAt(contextPath.length()) == '/') {
            return "/";
        }

        // ServletPathƂnullꂽꍇA󕶎ƓƂB
        String servletPath = req.getServletPath();
        if (servletPath == null) {
            servletPath = "";
        }

        String pathInfo = req.getPathInfo();
        if (pathInfo != null && pathInfo.startsWith("/")) {
            // PathInfonullł͂ȂAu/vŎn܂Ă΁A
            // ServletPathPathInfoAĕԂB
            // z肷󋵁F
            // Eu/xxx/*vServlet}bsOĂāAu/xxx/`vɃANZXꂽꍇ
            // EWASŐÓIt@CɃANZXꂽꍇ(pXServletPathł͂ȂPathInfoɍڂ)
            // ETomcat7Servlet3.0\ȋ󕶎}bsOsAReLXg[gɃANZXꂽꍇ
            //   (Servlet3.0dlł́ÂƂContextPath͋󕶎ɂȂƒ߂ĂAL̉\邪A
            //    Tomcat7ł͖{ɂ̒ʂɓ삷邽߁A
            //    ʂɃReLXg[gɃANZXĂĂÃWbNɓ)
            return servletPath + pathInfo;
        } else {
            // PathInfou/vŎn܂Ȃꍇ(null̏ꍇ܂)́A
            // PathInfo͘AȂB
            // z肷󋵁F
            // EPathInfoServlet}bsOAPathInfo^Ȃꍇ
            //   (u/xxx/*vServlet}bsOĂāAu/xxxvɃANZXꂽꍇ)
            // Eu/xxxvu*.dovu/xxx.jspvAPathInfoȂServlet}bsOɂւ炸A
            //   sPathInfo(APT[oɂĂ͉\)ꂽꍇ
            return servletPath;
        }
    }

}
