/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.web.struts.action.handler.DelegateActionHandler;
import jp.terasoluna.fw.web.struts.action.handler.ProcessActionFormHandler;
import jp.terasoluna.fw.web.struts.action.handler.ProcessMultipartHandler;
import jp.terasoluna.fw.web.struts.action.handler.ProcessPopulateHandler;
import jp.terasoluna.fw.web.struts.action.handler.ProcessValidateHandler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.InvalidCancelException;
import org.apache.struts.config.ModuleConfig;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;

/**
 * DelegatingRequestProcessorEx
 * <p>
 * ꕔ̏nhNXɈϏRequestProcessorEx̊gNX
 * </p>
 * <p>
 * ReiɃnh݂ꍇ͂ɏϏA݂Ȃꍇ͏]̏sB
 * </p>
 * @see jp.terasoluna.fw.web.struts.action.RequestProcessorEx
 * @see jp.terasoluna.fw.web.struts.action.handler.DefaultDelegateActionHandler
 * @see jp.terasoluna.fw.web.struts.action.handler.DelegateActionHandler
 * @see jp.terasoluna.fw.web.struts.action.handler.ProcessActionFormHandler
 * @see jp.terasoluna.fw.web.struts.action.handler.ProcessMultipartHandler
 * @see jp.terasoluna.fw.web.struts.action.handler.ProcessPopulateHandler
 * @see jp.terasoluna.fw.web.struts.action.handler.ProcessValidateHandler
 */
public class DelegatingRequestProcessorEx extends RequestProcessorEx {

    /**
     * OB
     */
    private static Log log = LogFactory
            .getLog(DelegatingRequestProcessorEx.class);

    /** ProcessMultipartHandlerBeanύXۂ̃VXevpeB */
    protected static final String SYSTEM_PROPERTY_PROCESSMULTIPART_HANDLER_NAME = "DelegatingRequestProcessorEx.processMultipartHandler";

    /** ProcessActionFormHandlerBeanύXۂ̃VXevpeB */
    protected static final String SYSTEM_PROPERTY_PROCESSACTIONFORM_HANDLER_NAME = "DelegatingRequestProcessorEx.processActionFormHandler";

    /** ProcessPopulateHandlerBeanύXۂ̃VXevpeB */
    protected static final String SYSTEM_PROPERTY_PROCESSPOPULATE_HANDLER_NAME = "DelegatingRequestProcessorEx.processPopulateHandler";

    /** ProcessValidateHandlerBeanύXۂ̃VXevpeB */
    protected static final String SYSTEM_PROPERTY_PROCESSVALIDATE_HANDLER_NAME = "DelegatingRequestProcessorEx.processValidateHandler";

    /** DelegateActionHandlerBeanύXۂ̃VXevpeB */
    protected static final String SYSTEM_PROPERTY_DELEGATEACTION_HANDLER_NAME = "DelegatingRequestProcessorEx.delegateActionHandler";

    /** ProcessMultipartHandler̃ftHgBean */
    protected static final String DEFAULT_PROCESSMULTIPART_HANDLER_NAME = "processMultipartHandler";

    /** ProcessActionFormHandler̃ftHgBean */
    protected static final String DEFAULT_PROCESSACTIONFORM_HANDLER_NAME = "processActionFormHandler";

    /** ProcessPopulateHandler̃ftHgBean */
    protected static final String DEFAULT_PROCESSPOPULATE_HANDLER_NAME = "processPopulateHandler";

    /** ProcessValidateHandler̃ftHgBean */
    protected static final String DEFAULT_PROCESSVALIDATE_HANDLER_NAME = "processValidateHandler";

    /** DelegateActionHandler̃ftHgBean */
    protected static final String DEFAULT_DELEGATEACTION_HANDLER_NAME = "delegateActionHandler";

    /** OnhOσtO */
    protected static final String EXCEPTION_HANDLED_FLAG = "EXCEPTION_HANDLED_FLAG";

    /** ProcessMultipartHandlerBean */
    protected String processMultipartHandlerName = DEFAULT_PROCESSMULTIPART_HANDLER_NAME;

    /** ProcessActionFormHandlerBean */
    protected String processActionFormHandlerName = DEFAULT_PROCESSACTIONFORM_HANDLER_NAME;

    /** ProcessPopulateHandlerBean */
    protected String processPopulateHandlerName = DEFAULT_PROCESSPOPULATE_HANDLER_NAME;

    /** ProcessValidateHandlerBean */
    protected String processValidateHandlerName = DEFAULT_PROCESSVALIDATE_HANDLER_NAME;

    /** DelegateActionHandlerBean */
    protected String delegateActionHandlerName = DEFAULT_DELEGATEACTION_HANDLER_NAME;

    /** ProcessMultipartHandler */
    protected ProcessMultipartHandler processMultipartHandler = null;

    /** ProcessActionFormHandler */
    protected ProcessActionFormHandler processActionFormHandler = null;

    /** ProcessPopulateHandler */
    protected ProcessPopulateHandler processPopulateHandler = null;

    /** ProcessValidateHandler */
    protected ProcessValidateHandler processValidateHandler = null;

    /** DelegateActionHandler */
    protected DelegateActionHandler delegateActionHandler = null;

    /*
     * (non-Javadoc)
     * @see org.springframework.web.struts.DelegatingRequestProcessor#init(org.apache.struts.action.ActionServlet,
     * org.apache.struts.config.ModuleConfig)
     */
    @Override
    public void init(ActionServlet actionServlet, ModuleConfig moduleConfig)
                                                                            throws ServletException {
        super.init(actionServlet, moduleConfig);

        initHandlerBeanName();
        initHandler();
    }

    /**
     * nh[Bean擾.
     */
    protected void initHandlerBeanName() {
        /** ProcessMultipartHandlerBeanύXۂ̃VXevpeB */
        String processMultipartHandlerNameProp = PropertyUtil.getProperty(
                SYSTEM_PROPERTY_PROCESSMULTIPART_HANDLER_NAME, null);
        if (processMultipartHandlerNameProp != null
                && processMultipartHandlerNameProp.length() != 0) {
            this.processMultipartHandlerName = processMultipartHandlerNameProp;
        }

        /** ProcessActionFormHandlerBeanύXۂ̃VXevpeB */
        String processActionFormHandlerNameProp = PropertyUtil.getProperty(
                SYSTEM_PROPERTY_PROCESSACTIONFORM_HANDLER_NAME, null);
        if (processActionFormHandlerNameProp != null
                && processActionFormHandlerNameProp.length() != 0) {
            this.processActionFormHandlerName = processActionFormHandlerNameProp;
        }

        /** ProcessPopulateHandlerBeanύXۂ̃VXevpeB */
        String processPopulateHandlerNameProp = PropertyUtil.getProperty(
                SYSTEM_PROPERTY_PROCESSPOPULATE_HANDLER_NAME, null);
        if (processPopulateHandlerNameProp != null
                && processPopulateHandlerNameProp.length() != 0) {
            this.processPopulateHandlerName = processPopulateHandlerNameProp;
        }

        /** ProcessValidateHandlerBeanύXۂ̃VXevpeB */
        String processValidateHandlerNameProp = PropertyUtil.getProperty(
                SYSTEM_PROPERTY_PROCESSVALIDATE_HANDLER_NAME, null);
        if (processValidateHandlerNameProp != null
                && processValidateHandlerNameProp.length() != 0) {
            this.processValidateHandlerName = processValidateHandlerNameProp;
        }

        /** DelegateActionHandlerBeanύXۂ̃VXevpeB */
        String delegateActionHandlerNameProp = PropertyUtil.getProperty(
                SYSTEM_PROPERTY_DELEGATEACTION_HANDLER_NAME, null);
        if (delegateActionHandlerNameProp != null
                && delegateActionHandlerNameProp.length() != 0) {
            this.delegateActionHandlerName = delegateActionHandlerNameProp;
        }
    }

    /**
     * nh[.
     */
    protected void initHandler() {
        // AvP[VReLXg擾
        WebApplicationContext wac = getWebApplicationContext();

        // ProcessMultipartHandler擾
        if (wac.containsBean(this.processMultipartHandlerName)) {
            Object pmhObj = wac.getBean(this.processMultipartHandlerName);
            if (pmhObj instanceof ProcessMultipartHandler) {
                this.processMultipartHandler = (ProcessMultipartHandler) pmhObj;
            }
        }

        // ProcessActionFormHandler擾
        if (wac.containsBean(this.processActionFormHandlerName)) {
            Object pafhObj = wac.getBean(this.processActionFormHandlerName);
            if (pafhObj instanceof ProcessActionFormHandler) {
                this.processActionFormHandler = (ProcessActionFormHandler) pafhObj;
            }
        }

        // ProcessPopulateHandler擾
        if (wac.containsBean(this.processPopulateHandlerName)) {
            Object pphObj = wac.getBean(this.processPopulateHandlerName);
            if (pphObj instanceof ProcessPopulateHandler) {
                this.processPopulateHandler = (ProcessPopulateHandler) pphObj;
            }
        }

        // ProcessValidateHandler擾
        if (wac.containsBean(this.processValidateHandlerName)) {
            Object pvhObj = wac.getBean(this.processValidateHandlerName);
            if (pvhObj instanceof ProcessValidateHandler) {
                this.processValidateHandler = (ProcessValidateHandler) pvhObj;
            }
        }

        // DelegateActionHandler擾
        if (wac.containsBean(this.delegateActionHandlerName)) {
            Object dahObj = wac.getBean(this.delegateActionHandlerName);
            if (dahObj instanceof DelegateActionHandler) {
                this.delegateActionHandler = (DelegateActionHandler) dahObj;
            }
        }

    }

    /*
     * (non-Javadoc)
     * @see org.apache.struts.action.RequestProcessor#processMultipart(javax.servlet.http.HttpServletRequest)
     */
    @Override
    protected HttpServletRequest processMultipart(HttpServletRequest request) {
        // ProcessMultipartHandlergp
        if (this.processMultipartHandler != null) {
            return this.processMultipartHandler
                    .processMultipart(request, this.moduleConfig, this.servlet,
                            getWebApplicationContext());
        }

        return super.processMultipart(request);
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.RequestProcessorEx#processActionForm(javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionMapping)
     */
    @Override
    protected ActionForm processActionForm(HttpServletRequest req,
            HttpServletResponse res, ActionMapping mapping) {
        ActionForm form = null;

        // ProcessActionFormHandlergp
        if (this.processActionFormHandler != null) {
            form = this.processActionFormHandler.processActionForm(req, res,
                    mapping, this.moduleConfig, this.servlet,
                    getWebApplicationContext());
        }

        if (form == null) {
            form = super.processActionForm(req, res, mapping);
        }

        // ZbVɕۑActionForm̃VACYΉ
        if (form != null) {
            form.setServlet(this.servlet);
        }
        return form;
    }

    /*
     * (non-Javadoc)
     * @see jp.terasoluna.fw.web.struts.action.RequestProcessorEx#processPopulate(javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionForm, org.apache.struts.action.ActionMapping)
     */
    @Override
    protected void processPopulate(HttpServletRequest req,
            HttpServletResponse res, ActionForm form, ActionMapping mapping)
                                                                            throws ServletException {
        boolean populateSuccess = false;

        try {
            // ProcessPopulateHandlergp
            if (this.processPopulateHandler != null) {
                populateSuccess = this.processPopulateHandler.processPopulate(
                        req, res, form, mapping, this.moduleConfig,
                        this.servlet, getWebApplicationContext());
            }

            if (!populateSuccess) {
                // X[p[NX processPopulate() \bhs
                super.processPopulate(req, res, form, mapping);
            }
        } catch (Exception e) {
            try {
                ActionForward forward = (processException(req, res, e, form,
                        mapping));
                processForwardConfig(req, res, forward);

                // OnhOσtO𗧂Ă
                req.setAttribute(EXCEPTION_HANDLED_FLAG, Boolean.TRUE
                        .toString());
            } catch (IOException ex) {
                if (log.isErrorEnabled()) {
                    log.error(ex.getMessage(), ex);
                }
                return;
            } catch (ServletException ex) {
                if (log.isErrorEnabled()) {
                    log.error(ex.getMessage(), ex);
                }
                return;
            }
        }
    }

    /*
     * (non-Javadoc)
     * @see org.apache.struts.action.RequestProcessor#processValidate(javax.servlet.http.HttpServletRequest,
     * javax.servlet.http.HttpServletResponse, org.apache.struts.action.ActionForm, org.apache.struts.action.ActionMapping)
     */
    @Override
    protected boolean processValidate(HttpServletRequest request,
            HttpServletResponse response, ActionForm form, ActionMapping mapping)
                                                                                 throws IOException,
                                                                                 ServletException,
                                                                                 InvalidCancelException {
        // OnhOσtO
        Object exceptionHandledFlagObj = request
                .getAttribute(EXCEPTION_HANDLED_FLAG);
        String exceptionHandledFlag = null;
        if (exceptionHandledFlagObj instanceof String) {
            exceptionHandledFlag = (String) exceptionHandledFlagObj;
        }
        if (exceptionHandledFlag != null
                && Boolean.TRUE.toString().equals(exceptionHandledFlag)) {
            return false;
        }

        // ProcessValidateHandlergp
        if (this.processValidateHandler != null) {
            return this.processValidateHandler.processValidate(request,
                    response, form, mapping, this.moduleConfig, this.servlet,
                    getWebApplicationContext());
        }

        return super.processValidate(request, response, form, mapping);
    }

    /*
     * (non-Javadoc)
     * @see org.springframework.web.struts.DelegatingRequestProcessor#getDelegateAction(org.apache.struts.action.ActionMapping)
     */
    @Override
    protected Action getDelegateAction(ActionMapping mapping)
                                                             throws BeansException {
        Action action = null;
        BeansException beansException = null;
        // BeaniANVpXj擾
        String beanName = determineActionBeanName(mapping);

        // X[p[NX̃\bhs
        try {
            action = super.getDelegateAction(mapping);
        } catch (BeansException e) {
            // OۑĂ
            beansException = e;
        }

        try {
            // DelegateActionHandlergp
            if (this.delegateActionHandler != null) {
                // X[p[NX̃\bhActionĂAȂĂDelegateActionHandlerɓn
                action = this.delegateActionHandler.resolveAction(beanName,
                        action, mapping, this.moduleConfig, this.servlet,
                        getWebApplicationContext());
            }
        } catch (BeansException e) {
            if (beansException == null) {
                // OۑĂ
                beansException = e;
            }
        } finally {
            // ActionłȂꍇ́AۑĂOX[
            if (action == null && beansException != null) {
                if (log.isDebugEnabled()) {
                    log.debug("It fails in the solution of the action.");
                }
                throw beansException;
            }
        }

        if (action != null) {
            // ActionServletݒ
            action.setServlet(this.servlet);
        }

        return action;
    }

    /**
     * ProcessMultipartHandlerBeanݒ肷B
     * @param processMultipartHandlerName the processMultipartHandlerName to set
     */
    public void setProcessMultipartHandlerName(
            String processMultipartHandlerName) {
        this.processMultipartHandlerName = processMultipartHandlerName;
    }

    /**
     * ProcessActionFormHandlerBeanݒ肷B
     * @param processActionFormHandlerName the processActionFormHandlerName to set
     */
    public void setProcessActionFormHandlerName(
            String processActionFormHandlerName) {
        this.processActionFormHandlerName = processActionFormHandlerName;
    }

    /**
     * ProcessPopulateHandlerBeanݒ肷B
     * @param processPopulateHandlerName the processPopulateHandlerName to set
     */
    public void setProcessPopulateHandlerName(String processPopulateHandlerName) {
        this.processPopulateHandlerName = processPopulateHandlerName;
    }

    /**
     * ProcessValidateHandlerBeanݒ肷B
     * @param processValidateHandlerName the processValidateHandlerName to set
     */
    public void setProcessValidateHandlerName(String processValidateHandlerName) {
        this.processValidateHandlerName = processValidateHandlerName;
    }

    /**
     * DelegateActionHandlerBeanݒ肷B
     * @param delegateActionHandlerName the delegateActionHandlerName to set
     */
    public void setDelegateActionHandlerName(String delegateActionHandlerName) {
        this.delegateActionHandlerName = delegateActionHandlerName;
    }

}
