/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.action.DBMessageBean;
import jp.terasoluna.fw.web.struts.action.DBMessageBeanMappingSqlQuery;
import jp.terasoluna.fw.web.struts.action.MessageResourcesDAO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageResourcesDAOImpl
implements MessageResourcesDAO {
    public static final String BEANS_XML = "dbMessageResources.xml";
    private static final String DATASOURCE_BEAN_ID = "dataSource";
    private static final String MESSAGE_RESOURCES_DAO_IMPL_ERROR = "errors.message.resources.dao.impl";
    private static Log log = LogFactory.getLog(MessageResourcesDAOImpl.class);

    @Override
    public Map<String, String> queryMessageMap(String sql) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"call queryMessageMap()");
        }
        ClassPathXmlApplicationContext context = null;
        try {
            context = new ClassPathXmlApplicationContext(this.getBeansXml());
        }
        catch (BeansException e) {
            log.error((Object)(this.getBeansXml() + " not found or not -//SPRING//DTD BEAN//EN or invalid or anything else."), (Throwable)e);
            throw new SystemException((Throwable)e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        DataSource ds = null;
        try {
            ds = (DataSource)context.getBean(DATASOURCE_BEAN_ID);
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error((Object)"\"dataSource\" not defined.", (Throwable)e);
            throw new SystemException((Throwable)e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        catch (ClassCastException e) {
            log.error((Object)"\"dataSource\" not implemented DataSource.", (Throwable)e);
            throw new SystemException((Throwable)e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        catch (BeansException e) {
            log.error((Object)"getBean() failed", (Throwable)e);
            throw new SystemException((Throwable)e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        DBMessageBeanMappingSqlQuery query = new DBMessageBeanMappingSqlQuery(ds, sql);
        try {
            query.compile();
        }
        catch (InvalidDataAccessApiUsageException e) {
            log.error((Object)"SQL is null or something wrong.", (Throwable)e);
            throw new SystemException((Throwable)e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        List dbMessageList = null;
        try {
            dbMessageList = query.execute();
        }
        catch (DataAccessException e) {
            log.error((Object)"Data access exception.", (Throwable)e);
            throw new SystemException((Throwable)e, MESSAGE_RESOURCES_DAO_IMPL_ERROR);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"db message acquired");
        }
        HashMap<String, String> dbMessages = new HashMap<String, String>(dbMessageList.size());
        Iterator iterator = dbMessageList.iterator();
        DBMessageBean dbmb = null;
        while (iterator.hasNext()) {
            dbmb = (DBMessageBean)iterator.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving db message key [" + dbmb.getKey() + "], value [" + dbmb.getValue() + "]"));
            }
            dbMessages.put(dbmb.getKey(), dbmb.getValue());
        }
        return dbMessages;
    }

    protected String getBeansXml() {
        return BEANS_XML;
    }
}

