/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.struts.action;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.util.MessageResources;
import org.apache.struts.util.MessageResourcesFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlobalMessageResources
extends MessageResources {
    private static final long serialVersionUID = -1224092114113256826L;
    private static Log log = LogFactory.getLog(GlobalMessageResources.class);
    private Map<String, String> fwMessages = new HashMap<String, String>();
    private Map<String, String> globalMessages = new HashMap<String, String>();
    private static final String SYSTEM_MESSAGE = "system-messages";
    private static final String DEFAULT_APPLICATION_MESSAGE = "application-messages";
    private static final String APPLICATION_CONFIG_KEY = "application.messages";
    private static final String ADD_MESSAGES_FILE = "add.message.file.";
    private static GlobalMessageResources globalMessageResources = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalMessageResources getInstance() {
        if (globalMessageResources != null) return globalMessageResources;
        Class<GlobalMessageResources> clazz = GlobalMessageResources.class;
        synchronized (GlobalMessageResources.class) {
            GlobalMessageResources createdResources;
            globalMessageResources = createdResources = new GlobalMessageResources(null, SYSTEM_MESSAGE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return globalMessageResources;
        }
    }

    private GlobalMessageResources(MessageResourcesFactory factory, String config) {
        super(factory, config);
        this.globalInit();
        this.applicationInit();
    }

    private synchronized void globalInit() {
        this.fwMessages.clear();
        Properties prop = PropertyUtil.loadProperties((String)this.config);
        if (prop == null) {
            return;
        }
        Enumeration<?> keyEnum = prop.propertyNames();
        while (keyEnum.hasMoreElements()) {
            Object keyObj = keyEnum.nextElement();
            Object value = prop.get(keyObj);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving framework message key [" + keyObj + "]value [" + value + "]"));
            }
            this.fwMessages.put((String)keyObj, (String)value);
        }
    }

    private synchronized void applicationInit() {
        Properties prop;
        String appKey = PropertyUtil.getProperty((String)APPLICATION_CONFIG_KEY);
        if (appKey == null) {
            appKey = DEFAULT_APPLICATION_MESSAGE;
        }
        if ((prop = PropertyUtil.loadProperties((String)appKey)) == null) {
            return;
        }
        Map<String, String> rootAppricationMap = this.getRootApplicationMap(prop);
        Map<String, String> addApplicationMap = this.getAddApplicationMap(prop, appKey);
        addApplicationMap.putAll(rootAppricationMap);
        this.globalMessages = addApplicationMap;
    }

    private Map<String, String> getRootApplicationMap(Properties prop) {
        HashMap<String, String> rootApplicationMap = new HashMap<String, String>();
        for (String string : prop.keySet()) {
            if (string.startsWith(ADD_MESSAGES_FILE)) continue;
            String value = prop.getProperty(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving root-application message key [" + string + "]value [" + value + "]"));
            }
            rootApplicationMap.put(string, value);
        }
        return rootApplicationMap;
    }

    private Map<String, String> getAddApplicationMap(Properties prop, String rootProperty) {
        String fileName;
        HashMap<String, String> addApplicationMap = new HashMap<String, String>();
        ArrayList<String> fileNameList = new ArrayList<String>();
        int i = 1;
        while ((fileName = prop.getProperty(ADD_MESSAGES_FILE + i)) != null && !fileName.equals(rootProperty)) {
            fileNameList.add(fileName);
            ++i;
        }
        for (String outerFileName : fileNameList) {
            Properties outerProp = PropertyUtil.loadProperties((String)outerFileName);
            if (outerProp == null) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("\"" + outerFileName + "\" is illegal."));
                continue;
            }
            for (String string : outerProp.keySet()) {
                String outerValue = outerProp.getProperty(string);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Saving outer-file-application message key [" + string + "]value [" + outerValue + "]"));
                }
                addApplicationMap.put(string, outerValue);
            }
        }
        return addApplicationMap;
    }

    public String getMessage(Locale locale, String key) {
        if (key == null) {
            return null;
        }
        String globalMsg = this.globalMessages.get(key);
        if (globalMsg != null) {
            return globalMsg;
        }
        return this.fwMessages.get(key);
    }
}

