/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.ex.aop.log;

import java.util.List;
import jp.terasoluna.fw.service.thin.BLogicResult;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BLogicLogInterceptor
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(BLogicLogInterceptor.class);
    private List<Class> noErrorLogExceptionLists = null;

    public void setNoErrorLogExceptionLists(List<Class> noErrorLogExceptionLists) {
        this.noErrorLogExceptionLists = noErrorLogExceptionLists;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Class<?> blogicClass = null;
        if (logger.isDebugEnabled()) {
            blogicClass = invocation.getThis().getClass();
            logger.debug((Object)blogicClass.getSimpleName().concat(" is being executed..."));
            logger.debug((Object)this.createParamsInfo(invocation.getArguments()));
        }
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (Throwable e) {
            if (this.checkException(e)) {
                logger.error((Object)e);
                throw e;
            }
            logger.debug((Object)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)this.createResultInfo(result));
            logger.debug((Object)blogicClass.getSimpleName().concat(" was executed completely."));
        }
        return result;
    }

    private String createParamsInfo(Object[] args) {
        StringBuilder info = new StringBuilder("Params:");
        if (args == null) {
            info.append("null");
        } else {
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) {
                    info.append("null");
                } else {
                    info.append(args[i].toString());
                }
                if (i == args.length - 1) continue;
                info.append(",");
            }
        }
        return info.toString();
    }

    private String createResultInfo(Object result) {
        StringBuilder info = new StringBuilder("Result:");
        if (result == null) {
            info.append("null");
        } else if (result instanceof BLogicResult) {
            BLogicResult blogicResult = (BLogicResult)result;
            info.append("resultString=").append(blogicResult.getResultString());
            info.append(",resultObject=");
            if (blogicResult.getResultObject() == null) {
                info.append("null");
            } else {
                info.append(blogicResult.getResultObject().toString());
            }
        } else {
            info.append(result.toString());
        }
        return info.toString();
    }

    protected boolean checkException(Throwable target) {
        if (this.noErrorLogExceptionLists != null) {
            for (Class noCheckException : this.noErrorLogExceptionLists) {
                if (!noCheckException.isAssignableFrom(target.getClass())) continue;
                return false;
            }
        }
        return true;
    }
}

