/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.examples.mailreader.memory;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.ObjectCreationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.examples.mailreader.ExpiredPasswordException;
import org.apache.struts.examples.mailreader.Subscription;
import org.apache.struts.examples.mailreader.User;
import org.apache.struts.examples.mailreader.UserDatabase;
import org.apache.struts.examples.mailreader.memory.MemorySubscriptionCreationFactory;
import org.apache.struts.examples.mailreader.memory.MemoryUser;
import org.apache.struts.examples.mailreader.memory.MemoryUserCreationFactory;

public class MemoryUserDatabase
implements UserDatabase {
    private Log log = LogFactory.getLog(this.getClass());
    private HashMap users = new HashMap();
    private String pathname = null;
    private String pathnameOld = null;
    private String pathnameNew = null;

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String pathname) {
        this.pathname = pathname;
        this.pathnameOld = pathname + ".old";
        this.pathnameNew = pathname + ".new";
    }

    public void close() throws Exception {
        this.save();
    }

    public User createUser(String username) {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            if (this.users.get(username) != null) {
                throw new IllegalArgumentException("Duplicate user '" + username + "'");
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Creating user '" + username + "'"));
            }
            MemoryUser user = new MemoryUser(this, username);
            HashMap hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.put(username, user);
            }
            MemoryUser memoryUser = user;
            return memoryUser;
        }
    }

    public User findUser(String username) throws ExpiredPasswordException {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            User user = (User)this.users.get(username);
            return user;
        }
    }

    public User[] findUsers() {
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            User[] results = new User[this.users.size()];
            User[] userArray = this.users.values().toArray(results);
            return userArray;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void open() throws Exception {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Loading database from '" + this.pathname + "'"));
                }
                fis = new FileInputStream(this.pathname);
                bis = new BufferedInputStream(fis);
                Digester digester = new Digester();
                digester.push((Object)this);
                digester.setValidating(false);
                digester.addFactoryCreate("database/user", (ObjectCreationFactory)new MemoryUserCreationFactory(this));
                digester.addFactoryCreate("database/user/subscription", (ObjectCreationFactory)new MemorySubscriptionCreationFactory());
                digester.parse((InputStream)bis);
                bis.close();
                return;
            }
            catch (Exception e) {
                this.log.error((Object)("Loading database from '" + this.pathname + "':"), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (bis == null) throw throwable;
            try {
                bis.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            bis = null;
            fis = null;
            throw throwable;
        }
    }

    public void removeUser(User user) {
        if (this != user.getDatabase()) {
            throw new IllegalArgumentException("User not associated with this database");
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing user '" + user.getUsername() + "'"));
        }
        HashMap hashMap = this.users;
        synchronized (hashMap) {
            this.users.remove(user.getUsername());
        }
    }

    public void save() throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving database to '" + this.pathname + "'"));
        }
        File fileNew = new File(this.pathnameNew);
        PrintWriter writer = null;
        try {
            FileOutputStream fos = new FileOutputStream(fileNew);
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            writer = new PrintWriter(osw);
            writer.println("<?xml version='1.0'?>");
            writer.println("<database>");
            User[] users = this.findUsers();
            int i = 0;
            while (i < users.length) {
                writer.print("  ");
                writer.println(users[i]);
                Subscription[] subscriptions = users[i].getSubscriptions();
                int j = 0;
                while (j < subscriptions.length) {
                    writer.print("    ");
                    writer.println(subscriptions[j]);
                    writer.print("    ");
                    writer.println("</subscription>");
                    ++j;
                }
                writer.print("  ");
                writer.println("</user>");
                ++i;
            }
            writer.println("</database>");
            if (writer.checkError()) {
                writer.close();
                fileNew.delete();
                throw new IOException("Saving database to '" + this.pathname + "'");
            }
            writer.close();
            writer = null;
        }
        catch (IOException e) {
            if (writer != null) {
                writer.close();
            }
            fileNew.delete();
            throw e;
        }
        File fileOrig = new File(this.pathname);
        File fileOld = new File(this.pathnameOld);
        if (fileOrig.exists()) {
            fileOld.delete();
            if (!fileOrig.renameTo(fileOld)) {
                throw new IOException("Renaming '" + this.pathname + "' to '" + this.pathnameOld + "'");
            }
        }
        if (!fileNew.renameTo(fileOrig)) {
            if (fileOld.exists()) {
                fileOld.renameTo(fileOrig);
            }
            throw new IOException("Renaming '" + this.pathnameNew + "' to '" + this.pathname + "'");
        }
        fileOld.delete();
    }
}

