/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.util.StringUtil;
import jp.terasoluna.fw.web.RequestUtil;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * gq`FbNsB
 *
 * <p>
 * w肳ꂽ֎~gqpXւ̃ANZXvɑ΂ẮA
 * SC_NOT_FOUND(404)G[ԂBɂAt@C
 * ւ̒ڃANZX֎~B<br>
 * ֎~gqւ̃ANZXsꍇł̃`FbNΏۂ͂
 * ʂȃpX΁AvpeBt@CrestrictionEscape.
 * ƂvtBNXL[ƂĒ`邱ƂŃ`FbNΏۂ
 * pX1畡`łB<br>
 * ܂AڃANZX֎~Ώۂ̊gq
 * access.control.prohibited.extension. ƂvtBNXL[
 * 1w肷邱ƁB
 * </p>
 *
 * <h5>vpeBt@Cݒ</h5>
 * <p>
 * <code><pre>
 * # gq`FbNΏۊOɂpX1珇Ɏw肷B
 * restrictionEscape.1=/sample/logon/index.jsp
 * restrictionEscape.2=/sample/error/error.jsp
 *
 * # gqƂ̒ڃANZX`FbNΏۂ̊gq1珇Ɏw肷B
 * access.control.prohibited.extension.1=.jsp
 * access.control.prohibited.extension.2=.csv
 * access.control.prohibited.extension.3=.pdf
 * </pre></code>
 * </p>
 * <h5>gp@</h5>
 * <p>
 * ̋@\gpɂ fvCgfBXNv^iweb.xmlj
 * ȉ̂悤ɐݒ肷B<br>
 * <br>
 * <code><pre>
 * &lt;filter&gt;
 *   &lt;filter-name&gt;extensionFilter&lt;/filter-name&gt;
 *   &lt;filter-class&gt;
 *     jp.terasoluna.fw.web.thin.ExtensionFilter
 *   &lt;/filter-class&gt;
 * &lt;/filter&gt;
 *
 * &lt;filter-mapping&gt;
 *   &lt;filter-name&gt;extensionFilter&lt;/filter-name&gt;
 *   &lt;url-pattern&gt;/*&lt;/url-pattern&gt;
 * &lt;/filter-mapping&gt;
 * </pre></code>
 * </p>
 */
public class ExtensionFilter implements Filter {

    /**
     * NGXgtB^ʉ߂ƂNGXg̃L[B
     */
    public static final String EXTENSION_THRU_KEY = "EXTENSION_THRU_KEY";

    /**
     * ApplicationResource擾Agq`FbNΏۊOɂ
     * pX̃L[ɂvtBbNXB
     */
    public static final String RESTRICTION_ESCAPE_PREFIX = "restrictionEscape.";

    /**
     * ONXB
     */
    private static Log log
        = LogFactory.getLog(ExtensionFilter.class);

    /**
     * ApplicationResource擾AڃANZX֎~gq
     * L[ɂvtBNXB
     */
    private static final String PROHIBITED_EXTENSION_PREFIX 
        = "access.control.prohibited.extension.";

    /**
     * WebuEU̒ڃANZX֎~gq̃XgB
     */
    private List<String> prohibitedExtensionList
        = new ArrayList<String>();

    /**
     * gq`FbN̑ΏۊOƂȂpX̃XgB
     */
    private List<String> restrictionEscapePaths
        = new ArrayList<String>();

    /**
     * tB^T[rXJnԂɂȂۂɁAReiɂČĂяoB
     *  
     * ReíAFilterCX^XɁAinit \bh
     * 1 񂾂ĂяoB<br>
     * FilterɃtB^Ƃs悤ɗvɂ́A
     * init \bh IĂȂ΂ȂȂB
     * init\bh ̂ꂩ̏Ԃ̏ꍇARei
     * FilterT[rXԂɂłȂB<br>
     * <ul>
     *  <li>ServletException X[B </li>
     *  <li>ReiɂĒ`ꂽԓɁAAȂB</li>
     * </ul>
     * 
     * @param config FilterConfigCX^XB
     * 
     * @throws javax.servlet.ServletException ُ펞ɃX[OB
     *             
     * @see javax.servlet.Filter#init(javax.servlet.FilterConfig)
     */
    public void init(FilterConfig config) throws ServletException {

        //ڃANZX֎~gq̃Xg擾B
        for (int i = 1;; i++) {
            String extension 
                = PropertyUtil.getProperty(PROHIBITED_EXTENSION_PREFIX + i);
            
            // ڃANZX֎~gqȂ΁A邢͐r؂ΏI
            if (extension == null) {
                break;
            }
            // gq.Ŏn܂ĂȂƂ.t
            if (!extension.startsWith(".")) {
                extension = "." + extension;
            }
            if (log.isDebugEnabled()) {
                log.debug("prohibitedExtension:" + extension);
            }
            prohibitedExtensionList.add(extension);
        }
        //ڃANZX֎~sȂpX擾B
        for (int i = 1;; i++) {
            String extensionCheckEscapePath 
                = PropertyUtil.getProperty(RESTRICTION_ESCAPE_PREFIX + i);
            
            // ڃANZX`FbNȂpXȂA
            // 邢͐r؂ΏI
            if (extensionCheckEscapePath == null) {
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug("extensionCheckEscapePath:["
                          + extensionCheckEscapePath + "]");
            }
            restrictionEscapePaths.add(extensionCheckEscapePath);
        }
    }


    /**
     * gq`FbNsB
     *
     * @param req HTTPNGXg
     * @param res HTTPX|X
     * @param chain tB^`F[
     * 
     * @throws IOException I/OG[
     * @throws ServletException T[ubgO
     * 
     * @see javax.servlet.Filter#doFilter(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.FilterChain)
     */
    public void doFilter(ServletRequest req,
                         ServletResponse res,
                         FilterChain chain)
            throws IOException, ServletException {

        //NGXgtB^ʉ߂ǂ𔻒B
        if (req.getAttribute(EXTENSION_THRU_KEY) == null) {

            //tB^̒ʉߏZbg
            req.setAttribute(EXTENSION_THRU_KEY, "true");

            //NGXgpXgq`FbNsȂpXXg
            //vĂꍇ͏I
            String pathInfo = RequestUtil.getPathInfo(req);
            if (pathInfo != null
                && !restrictionEscapePaths.contains(pathInfo)) {

                //gq`FbNs
                //NGXgpX̊gq擾B
                String extension = StringUtil.getExtension(pathInfo);
                if (prohibitedExtensionList.contains(extension)) {

                    if (log.isDebugEnabled()) {
                        log.debug("requestURI[" + pathInfo
                                  + "] has prohibited extension");
                    }

                    // HTTPG[404Ԃ
                    ((HttpServletResponse) res)
                    .sendError(HttpServletResponse.SC_NOT_FOUND);
                    return; // ȍ~͎sȂ
                }
            }
        }

        // ̃tB^܂̓T[ubg
        chain.doFilter(req, res);
    }

    /**
     * tB^ɌĂяoB<br>
     * ̃NXł͏͍sȂȂB
     * 
     * @see javax.servlet.Filter#destroy()
     */
    public void destroy() {
        // ɂȂ
    }

}
