/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.codelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import jp.terasoluna.fw.web.codelist.AbstractMultilingualCodeListLoader;
import jp.terasoluna.fw.web.codelist.CodeBean;
import jp.terasoluna.fw.web.codelist.DBCodeListQuery;
import jp.terasoluna.fw.web.codelist.LocaleCodeBean;
import jp.terasoluna.fw.web.codelist.ReloadableCodeListLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBCodeListLoader
extends AbstractMultilingualCodeListLoader
implements ReloadableCodeListLoader {
    private Log log = LogFactory.getLog(DBCodeListLoader.class);
    private String sql = null;
    private DataSource dataSource = null;
    private final Object lockObject = new Object();

    public void load() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"load() called.");
        }
        if (this.localeMap != null) {
            return;
        }
        this.loadCodeList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"reload() called.");
        }
        if (this.localeMap == null) {
            this.loadCodeList();
        } else {
            Object object = this.lockObject;
            synchronized (object) {
                this.loadCodeList();
            }
        }
    }

    protected void loadCodeList() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"loadCodeList() called.");
        }
        HashMap<Locale, List<CodeBean>> resultMap = new HashMap<Locale, List<CodeBean>>();
        DBCodeListQuery query = new DBCodeListQuery(this.dataSource, this.sql);
        query.compile();
        List resultList = query.execute();
        for (LocaleCodeBean localeCodeBean : resultList) {
            ArrayList<CodeBean> codeList;
            CodeBean cb = new CodeBean();
            cb.setId(localeCodeBean.getId());
            cb.setName(localeCodeBean.getName());
            Locale curLocale = this.createLocale(localeCodeBean);
            if (curLocale == null) {
                curLocale = this.defaultLocale;
            }
            if ((codeList = (ArrayList<CodeBean>)resultMap.get(curLocale)) == null) {
                codeList = new ArrayList<CodeBean>();
            }
            codeList.add(cb);
            resultMap.put(curLocale, codeList);
        }
        for (Map.Entry entry : resultMap.entrySet()) {
            resultMap.put((Locale)entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        this.localeMap = Collections.unmodifiableMap(resultMap);
    }

    Locale createLocale(LocaleCodeBean bean) {
        return this.createLocale(bean.getLanguage(), bean.getCountry(), bean.getVariant());
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

