/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action.handler;

import static org.junit.Assert.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.terasoluna.fw.web.struts.action.MockWebApplicationContext;
import jp.terasoluna.fw.web.struts.actions.ForwardAction;

import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.validator.ValidatorForm;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.springframework.web.context.WebApplicationContext;

/**
 * @author bthashidumets
 */
public class DefaultProcessActionFormHandlerTest {

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : false</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction001() throws Exception {
        DefaultProcessActionFormHandler handler = new DefaultProcessActionFormHandler();

        // p[^
        HttpServletRequest req = null;
        HttpServletResponse res = null;
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // eXg
        ActionForm result = handler.processActionForm(req, res, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNull(result);
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : null</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : false</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction002() throws Exception {
        DefaultProcessActionFormHandler handler = new DefaultProcessActionFormHandler();

        // p[^
        HttpServletRequest req = null;
        HttpServletResponse res = null;
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        WebApplicationContext wac = null;

        // eXg
        ActionForm result = handler.processActionForm(req, res, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNull(result);
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>form : null</li>
     * <li>actionName : "hoge"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ProcessPopulator.class) : new ProcessPopulator(),
     * <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : true</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction003() throws Exception {
        DefaultProcessActionFormHandler handler = new DefaultProcessActionFormHandler();

        // p[^
        HttpServletRequest req = null;
        HttpServletResponse res = null;
        String actionName = "hoge";
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        ProcessActionForm pp = new ProcessActionForm() {
            public ActionForm processActionForm(HttpServletRequest req,
                    HttpServletResponse res, ActionMapping mapping,
                    ActionServlet servlet, WebApplicationContext wac) {
                return new ValidatorForm();
            }

            public boolean supports(HttpServletRequest req,
                    HttpServletResponse res, ActionMapping mapping,
                    ActionServlet servlet, WebApplicationContext wac) {
                return true;
            }

            public int getOrder() {
                return 0;
            }
        };
        wac.addBeansOfTypeMap("processActionForm", pp);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, new ForwardAction());

        // eXg
        ActionForm result = handler.processActionForm(req, res, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNotNull(result);
    }

    /**
     * resolveAction\bh<br>
     * <p>
     * (n)
     * </p>
     * <p>
     * ϓ_F \bhQsALbVProcessActionForm邱ƁB<br>
     * </p>
     * <p>
     * ͒lF<br>
     * <li>req : null</li>
     * <li>res : null</li>
     * <li>form : null</li>
     * <li>actionName : "hoge"</li>
     * <li>mapping : null</li>
     * <li>servlet : null</li>
     * <li>applicationContext : new MockWebApplicationContext( getBeansOfType(ProcessActionForm.class) : new
     * ProcessActionForm(), <br>
     * containsBean(actionName) : Boolean.TRUE, <br>
     * getBean(actionName) : new ForwardAction(), <br>
     * )</li>
     * </p>
     * <br>
     * <p>
     * ҒlF<br>
     * <li>return : true</li>
     * <li>return : true</li>
     * </p>
     * @throws Exception
     */
    @Test
    public void testResolveAction004() throws Exception {
        DefaultProcessActionFormHandler handler = new DefaultProcessActionFormHandler();

        // p[^
        HttpServletRequest req = null;
        HttpServletResponse res = null;
        String actionName = "hoge";
        ActionMapping mapping = null;
        ModuleConfig moduleConfig = null;
        ActionServlet servlet = null;
        MockWebApplicationContext wac = new MockWebApplicationContext();
        ProcessActionForm pp = new ProcessActionForm() {

            public ActionForm processActionForm(HttpServletRequest req,
                    HttpServletResponse res, ActionMapping mapping,
                    ActionServlet servlet, WebApplicationContext wac) {
                return new ValidatorForm();
            }

            public boolean supports(HttpServletRequest req,
                    HttpServletResponse res, ActionMapping mapping,
                    ActionServlet servlet, WebApplicationContext wac) {
                return true;
            }

            public int getOrder() {
                return 0;
            }
        };
        wac.addBeansOfTypeMap("processActionForm", pp);
        wac.addContainsBeanMap(actionName, Boolean.TRUE);
        wac.addBeanMap(actionName, new ForwardAction());

        // eXg
        ActionForm result = handler.processActionForm(req, res, mapping,
                moduleConfig, servlet, wac);
        ActionForm result2 = handler.processActionForm(req, res, mapping,
                moduleConfig, servlet, wac);

        // 
        assertNotNull(result);
        assertNotNull(result2);
    }

}
