/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.jndi;


import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.naming.Context;
import javax.naming.NamingException;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;
/**
 * {@link jp.terasoluna.fw.web.jndi.DefaultJndiSupport}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA񋟂JNDI֘Ã[eBeBftHgNXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.jndi.DefaultJndiSupport
 */
public class DefaultJndiSupportTest extends TestCase {


    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    @Override
    protected void tearDown() throws Exception {

        super.tearDown();
    }

    /**
     * testSetJndiPrefix01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() super.resourceRef:true<br>
     *         () super.resourceRef:false<br>
     *
     * <br>
     * ҒlF(ԕω) super.resourceRef:true<br>
     *
     * <br>
     * Ɏw肵lX[p[NXresourceRefɐɊi[邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetJndiPrefix01() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();
        support.setResourceRef(false);

        // eXg{
        support.setJndiPrefix(true);

        // 
        // X[p[NX̃\bhĂяo
        boolean b = support.isResourceRef();
        assertTrue(b);
    }

    /**
     * testIsJndiPrefix01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() super.resourceRef:true<br>
     *
     * <br>
     * ҒlF(߂l) super.resourceRef:true<br>
     *
     * <br>
     * DefaultJndiSupportɊi[Ăsuper.resourceRef𐳏Ɏ擾
     * ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsJndiPrefix01() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();
        // X[p[NX̃\bhőOݒ
        support.setResourceRef(true);

        // eXg{
        boolean b = support.isJndiPrefix();

        // 
        assertTrue(b);
    }
    
    /**
     * testGetJndiEnvironmentMap01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() jndiEnvironmentMap:not null<br>
     *
     * <br>
     * ҒlF(߂l) Map:CX^XϐjndiEnvironmentMap<br>
     *
     * <br>
     * CX^XϐjndiEnvironmentMap擾ł邱ƂmFB<br>
     * n1̂݊mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetJndiEnvironmentMap01() throws Exception {
        
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();
        Map map = new HashMap();
        
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", map);
        
        // eXg{
        Object result = support.getJndiEnvironmentMap();

        // 蔻
        assertSame(map, result);
    }
    
    /**
     * testSetJndiEnvironmentMap01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() jndiEnvironmentMap:not null<br>
     *         () jndiEnvironmentMap:null<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:not nulliɎw肵Mapj<br>
     *
     * <br>
     * Ɏw肵MapCX^XϐjndiEnvironmentMapɐݒ肳邱ƂmFB<br>
     * n1̂݊mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetJndiEnvironmentMap01() throws Exception {
        
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();
        Map<String, String> map = new HashMap<String, String>();
        
        // eXg{
        support.setJndiEnvironmentMap(map);
        
        // 蔻
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertSame(map, result);
    }

    /**
     * testInitialize01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() jndiEnvironmentMap:null<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:null<br>
     * <br>
     * jndiEnvironmentMapnullꍇAJndiTemplate̊vpeB͐ݒ肳ȂƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize01() throws Exception {

        // O
        DefaultJndiSupport support = new DefaultJndiSupport();
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", null);
        
        // eXg{
        support.initialize();
        
        // 
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertNull(result);
    }

    /**
     * testInitialize02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() jndiEnvironmentMap.get("factory")F"factory"<br>
     *         () jndiEnvironmentMap.get("url")F"url"<br>
     *         () jndiEnvironmentMap.get("username")Fnull<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:not null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.INITIAL_CONTEXT_FACTORY):"factory"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.PROVIDER_URL):"url"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_PRINCIPAL):null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_CREDENTIALS):null<br>
     *         (ԕω) O:O<br>
     *                    CtHOF<br>
     *                    "java.naming.factory.initial = factory"<br>
     *                    "java.naming.provider.url = url"<br>
     *                    "java.naming.security.principal = null"<br>
     *                    "java.naming.security.credentials = null"<br>
     *
     * <br>
     * jndiEnvironmentMap.get("username")nullꍇA
     * JndiTemplate̊vpeBjndiFactoryjndiUrlݒ肳Ă邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize02() throws Exception {
        // O
        Map<String, String> map = new HashMap<String, String>();
        map.put("factory", "factory");
        map.put("url", "url");
        
        DefaultJndiSupport support = new DefaultJndiSupport();
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", map);

        // eXg{
        support.initialize();
        
        // 
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertSame(map, result);
        
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.factory.initial = factory"));
        assertTrue(LogUTUtil.checkInfo("java.naming.provider.url = url"));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.principal = null"));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.credentials = null"));

        Properties props = support.getJndiEnvironment();
        assertEquals("factory", props.get(Context.INITIAL_CONTEXT_FACTORY));
        assertEquals("url", props.get(Context.PROVIDER_URL));
        assertNull(props.get(Context.SECURITY_PRINCIPAL));
        assertNull(props.get(Context.SECURITY_CREDENTIALS));
    }

    /**
     * testInitialize03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() jndiEnvironmentMap.get("factory")F"factory"<br>
     *         () jndiEnvironmentMap.get("url")F"url"<br>
     *         () jndiEnvironmentMap.get("username")F""<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:not null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.INITIAL_CONTEXT_FACTORY):"factory"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.PROVIDER_URL):"url"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_PRINCIPAL):null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_CREDENTIALS):null<br>
     *         (ԕω) O:O<br>
     *                    CtHOF<br>
     *                    "java.naming.factory.initial = factory"<br>
     *                    "java.naming.provider.url = url"<br>
     *                    "java.naming.security.principal = "<br>
     *                    "java.naming.security.credentials = null"<br>
     *
     * <br>
     * jndiEnvironmentMap.get("username")󕶎ꍇAJndiTemplate̊
     * vpeBjndiFactoryjndiUrlݒ肳Ă邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize03() throws Exception {
        
        // O
        Map<String, String> map = new HashMap<String, String>();
        map.put("factory", "factory");
        map.put("url", "url");
        map.put("username", "");
        
        DefaultJndiSupport support = new DefaultJndiSupport();
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", map);

        // eXg{
        support.initialize();
        
        // 
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertSame(map, result);
        
        assertTrue(LogUTUtil.checkInfo("java.naming.factory.initial = factory"));
        assertTrue(LogUTUtil.checkInfo("java.naming.provider.url = url"));
        assertTrue(LogUTUtil.checkInfo("java.naming.security.principal = "));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.credentials = null"));

        Properties props = support.getJndiEnvironment();
        assertEquals("factory", props.get(Context.INITIAL_CONTEXT_FACTORY));
        assertEquals("url", props.get(Context.PROVIDER_URL));
        assertNull(props.get(Context.SECURITY_PRINCIPAL));
        assertNull(props.get(Context.SECURITY_CREDENTIALS));
    }

    /**
     * testInitialize04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() jndiEnvironmentMap.get("factory")F"factory"<br>
     *         () jndiEnvironmentMap.get("url")F"url"<br>
     *         () jndiEnvironmentMap.get("username")F"username"<br>
     *         () jndiEnvironmentMap.get("password")Fnull<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:not null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.INITIAL_CONTEXT_FACTORY):"factory"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.PROVIDER_URL):"url"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_PRINCIPAL):"username"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_CREDENTIALS):""<br>
     *         (ԕω) O:O<br>
     *                    CtHOF<br>
     *                    "java.naming.factory.initial = factory"<br>
     *                    "java.naming.provider.url = url"<br>
     *                    "java.naming.security.principal = username"<br>
     *                    "java.naming.security.credentials = "<br>
     *
     * <br>
     * jndiEnvironmentMap.get("password")nullꍇAJndiTemplate̊
     * vpeBjndiFactoryjndiUrljndiUsernameƋ󕶎jndiPasswordݒ肳Ă邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize04() throws Exception {
        // O
        Map<String, String> map = new HashMap<String, String>();
        map.put("factory", "factory");
        map.put("url", "url");
        map.put("username", "username");
        
        DefaultJndiSupport support = new DefaultJndiSupport();
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", map);

        // eXg{
        support.initialize();
        
        // 
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertSame(map, result);
        
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.factory.initial = factory"));
        assertTrue(LogUTUtil.checkInfo("java.naming.provider.url = url"));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.principal = username"));
        assertTrue(LogUTUtil.checkInfo("java.naming.security.credentials = "));

        Properties props = support.getJndiEnvironment();
        assertEquals("factory", props.get(Context.INITIAL_CONTEXT_FACTORY));
        assertEquals("url", props.get(Context.PROVIDER_URL));
        assertEquals("username", props.get(Context.SECURITY_PRINCIPAL));
        assertEquals("", props.get(Context.SECURITY_CREDENTIALS));
    }

    /**
     * testInitialize05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() jndiEnvironmentMap.get("factory")F"factory"<br>
     *         () jndiEnvironmentMap.get("url")F"url"<br>
     *         () jndiEnvironmentMap.get("username")F"username"<br>
     *         () jndiEnvironmentMap.get("password")F""<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:not null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.INITIAL_CONTEXT_FACTORY):"factory"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.PROVIDER_URL):"url"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_PRINCIPAL):"username"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_CREDENTIALS):""<br>
     *         (ԕω) O:O<br>
     *                    CtHOF<br>
     *                    "java.naming.factory.initial = factory"<br>
     *                    "java.naming.provider.url = url"<br>
     *                    "java.naming.security.principal = username"<br>
     *                    "java.naming.security.credentials = "<br>
     *
     * <br>
     * jndiEnvironmentMap.get("password")󕶎ꍇAJndiTemplate̊
     * vpeBjndiFactoryjndiUrljndiUsernamejndiPasswordݒ肳Ă邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize05() throws Exception {
        // O
        Map<String, String> map = new HashMap<String, String>();
        map.put("factory", "factory");
        map.put("url", "url");
        map.put("username", "username");
        map.put("password", "");
        
        DefaultJndiSupport support = new DefaultJndiSupport();
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", map);

        // eXg{
        support.initialize();
        
        // 
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertSame(map, result);
        
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.factory.initial = factory"));
        assertTrue(LogUTUtil.checkInfo("java.naming.provider.url = url"));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.principal = username"));
        assertTrue(LogUTUtil.checkInfo("java.naming.security.credentials = "));

        Properties props = support.getJndiEnvironment();
        assertEquals("factory", props.get(Context.INITIAL_CONTEXT_FACTORY));
        assertEquals("url", props.get(Context.PROVIDER_URL));
        assertEquals("username", props.get(Context.SECURITY_PRINCIPAL));
        assertEquals("", props.get(Context.SECURITY_CREDENTIALS));
    }

    /**
     * testInitialize06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FD
     * <br><br>
     * ͒lF() jndiEnvironmentMap.get("factory")F"factory"<br>
     *         () jndiEnvironmentMap.get("url")F"url"<br>
     *         () jndiEnvironmentMap.get("username")F"username"<br>
     *         () jndiEnvironmentMap.get("password")F"password"<br>
     *
     * <br>
     * ҒlF(ԕω) jndiEnvironmentMap:not null<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.INITIAL_CONTEXT_FACTORY):"factory"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.PROVIDER_URL):"url"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_PRINCIPAL):"username"<br>
     *         (ԕω) getJndiTemplate().get(<br>
     *                    Context.SECURITY_CREDENTIALS):"password"<br>
     *         (ԕω) O:O<br>
     *                    CtHOF<br>
     *                    "java.naming.factory.initial = factory"<br>
     *                    "java.naming.provider.url = url"<br>
     *                    "java.naming.security.principal = username"<br>
     *                    "java.naming.security.credentials = password"<br>
     *
     * <br>
     * jndiEnvironmentMapɊi[Ă"factory", "url", "username", 
     * "password"nullł󕶎łȂꍇAJndiTemplate̊
     * vpeBjndiFactoryAjndiUrlAjndiUsernameAjndiPasswordݒ肳Ă邱ƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testInitialize06() throws Exception {
        // O
        Map<String, String> map = new HashMap<String, String>();
        map.put("factory", "factory");
        map.put("url", "url");
        map.put("username", "username");
        map.put("password", "password");
        
        DefaultJndiSupport support = new DefaultJndiSupport();
        UTUtil.setPrivateField(support, "jndiEnvironmentMap", map);

        // eXg{
        support.initialize();
        
        // 
        Object result = UTUtil.getPrivateField(support, "jndiEnvironmentMap");
        assertSame(map, result);
        
        assertTrue(LogUTUtil.checkInfo("java.naming.factory.initial = factory"));
        assertTrue(LogUTUtil.checkInfo("java.naming.provider.url = url"));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.principal = username"));
        assertTrue(LogUTUtil.checkInfo(
                "java.naming.security.credentials = password"));

        Properties props = support.getJndiEnvironment();
        assertEquals("factory", props.get(Context.INITIAL_CONTEXT_FACTORY));
        assertEquals("url", props.get(Context.PROVIDER_URL));
        assertEquals("username", props.get(Context.SECURITY_PRINCIPAL));
        assertEquals("password", props.get(Context.SECURITY_CREDENTIALS));
    }

    /**
     * testRebind01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *         () obj:"abc"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal arguments error : name=" + name + ", obj=" + obj<br>
     *
     * <br>
     * namenull̏ꍇAONƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRebind01() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = null;
        Object obj = "abc";

        try {
            // eXg{
            support.rebind(name, obj);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(LogUTUtil.checkError(
                    "Illegal arguments error : name=null, obj=abc"));
        }
    }

    /**
     * testRebind02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""<br>
     *         () obj:"abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub01<br>
     *         () super.<br>
     *                resourceRef:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallRebind:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                obj:null<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallRebind:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:""<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    obj:"abc"<br>
     *
     * <br>
     * name󕶎łAobjnot null̏ꍇAJndiTemplate.rebind()̌ĂяomFs
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRebind02() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "";
        Object obj = "abc";


        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub01 template =
            new DefaultJndiSupport_JndiTemplateStub01();
        template.setCallRebind(false);
        template.setJndiNameToUse(null);
        template.setObj(null);
        support.setJndiTemplate(template);

        // super.resourceRef = false;
        support.setResourceRef(false);

        // eXg{
        support.rebind(name, obj);

        // 
        boolean b = template.isCallRebind();
        assertTrue(b);
        assertEquals("", template.getJndiNameToUse());
        assertEquals("abc", template.getObj());
    }

    /**
     * testRebind03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () obj:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal arguments error : name=" + name + ", obj=" + obj<br>
     *
     * <br>
     * objnull̏ꍇAONƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRebind03() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "abc";
        Object obj = null;

        try {
            // eXg{
            support.rebind(name, obj);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(LogUTUtil.checkError(
                    "Illegal arguments error : name=abc, obj=null"));
        }
    }

    /**
     * testRebind04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () obj:"abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub01<br>
     *         () super.<br>
     *                resourceRef:true<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallRebind:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                obj:null<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallRebind:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:"java:comp/env/abc"<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    obj:"abc"<br>
     *
     * <br>
     * jndiPrefixtruełAname"java:comp/env/"Ŏn܂ȂꍇA
     * "java:comp/env/"nameɉJndiTemplate.rebind()̌Ăяo
     * sĂ邱ƂmFs
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRebind04() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "abc";
        Object obj = "abc";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub01 template =
            new DefaultJndiSupport_JndiTemplateStub01();
        template.setCallRebind(false);
        template.setJndiNameToUse(null);
        template.setObj(null);
        support.setJndiTemplate(template);

        // super.resourceRef = true;
        support.setResourceRef(true);

        // eXg{
        support.rebind(name, obj);

        // 
        boolean b = template.isCallRebind();
        assertTrue(b);
        assertEquals("java:comp/env/abc", template.getJndiNameToUse());
        assertEquals("abc", template.getObj());
    }

    /**
     * testRebind05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"java:comp/env/abc"<br>
     *         () obj:"abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub02<br>
     *         () super.<br>
     *                resourceRef:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallRebind:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                obj:null<br>
     *         () NamingException:<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallRebind:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:"java:comp/env/abc"<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    obj:"abc"<br>
     *         (ԕω) O:JndiExceptionF<br>
     *                    bvOFNamingException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal JNDI context name."<br>
     *
     * <br>
     * JndiTemplate.rebind()NamingExceptionꍇAJndiException
     * NƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testRebind05() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "java:comp/env/abc";
        Object obj = "abc";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub02 template =
            new DefaultJndiSupport_JndiTemplateStub02();
        template.setCallRebind(false);
        template.setJndiNameToUse(null);
        template.setObj(null);
        support.setJndiTemplate(template);

        // super.resourceRef = false;
        support.setResourceRef(false);

        try {
            // eXg{
            support.rebind(name, obj);
            fail();
        } catch (JndiException e) {
            boolean b = template.isCallRebind();
            assertTrue(b);
            assertEquals("java:comp/env/abc", template.getJndiNameToUse());
            assertEquals("abc", template.getObj());

            // 
            assertEquals(NamingException.class.getName(),
                    e.getCause().getClass().getName());
            assertTrue(LogUTUtil.checkError("Illegal JNDI context name."));
        }
    }

    /**
     * testUnbind01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal arguments error : name=" + name<br>
     *
     * <br>
     * namenull̏ꍇAONƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testUnbind01() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = null;

        try {
            // eXg{
            support.unbind(name);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(LogUTUtil.checkError(
                    "Illegal arguments error : name=null"));
        }
    }

    /**
     * testUnbind02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub01<br>
     *         () super.<br>
     *                resourceRef:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallUnbind:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallUnbind:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:""<br>
     *
     * <br>
     * name󕶎̏ꍇAJndiTemplate.unbind()̌ĂяomFs
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testUnbind02() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub01 template =
            new DefaultJndiSupport_JndiTemplateStub01();
        template.setCallUnbind(false);
        template.setJndiNameToUse(null);

        support.setJndiTemplate(template);

        // super.resourceRef = false;
        support.setResourceRef(false);

        // eXg{
        support.unbind(name);

        // 
        boolean b = template.isCallUnbind();
        assertTrue(b);
        assertEquals("", template.getJndiNameToUse());
    }

    /**
     * testUnbind03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub01<br>
     *         () super.<br>
     *                resourceRef:true<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallUnbind:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallUnbind:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:"java:comp/env/abc"<br>
     *
     * <br>
     * super.resourceReftruełAname"java:comp/env/"
     * n܂ȂꍇA"java:comp/env/"nameɉ
     * JndiTemplate.unbind()̌ĂяosĂ邱ƂmFs
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testUnbind03() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "abc";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub01 template =
            new DefaultJndiSupport_JndiTemplateStub01();
        template.setCallRebind(false);
        template.setJndiNameToUse(null);

        support.setJndiTemplate(template);

        // super.resourceRef = true;
        support.setResourceRef(true);

        // eXg{
        support.unbind(name);

        // 
        boolean b = template.isCallUnbind();
        assertTrue(b);
        assertEquals("java:comp/env/abc", template.getJndiNameToUse());
    }

    /**
     * testUnbind04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"java:comp/env/abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub02<br>
     *         () super.<br>
     *                resourceRef:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallUnbind:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () NamingException:<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallUnbind:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:"java:comp/env/abc"<br>
     *         (ԕω) O:JndiExceptionF<br>
     *                    bvOFNamingException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal JNDI context name."<br>
     *
     * <br>
     * JndiTemplate.unbind()NamingExceptionꍇAJndiException
     * NƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testUnbind04() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "java:comp/env/abc";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub02 template =
            new DefaultJndiSupport_JndiTemplateStub02();
        template.setCallRebind(false);
        template.setJndiNameToUse(null);

        support.setJndiTemplate(template);

        // super.resourceRef = false;
        support.setResourceRef(false);

        try {
            // eXg{
            support.unbind(name);
            fail();
        } catch (JndiException e) {
            boolean b = template.isCallUnbind();
            assertTrue(b);
            assertEquals("java:comp/env/abc", template.getJndiNameToUse());

            // 
            assertTrue(LogUTUtil.checkError("Illegal JNDI context name."));
            assertEquals(NamingException.class.getName(),
                    e.getCause().getClass().getName());
        }
    }

    /**
     * testLookup01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal arguments error : name=" + name<br>
     *
     * <br>
     * namenull̏ꍇAONƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLookup01() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = null;

        try {
            // eXg{
            support.lookup(name);
            fail();
        } catch (IllegalArgumentException e) {
            // 
            assertTrue(LogUTUtil.checkError(
                    "Illegal arguments error : name=null"));
        }
    }

    /**
     * testLookup02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:""<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub01<br>
     *         () super.<br>
     *                resourceRef:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallLookup:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                lookup()߂l:"return"<br>
     *
     * <br>
     * ҒlF(߂l) Object:"return"<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallLookup:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:""<br>
     *
     * <br>
     * name󕶎̏ꍇAJndiTemplate.lookup()̌ĂяomFs
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLookup02() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub01 template =
            new DefaultJndiSupport_JndiTemplateStub01();
        template.setCallLookup(false);
        template.setJndiNameToUse(null);

        support.setJndiTemplate(template);

        // super.resourceRef = false;
        support.setResourceRef(false);

        // eXg{
        Object result = support.lookup(name);

        // 
        boolean b = template.isCallLookup();
        assertTrue(b);
        assertEquals("", template.getJndiNameToUse());
        assertEquals("return", result);
    }

    /**
     * testLookup03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() name:"abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub01<br>
     *         () super.<br>
     *                resourceRef:true<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallLookup:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                lookup()߂l:"return"<br>
     *
     * <br>
     * ҒlF(߂l) Object:"return"<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallLookup:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:"java:comp/env/abc"<br>
     *
     * <br>
     * jndiPrefixtruełAname"java:comp/env/"Ŏn܂ȂꍇA
     * "java:comp/env/"nameɉJndiTemplate.lookup()̌Ăяo
     * sĂ邱ƂmFs
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLookup03() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "abc";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub01 template =
            new DefaultJndiSupport_JndiTemplateStub01();
        template.setCallLookup(false);
        template.setJndiNameToUse(null);

        support.setJndiTemplate(template);

        // super.resourceRef = true;
        support.setResourceRef(true);

        // eXg{
        Object result = support.lookup(name);

        // 
        boolean b = template.isCallLookup();
        assertTrue(b);
        assertEquals("java:comp/env/abc", template.getJndiNameToUse());
        assertEquals("return", result);
    }

    /**
     * testLookup04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() name:"java:comp/env/abc"<br>
     *         () JndiTemplate:DefaultJndiSupport_JndiTemplate_Stub02<br>
     *         () super.<br>
     *                resourceRef:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                isCallLookup:false<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                jndiNameToUse:null<br>
     *         () DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                lookup()߂l:"return"<br>
     *         () NamingException:<br>
     *
     * <br>
     * ҒlF(ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    isCallLookup:true<br>
     *         (ԕω) DefaultJndiSupport_JndiTemplate_Stub01.<br>
     *                    jndiNameToUse:"java:comp/env/abc"<br>
     *         (ԕω) O:JndiExceptionF<br>
     *                    bvOFNamingException<br>
     *         (ԕω) O:O<br>
     *                    G[OF<br>
     *                    "Illegal JNDI context name."<br>
     *
     * <br>
     * JndiTemplate.lookup()NamingExceptionꍇA
     * JndiExceptionNƂmF
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testLookup04() throws Exception {
        // O
        DefaultJndiSupport support = new DefaultJndiSupport();

        String name = "java:comp/env/abc";

        // JndiTemplate擾
        DefaultJndiSupport_JndiTemplateStub02 template =
            new DefaultJndiSupport_JndiTemplateStub02();
        template.setCallLookup(false);
        template.setJndiNameToUse(null);

        support.setJndiTemplate(template);

        // super.resourceRef = false;
        support.setResourceRef(false);

        try {
            // eXg{
            support.lookup(name);
            fail();
        } catch (JndiException e) {
            boolean b = template.isCallLookup();
            assertTrue(b);
            assertEquals("java:comp/env/abc", template.getJndiNameToUse());

            // 
            assertTrue(LogUTUtil.checkError("Illegal JNDI context name."));
            assertEquals(NamingException.class.getName(),
                    e.getCause().getClass().getName());
        }
    }
}