/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;


/**
 * e[ũJi[NXB
 * JUnitpX^uCu̒œIɗpB
 * 
 */
class DBColumnInfo {

    /**
     * ^J̃ftHglB
     */
    private static final String DEFAULT_CHAR = "X";

    /**
     * l^J̃ftHglB
     */
    private static final String DEFAULT_NUM = "9";

    /**
     * t^J̃ftHglB
     */
    private static final String DEFAULT_DATETIME = "2000-01-01 00:00:00";

    /**
     * ^̃J̃ftHglB
     */
    private static final String DEFAULT_OTHER = "0";

    /**
     * JB
     */
    private String name;

    /**
     * JJDBC_SQL^B
     */
    private int sqlType;

    /**
     * JNULLہB
     */
    private boolean nullable;

    /**
     * RXgN^B
     * ̃NXsetter͂Ȃ̂ŁAׂĂ̒l̓RXgN^Őݒ肷B
     * 
     * @param name J
     * @param sqlType JJDBC_SQL^
     * @param nullable JNULL
     */
    public DBColumnInfo(String name, int sqlType, boolean nullable) {
        this.name = name;
        this.sqlType = sqlType;
        this.nullable = nullable;
    }

    /**
     * J̎擾B
     * 
     * @return J
     */
    public String getName() {
        return name;
    }

    /**
     * JJDBC_SQL^̎擾B
     * 
     * @return JJDBC_SQL^
     */
    public int getSqlType() {
        return sqlType;
    }

    /**
     * JNULLۂ̎擾B
     * 
     * @return JNULL
     */
    public boolean isNullable() {
        return nullable;
    }

    /**
     * J̃ftHgl̎擾B
     * 
     * @return J̃ftHgl
     */
    public String getDefaultValue() {
        // k̏ꍇnullԂB
        if (nullable) {
            return null;
        }

        // ks̏ꍇ͌^ɂKȃftHglԂB
        switch (sqlType) {
            case java.sql.Types.TINYINT :
            case java.sql.Types.SMALLINT :
            case java.sql.Types.INTEGER :
            case java.sql.Types.BIGINT :
            case java.sql.Types.REAL :
            case java.sql.Types.FLOAT :
            case java.sql.Types.DOUBLE :
            case java.sql.Types.DECIMAL :
            case java.sql.Types.NUMERIC :
                return DEFAULT_NUM;
            case java.sql.Types.CHAR :
            case java.sql.Types.VARCHAR :
                return DEFAULT_CHAR;
            case java.sql.Types.DATE :
            case java.sql.Types.TIME :
            case java.sql.Types.TIMESTAMP :
                return DEFAULT_DATETIME;
            default :
                return DEFAULT_OTHER;
        }
    }
}
