/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

public class IndexType {
    private boolean primaryKey;
    private boolean persistent;
    private boolean unique;
    private boolean hash;
    private boolean scan;
    private boolean belongsToConstraint;

    public static IndexType createPrimaryKey(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.primaryKey = true;
        indexType.persistent = bl;
        indexType.hash = bl2;
        indexType.unique = true;
        return indexType;
    }

    public static IndexType createUnique(boolean bl, boolean bl2) {
        IndexType indexType = new IndexType();
        indexType.unique = true;
        indexType.persistent = bl;
        indexType.hash = bl2;
        return indexType;
    }

    public static IndexType createNonUnique(boolean bl) {
        IndexType indexType = new IndexType();
        indexType.persistent = bl;
        return indexType;
    }

    public static IndexType createScan(boolean bl) {
        IndexType indexType = new IndexType();
        indexType.persistent = bl;
        indexType.scan = true;
        return indexType;
    }

    public void setBelongsToConstraint(boolean bl) {
        this.belongsToConstraint = bl;
    }

    public boolean getBelongsToConstraint() {
        return this.belongsToConstraint;
    }

    public boolean getHash() {
        return this.hash;
    }

    public boolean getPersistent() {
        return this.persistent;
    }

    public boolean getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean getUnique() {
        return this.unique;
    }

    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.primaryKey) {
            stringBuffer.append("PRIMARY KEY");
            if (this.hash) {
                stringBuffer.append(" HASH");
            }
        } else {
            if (this.unique) {
                stringBuffer.append("UNIQUE ");
            }
            if (this.hash) {
                stringBuffer.append("HASH ");
            }
            stringBuffer.append("INDEX");
        }
        return stringBuffer.toString();
    }

    public boolean getScan() {
        return this.scan;
    }
}

